/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class WeightedAverageYoBoolean
extends YoBoolean {
    private final List<DoubleProvider> booleanWeights = new ArrayList<DoubleProvider>();
    private final List<BooleanProvider> booleansToAverage = new ArrayList<BooleanProvider>();
    private final boolean biasToPositive;

    public WeightedAverageYoBoolean(String name, YoRegistry registry) {
        this(name, registry, false);
    }

    public WeightedAverageYoBoolean(String name, YoRegistry registry, boolean biasToPositive) {
        super(name, "WeightedAverageYoBoolean", registry);
        this.biasToPositive = biasToPositive;
    }

    public void addBooleanToAverage(DoubleProvider booleanWeight, BooleanProvider booleanToAverage) {
        this.booleanWeights.add(booleanWeight);
        this.booleansToAverage.add(booleanToAverage);
    }

    public boolean update() {
        int numberOfBooleans = this.booleanWeights.size();
        double totalWeight = 0.0;
        double estimatedValue = 0.0;
        for (int i = 0; i < numberOfBooleans; ++i) {
            double weight = this.booleanWeights.get(i).getValue();
            estimatedValue += weight * (this.booleansToAverage.get(i).getValue() ? 1.0 : 0.0);
            totalWeight += weight;
        }
        if (totalWeight <= 0.0) {
            throw new RuntimeException("Invalid weights in the weighted average variable.");
        }
        return this.evaluate(estimatedValue /= totalWeight);
    }

    private boolean evaluate(double estimatedValue) {
        if (this.biasToPositive) {
            if (estimatedValue >= 0.5) {
                this.set(true);
                return true;
            }
            this.set(false);
            return false;
        }
        if (estimatedValue > 0.5) {
            this.set(true);
            return true;
        }
        this.set(false);
        return false;
    }
}

