/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class SimpleMovingAverageFilteredYoVariable
extends YoDouble {
    private final YoInteger windowSize;
    private final YoDouble yoVariableToFilter;
    private final DMatrixRMaj previousUpdateValues = new DMatrixRMaj(0, 0);
    private int bufferPosition = 0;
    private boolean bufferHasBeenFilled = false;

    public SimpleMovingAverageFilteredYoVariable(String name, int windowSize, YoRegistry registry) {
        this(name, windowSize, null, registry);
    }

    public SimpleMovingAverageFilteredYoVariable(String name, int windowSize, YoDouble yoVariableToFilter, YoRegistry registry) {
        super(name, registry);
        this.yoVariableToFilter = yoVariableToFilter;
        this.windowSize = new YoInteger(name + "WindowSize", registry);
        this.windowSize.set(windowSize);
        this.previousUpdateValues.reshape(windowSize, 1);
        CommonOps_DDRM.fill((DMatrixD1)this.previousUpdateValues, (double)0.0);
    }

    public void setWindowSize(int windowSize) {
        this.windowSize.set(windowSize);
        this.reset();
    }

    public void update() {
        this.update(this.yoVariableToFilter.getDoubleValue());
    }

    public void update(double value) {
        if (this.previousUpdateValues.getNumRows() != this.windowSize.getIntegerValue()) {
            this.reset();
        }
        this.previousUpdateValues.set(this.bufferPosition, 0, value);
        ++this.bufferPosition;
        if (this.bufferPosition >= this.windowSize.getIntegerValue()) {
            this.bufferPosition = 0;
            this.bufferHasBeenFilled = true;
        }
        double average = 0.0;
        for (int i = 0; i < this.windowSize.getIntegerValue(); ++i) {
            average += this.previousUpdateValues.get(i, 0);
        }
        this.set(average / (double)this.windowSize.getIntegerValue());
    }

    public void reset() {
        this.bufferPosition = 0;
        this.bufferHasBeenFilled = false;
        this.previousUpdateValues.reshape(this.windowSize.getIntegerValue(), 1);
    }

    public boolean getHasBufferWindowFilled() {
        return this.bufferHasBeenFilled;
    }
}

