/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.robotics.math.filters.ProcessingYoVariable;
import us.ihmc.robotics.math.filters.SecondOrderFilterType;
import us.ihmc.robotics.math.filters.SecondOrderFilteredYoVariable;
import us.ihmc.robotics.math.filters.SecondOrderFilteredYoVariableParameters;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class SecondOrderFilteredYoFrameVector
extends YoFrameVector3D
implements ProcessingYoVariable {
    private final SecondOrderFilteredYoVariable x;
    private final SecondOrderFilteredYoVariable y;
    private final SecondOrderFilteredYoVariable z;

    private SecondOrderFilteredYoFrameVector(SecondOrderFilteredYoVariable x, SecondOrderFilteredYoVariable y, SecondOrderFilteredYoVariable z, ReferenceFrame referenceFrame) {
        super((YoDouble)x, (YoDouble)y, (YoDouble)z, referenceFrame);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static SecondOrderFilteredYoFrameVector createSecondOrderFilteredYoFrameVector(String namePrefix, String nameSuffix, YoRegistry registry, double dt, double naturalFrequencyInHz, double dampingRatio, SecondOrderFilterType filterType, ReferenceFrame referenceFrame) {
        SecondOrderFilteredYoVariableParameters parameters = new SecondOrderFilteredYoVariableParameters(namePrefix + nameSuffix, registry, naturalFrequencyInHz, dampingRatio, filterType);
        return SecondOrderFilteredYoFrameVector.createSecondOrderFilteredYoFrameVector(namePrefix, nameSuffix, registry, dt, parameters, referenceFrame);
    }

    public static SecondOrderFilteredYoFrameVector createSecondOrderFilteredYoFrameVector(String namePrefix, String nameSuffix, YoRegistry registry, double dt, SecondOrderFilteredYoVariableParameters parameters, ReferenceFrame referenceFrame) {
        SecondOrderFilteredYoVariable x = new SecondOrderFilteredYoVariable(YoGeometryNameTools.createXName((String)namePrefix, (String)nameSuffix), registry, dt, parameters);
        SecondOrderFilteredYoVariable y = new SecondOrderFilteredYoVariable(YoGeometryNameTools.createYName((String)namePrefix, (String)nameSuffix), registry, dt, parameters);
        SecondOrderFilteredYoVariable z = new SecondOrderFilteredYoVariable(YoGeometryNameTools.createZName((String)namePrefix, (String)nameSuffix), registry, dt, parameters);
        return new SecondOrderFilteredYoFrameVector(x, y, z, referenceFrame);
    }

    public static SecondOrderFilteredYoFrameVector createSecondOrderFilteredYoFrameVector(String namePrefix, String nameSuffix, YoRegistry registry, double dt, double naturalFrequencyInHz, double dampingRatio, SecondOrderFilterType filterType, YoFrameVector3D unfilteredVector) {
        SecondOrderFilteredYoVariableParameters parameters = new SecondOrderFilteredYoVariableParameters(namePrefix + nameSuffix, registry, naturalFrequencyInHz, dampingRatio, filterType);
        return SecondOrderFilteredYoFrameVector.createSecondOrderFilteredYoFrameVector(namePrefix, nameSuffix, registry, dt, parameters, unfilteredVector);
    }

    public static SecondOrderFilteredYoFrameVector createSecondOrderFilteredYoFrameVector(String namePrefix, String nameSuffix, YoRegistry registry, double dt, SecondOrderFilteredYoVariableParameters parameters, YoFrameVector3D unfilteredVector) {
        SecondOrderFilteredYoVariable x = new SecondOrderFilteredYoVariable(YoGeometryNameTools.createXName((String)namePrefix, (String)nameSuffix), registry, dt, parameters, unfilteredVector.getYoX());
        SecondOrderFilteredYoVariable y = new SecondOrderFilteredYoVariable(YoGeometryNameTools.createYName((String)namePrefix, (String)nameSuffix), registry, dt, parameters, unfilteredVector.getYoY());
        SecondOrderFilteredYoVariable z = new SecondOrderFilteredYoVariable(YoGeometryNameTools.createZName((String)namePrefix, (String)nameSuffix), registry, dt, parameters, unfilteredVector.getYoZ());
        return new SecondOrderFilteredYoFrameVector(x, y, z, unfilteredVector.getReferenceFrame());
    }

    @Override
    public void update() {
        this.x.update();
        this.y.update();
        this.z.update();
    }

    public void update(double xUnfiltered, double yUnfiltered, double zUnfiltered) {
        this.x.update(xUnfiltered);
        this.y.update(yUnfiltered);
        this.z.update(zUnfiltered);
    }

    public void update(Vector3D vectorUnfiltered) {
        this.x.update(vectorUnfiltered.getX());
        this.y.update(vectorUnfiltered.getY());
        this.z.update(vectorUnfiltered.getZ());
    }

    public void update(FrameVector3D vectorUnfiltered) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)vectorUnfiltered);
        this.x.update(vectorUnfiltered.getX());
        this.y.update(vectorUnfiltered.getY());
        this.z.update(vectorUnfiltered.getZ());
    }

    @Override
    public void reset() {
        this.x.reset();
        this.y.reset();
        this.z.reset();
    }
}

