/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.dataStructures.ObsoletePolynomial;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class InfiniteImpulseResponseFilteredYoVariable
extends YoDouble {
    private final boolean DEBUG = true;
    private final int numPoles;
    private final int numZeros;
    private final double[] denominatorCoefficients;
    private final double[] numeratorCoefficients;
    private final double[] previousX;
    private final double[] previousY;

    public InfiniteImpulseResponseFilteredYoVariable(String name, int numPoles, int numZeros, YoRegistry registry) {
        super(name, registry);
        this.numPoles = numPoles;
        this.numZeros = numZeros;
        this.numeratorCoefficients = new double[numZeros + 1];
        this.denominatorCoefficients = new double[numPoles + 1];
        this.previousX = new double[numZeros];
        this.previousY = new double[numPoles];
    }

    public void setCoefficients(double[] numeratorCoefficients, double[] denominatorCoefficients) {
        int i;
        if (numeratorCoefficients.length != this.numeratorCoefficients.length) {
            throw new RuntimeException("Wrong number of coefficients in b! numeratorCoefficients.length = " + numeratorCoefficients.length + ", this.numeratorCoefficients.length = " + this.numeratorCoefficients.length);
        }
        if (denominatorCoefficients.length != this.denominatorCoefficients.length) {
            throw new RuntimeException("Wrong number of coefficients in a! denominatorCoefficients.length = " + denominatorCoefficients.length + ", this.denominatorCoefficients = " + this.denominatorCoefficients.length);
        }
        for (i = 0; i < numeratorCoefficients.length; ++i) {
            this.numeratorCoefficients[i] = numeratorCoefficients[i];
        }
        for (i = 0; i < denominatorCoefficients.length; ++i) {
            this.denominatorCoefficients[i] = denominatorCoefficients[i];
        }
        System.out.println("numeratorCoefficients = " + this.coefficientsToString(numeratorCoefficients));
        System.out.println("denominatorCoefficients = " + this.coefficientsToString(denominatorCoefficients));
    }

    private String coefficientsToString(double[] coefficients) {
        Object ret = "[";
        for (int i = 0; i < coefficients.length; ++i) {
            ret = (String)ret + coefficients[i] + " ";
        }
        ret = (String)ret + "]";
        return ret;
    }

    public void setPolesAndZeros(double[] realPoles, ComplexNumber[] complexPairPoles, double[] realZeros, ComplexNumber[] complexPairZeros) {
        this.setPolesAndZeros(1.0, realPoles, complexPairPoles, realZeros, complexPairZeros);
        double numeratorSum = 0.0;
        double denominatorSum = 0.0;
        for (double numeratorCoefficient : this.numeratorCoefficients) {
            numeratorSum += numeratorCoefficient;
        }
        for (double denominatorCoefficient : this.denominatorCoefficients) {
            denominatorSum += denominatorCoefficient;
        }
        double evalAtZEqualsOne = numeratorSum / denominatorSum;
        for (int i = 0; i < this.numeratorCoefficients.length; ++i) {
            this.numeratorCoefficients[i] = this.numeratorCoefficients[i] / evalAtZEqualsOne;
        }
    }

    public void setPolesAndZeros(double dcScale, double[] realPoles, ComplexNumber[] complexPairPoles, double[] realZeros, ComplexNumber[] complexPairZeros) {
        ObsoletePolynomial numeratorPolynomial = ObsoletePolynomial.constructFromScaleFactorAndRoots(dcScale, realZeros, complexPairZeros);
        ObsoletePolynomial denominatorPolynomial = ObsoletePolynomial.constructFromScaleFactorAndRoots(1.0, realPoles, complexPairPoles);
        System.out.println("denominatorPolynomial = " + denominatorPolynomial);
        System.out.println("numeratorPolynomial = " + numeratorPolynomial);
        this.setCoefficients(numeratorPolynomial.getCoefficients(), denominatorPolynomial.getCoefficients());
    }

    public void update(double currentX) {
        int i;
        double currentY = this.getDoubleValue();
        double newVal = 0.0;
        for (i = 0; i < this.numPoles; ++i) {
            newVal -= this.denominatorCoefficients[i + 1] * this.previousY[i];
        }
        for (i = 0; i < this.numZeros; ++i) {
            newVal += this.numeratorCoefficients[i + 1] * this.previousX[i];
        }
        this.set(newVal += this.numeratorCoefficients[0] * currentX);
        for (i = this.numPoles - 1; i > 0; --i) {
            this.previousY[i] = this.previousY[i - 1];
        }
        if (this.previousY.length > 0) {
            this.previousY[0] = newVal;
        }
        for (i = this.numZeros - 1; i > 0; --i) {
            this.previousX[i] = this.previousX[i - 1];
        }
        if (this.previousX.length > 0) {
            this.previousX[0] = currentX;
        }
        throw new RuntimeException("This needs to be tested before trusting it. Check out the main and write a JUnit test case!");
    }
}

