/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class FilteredDiscreteVelocityYoVariable
extends YoDouble {
    private final double alpha;
    private final YoDouble time;
    private final YoDouble alphaVariable;
    private final YoDouble position;
    private final YoDouble lastUpdateTime;
    private final YoEnum<Direction> lastUpdateDirection;
    private final YoDouble unfilteredVelocity;
    private final YoDouble lastPosition;
    private boolean hasBeenCalled;

    public FilteredDiscreteVelocityYoVariable(String name, String description, double alpha, YoDouble time, YoRegistry registry) {
        super(name, description, registry);
        this.alpha = alpha;
        this.alphaVariable = null;
        this.position = null;
        this.time = time;
        this.lastPosition = new YoDouble(name + "_lastPosition", registry);
        this.lastUpdateTime = new YoDouble(name + "_lastUpdateTime", registry);
        this.lastUpdateDirection = new YoEnum(name + "_lastUpdateDirection", registry, Direction.class);
        this.unfilteredVelocity = new YoDouble(name + "_unfilteredVelocity", registry);
        this.reset();
    }

    public FilteredDiscreteVelocityYoVariable(String name, String description, double alpha, YoDouble positionVariable, YoDouble time, YoRegistry registry) {
        super(name, description, registry);
        this.alpha = alpha;
        this.position = positionVariable;
        this.alphaVariable = null;
        this.time = time;
        this.lastPosition = new YoDouble(name + "_lastPosition", registry);
        this.lastUpdateTime = new YoDouble(name + "_lastUpdateTime", registry);
        this.lastUpdateDirection = new YoEnum(name + "_lastUpdateDirection", registry, Direction.class);
        this.unfilteredVelocity = new YoDouble(name + "_unfilteredVelocity", registry);
        this.reset();
    }

    public FilteredDiscreteVelocityYoVariable(String name, String description, YoDouble alphaVariable, YoDouble positionVariable, YoDouble time, YoRegistry registry) {
        super(name, description, registry);
        this.position = positionVariable;
        this.alphaVariable = alphaVariable;
        this.alpha = 0.0;
        this.time = time;
        this.lastPosition = new YoDouble(name + "_lastPosition", registry);
        this.lastUpdateTime = new YoDouble(name + "_lastUpdateTime", registry);
        this.lastUpdateDirection = new YoEnum(name + "_lastUpdateDirection", registry, Direction.class);
        this.unfilteredVelocity = new YoDouble(name + "_unfilteredVelocity", registry);
        this.reset();
    }

    public void reset() {
        this.hasBeenCalled = false;
    }

    public void update() {
        if (this.position == null) {
            throw new NullPointerException("YoFilteredVelocityVariable must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.position.getDoubleValue());
    }

    public void update(double currentPosition) {
        if (!this.hasBeenCalled) {
            this.hasBeenCalled = true;
            this.lastPosition.set(currentPosition);
            this.lastUpdateTime.set(this.time.getDoubleValue());
            this.lastUpdateDirection.set((Enum)Direction.NONE);
        }
        double alphaToUse = this.alpha;
        if (this.alphaVariable != null) {
            alphaToUse = this.alphaVariable.getDoubleValue();
        }
        boolean countChanged = false;
        if (currentPosition != this.lastPosition.getDoubleValue()) {
            countChanged = true;
        }
        boolean directionChanged = false;
        if (countChanged) {
            if (currentPosition > this.lastPosition.getDoubleValue()) {
                if (this.lastUpdateDirection.getEnumValue() != Direction.FORWARD) {
                    directionChanged = true;
                }
                this.lastUpdateDirection.set((Enum)Direction.FORWARD);
            } else if (currentPosition < this.lastPosition.getDoubleValue()) {
                if (this.lastUpdateDirection.getEnumValue() != Direction.BACKWARD) {
                    directionChanged = true;
                }
                this.lastUpdateDirection.set((Enum)Direction.BACKWARD);
            }
        }
        if (directionChanged) {
            this.unfilteredVelocity.set(0.0);
        } else if (countChanged) {
            double diffTime = this.time.getDoubleValue() - this.lastUpdateTime.getDoubleValue();
            if (diffTime < 1.0E-7) {
                this.unfilteredVelocity.set(0.0);
            } else {
                this.unfilteredVelocity.set((currentPosition - this.lastPosition.getDoubleValue()) / diffTime);
            }
        } else {
            this.unfilteredVelocity.set(0.99 * this.unfilteredVelocity.getDoubleValue());
        }
        this.set(alphaToUse * this.getDoubleValue() + (1.0 - alphaToUse) * this.unfilteredVelocity.getDoubleValue());
        if (countChanged) {
            this.lastPosition.set(currentPosition);
            this.lastUpdateTime.set(this.time.getDoubleValue());
        }
    }

    public double getUnfilteredVelocity() {
        return this.unfilteredVelocity.getDoubleValue();
    }

    private static enum Direction {
        NONE,
        FORWARD,
        BACKWARD;

    }
}

