/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class BetaFilteredYoVariable
extends YoDouble {
    private int beta;
    private int index = 0;
    private final YoDouble betaVariable;
    private final YoDouble position;
    private static double[] raw;
    private final YoBoolean hasBeenCalled;

    public BetaFilteredYoVariable(String name, YoRegistry registry, int beta) {
        this(name, "", registry, beta, null);
    }

    public BetaFilteredYoVariable(String name, String description, YoRegistry registry, int beta) {
        this(name, description, registry, beta, null);
    }

    public BetaFilteredYoVariable(String name, YoRegistry registry, int beta, YoDouble positionVariable) {
        this(name, "", registry, beta, positionVariable);
    }

    public BetaFilteredYoVariable(String name, String description, YoRegistry registry, int beta, YoDouble positionVariable) {
        super(name, description, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.beta = beta;
        this.position = positionVariable;
        this.betaVariable = null;
        raw = new double[beta];
        this.reset();
    }

    public void reset() {
        this.hasBeenCalled.set(false);
        for (int i = 0; i < this.beta; ++i) {
            this.set(0.0);
        }
    }

    public void update() {
        if (this.position == null) {
            throw new NullPointerException("BetaFilteredYoVariable must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.position.getDoubleValue());
    }

    public void update(double currentPosition) {
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.hasBeenCalled.set(true);
            this.set(currentPosition);
        }
        BetaFilteredYoVariable.raw[this.index++] = currentPosition;
        if (this.index == this.beta) {
            this.index = 0;
        }
        this.set(0.0);
        for (int i = 0; i < this.beta; ++i) {
            this.set(this.getDoubleValue() + raw[i]);
        }
        this.set(this.getDoubleValue() / (double)this.beta);
    }
}

