/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.commons.MathTools;
import us.ihmc.robotics.math.filters.ProcessingYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class BacklashProcessingYoVariable
extends YoDouble
implements ProcessingYoVariable {
    private final YoDouble velocity;
    private final YoBoolean hasBeenCalled;
    private final YoEnum<BacklashState> backlashState;
    private final DoubleProvider slopTime;
    private final YoDouble timeSinceSloppy;
    private final double dt;

    public BacklashProcessingYoVariable(String name, String description, double dt, DoubleProvider slopTime, YoRegistry registry) {
        this(name, description, null, dt, slopTime, registry);
    }

    public BacklashProcessingYoVariable(String name, String description, YoDouble velocityVariable, double dt, DoubleProvider slopTime, YoRegistry registry) {
        super(name, description, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.backlashState = new YoEnum(name + "BacklashState", registry, BacklashState.class, true);
        this.backlashState.set(null);
        this.timeSinceSloppy = new YoDouble(name + "TimeSinceSloppy", registry);
        this.velocity = velocityVariable;
        this.slopTime = slopTime;
        this.dt = dt;
        this.reset();
    }

    @Override
    public void reset() {
        this.hasBeenCalled.set(false);
        this.backlashState.set(null);
    }

    @Override
    public void update() {
        if (this.velocity == null) {
            throw new NullPointerException("BacklashProcessingYoVariable must be constructed with a non null velocity variable to call update(), otherwise use update(double)");
        }
        this.update(this.velocity.getDoubleValue());
    }

    public void update(double currentVelocity) {
        if (this.backlashState.getEnumValue() == null) {
            this.backlashState.set((Enum)BacklashState.FORWARD_OK);
        }
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.hasBeenCalled.set(true);
            this.set(currentVelocity);
        }
        this.timeSinceSloppy.add(this.dt);
        switch ((BacklashState)this.backlashState.getEnumValue()) {
            case BACKWARD_OK: {
                if (!(currentVelocity > 0.0)) break;
                this.timeSinceSloppy.set(0.0);
                this.backlashState.set((Enum)BacklashState.FORWARD_SLOP);
                break;
            }
            case FORWARD_OK: {
                if (!(currentVelocity < 0.0)) break;
                this.timeSinceSloppy.set(0.0);
                this.backlashState.set((Enum)BacklashState.BACKWARD_SLOP);
                break;
            }
            case BACKWARD_SLOP: {
                if (currentVelocity > 0.0) {
                    this.timeSinceSloppy.set(0.0);
                    this.backlashState.set((Enum)BacklashState.FORWARD_SLOP);
                    break;
                }
                if (!(this.timeSinceSloppy.getDoubleValue() > this.slopTime.getValue())) break;
                this.backlashState.set((Enum)BacklashState.BACKWARD_OK);
                break;
            }
            case FORWARD_SLOP: {
                if (currentVelocity < 0.0) {
                    this.timeSinceSloppy.set(0.0);
                    this.backlashState.set((Enum)BacklashState.BACKWARD_SLOP);
                    break;
                }
                if (!(this.timeSinceSloppy.getDoubleValue() > this.slopTime.getValue())) break;
                this.backlashState.set((Enum)BacklashState.FORWARD_OK);
            }
        }
        double percent = this.timeSinceSloppy.getDoubleValue() / this.slopTime.getValue();
        percent = MathTools.clamp((double)percent, (double)0.0, (double)1.0);
        if (Double.isNaN(percent) || this.slopTime.getValue() < this.dt) {
            percent = 1.0;
        }
        this.set(percent * currentVelocity);
    }

    private static enum BacklashState {
        BACKWARD_OK,
        FORWARD_OK,
        BACKWARD_SLOP,
        FORWARD_SLOP;

    }
}

