/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class AccelerationLimitedYoFrameVector3D
extends YoFrameVector3D {
    private final DoubleProvider maxRateVariable;
    private final DoubleProvider maxAccelerationVariable;
    private final FrameTuple3DReadOnly rawPosition;
    private final YoBoolean accelerationLimited;
    private final YoBoolean rateLimited;
    private final YoBoolean hasBeenInitialized;
    private final YoDouble positionGain;
    private final YoDouble velocityGain;
    private final YoFrameVector3D smoothedRate;
    private final YoFrameVector3D smoothedAcceleration;
    private final double dt;
    private final FrameVector3D positionError;
    private final FrameVector3D acceleration;

    private static DoubleProvider createMaxRateYoDouble(String namePrefix, String nameSuffix, double initialValue, YoRegistry registry) {
        YoDouble maxRate = new YoDouble(namePrefix + "MaxRate" + nameSuffix, registry);
        maxRate.set(initialValue);
        return maxRate;
    }

    private static DoubleProvider createMaxAccelerationYoDouble(String namePrefix, String nameSuffix, double initialValue, YoRegistry registry) {
        YoDouble maxRate = new YoDouble(namePrefix + "MaxAcceleration" + nameSuffix, registry);
        maxRate.set(initialValue);
        return maxRate;
    }

    public AccelerationLimitedYoFrameVector3D(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, DoubleProvider maxAcceleration, double dt, FrameTuple3DReadOnly rawPosition) {
        this(namePrefix, nameSuffix, registry, maxRate, maxAcceleration, dt, rawPosition, rawPosition.getReferenceFrame());
    }

    public AccelerationLimitedYoFrameVector3D(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, DoubleProvider maxAcceleration, double dt, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, maxRate, maxAcceleration, dt, null, referenceFrame);
    }

    public AccelerationLimitedYoFrameVector3D(String namePrefix, String nameSuffix, YoRegistry registry, double maxRate, double maxAcceleration, double dt, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, AccelerationLimitedYoFrameVector3D.createMaxRateYoDouble(namePrefix, nameSuffix, maxRate, registry), AccelerationLimitedYoFrameVector3D.createMaxAccelerationYoDouble(namePrefix, nameSuffix, maxAcceleration, registry), dt, null, referenceFrame);
    }

    private AccelerationLimitedYoFrameVector3D(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, DoubleProvider maxAcceleration, double dt, FrameTuple3DReadOnly rawPosition, ReferenceFrame referenceFrame) {
        super(namePrefix, nameSuffix, referenceFrame, registry);
        this.positionError = new FrameVector3D(referenceFrame);
        this.acceleration = new FrameVector3D(referenceFrame);
        if (maxRate == null) {
            maxRate = AccelerationLimitedYoFrameVector3D.createMaxRateYoDouble(namePrefix, nameSuffix, Double.POSITIVE_INFINITY, registry);
        }
        if (maxAcceleration == null) {
            maxAcceleration = AccelerationLimitedYoFrameVector3D.createMaxAccelerationYoDouble(namePrefix, nameSuffix, Double.POSITIVE_INFINITY, registry);
        }
        this.maxRateVariable = maxRate;
        this.maxAccelerationVariable = maxAcceleration;
        this.dt = dt;
        this.hasBeenInitialized = new YoBoolean(namePrefix + "HasBeenInitialized" + namePrefix, registry);
        this.rateLimited = new YoBoolean(namePrefix + "RateLimited" + nameSuffix, registry);
        this.accelerationLimited = new YoBoolean(namePrefix + "AccelerationLimited" + nameSuffix, registry);
        this.smoothedRate = new YoFrameVector3D(namePrefix + "SmoothedRate" + namePrefix, referenceFrame, registry);
        this.smoothedAcceleration = new YoFrameVector3D(namePrefix + "SmoothedAcceleration" + namePrefix, referenceFrame, registry);
        this.positionGain = new YoDouble(namePrefix + "PositionGain" + namePrefix, registry);
        this.velocityGain = new YoDouble(namePrefix + "VelocityGain" + namePrefix, registry);
        double w0 = 100.53096491487338;
        double zeta = 1.0;
        this.setGainsByPolePlacement(w0, zeta);
        this.hasBeenInitialized.set(false);
        this.rawPosition = rawPosition;
    }

    public void setGainsByPolePlacement(double w0, double zeta) {
        this.positionGain.set(w0 * w0);
        this.velocityGain.set(2.0 * zeta * w0);
    }

    public void update() {
        if (this.rawPosition == null) {
            throw new NullPointerException(((Object)((Object)this)).getClass().getSimpleName() + " must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.rawPosition);
    }

    public void update(FrameTuple3DReadOnly frameVectorUnfiltered) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)frameVectorUnfiltered);
        this.update(frameVectorUnfiltered.getX(), frameVectorUnfiltered.getY(), frameVectorUnfiltered.getZ());
    }

    public void update(double xUnfiltered, double yUnfiltered, double zUnfiltered) {
        if (!this.hasBeenInitialized.getBooleanValue()) {
            this.initialize(xUnfiltered, yUnfiltered, zUnfiltered);
        }
        this.positionError.set(xUnfiltered, yUnfiltered, zUnfiltered);
        this.positionError.sub((FrameTuple3DReadOnly)this);
        this.acceleration.set((FrameTuple3DReadOnly)this.smoothedRate);
        this.acceleration.scale(-this.velocityGain.getValue());
        this.acceleration.scaleAdd(this.positionGain.getValue(), (FrameTuple3DReadOnly)this.positionError, (FrameTuple3DReadOnly)this.acceleration);
        this.accelerationLimited.set(this.acceleration.clipToMaxLength(this.maxAccelerationVariable.getValue()));
        this.smoothedAcceleration.set((FrameTuple3DReadOnly)this.acceleration);
        this.smoothedRate.scaleAdd(this.dt, (FrameTuple3DReadOnly)this.smoothedAcceleration, (FrameTuple3DReadOnly)this.smoothedRate);
        this.rateLimited.set(this.smoothedRate.clipToMaxLength(this.maxRateVariable.getValue()));
        this.scaleAdd(this.dt, (FrameTuple3DReadOnly)this.smoothedRate, (FrameTuple3DReadOnly)this);
        if (this.containsNaN()) {
            throw new RuntimeException("what?");
        }
    }

    public void initialize(FrameTuple3DReadOnly input) {
        this.initialize(input.getX(), input.getY(), input.getZ());
    }

    public void initialize(double xInput, double yInput, double zInput) {
        this.set(xInput, yInput, zInput);
        this.smoothedRate.setToZero();
        this.smoothedAcceleration.setToZero();
        this.hasBeenInitialized.set(true);
    }

    public void reset() {
        this.hasBeenInitialized.set(false);
        this.smoothedRate.setToZero();
        this.smoothedAcceleration.setToZero();
    }
}

