/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoDoubleStatistics {
    private final YoDouble variable;
    private final YoRegistry registry;
    private YoDouble min;
    private YoDouble max;
    private YoDouble average;
    private YoDouble delta;
    private long ticks = 0L;
    private double total = 0.0;

    public YoDoubleStatistics(YoDouble variable, YoRegistry registry) {
        this.variable = variable;
        this.registry = registry;
        variable.addListener(this::update);
    }

    private void update(YoVariable v) {
        double value = this.variable.getDoubleValue();
        if (this.min != null && value < this.min.getDoubleValue()) {
            this.min.set(value);
        }
        if (this.max != null && value > this.max.getDoubleValue()) {
            this.max.set(value);
        }
        if (this.average != null) {
            ++this.ticks;
            this.total += value;
            this.average.set(this.total / (double)this.ticks);
        }
        if (this.delta != null && this.min != null && this.max != null) {
            this.delta.set(this.max.getDoubleValue() - this.min.getDoubleValue());
        }
    }

    public void enableMin() {
        this.min = new YoDouble(this.variable.getName() + "Min", this.registry);
        this.min.set(Double.MAX_VALUE);
    }

    public void enableMax() {
        this.max = new YoDouble(this.variable.getName() + "Max", this.registry);
        this.max.set(Double.MIN_VALUE);
    }

    public void enableAverage() {
        this.average = new YoDouble(this.variable.getName() + "Average", this.registry);
        this.average.set(Double.NaN);
    }

    public void enableDelta() {
        this.delta = new YoDouble(this.variable.getName() + "Delta", this.registry);
        this.delta.set(Double.NaN);
    }
}

