/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoAngleDifferentiator {
    private boolean hasBeenUpdated = false;
    private final YoDouble previous;
    private double output = Double.NaN;
    private double dt;

    public YoAngleDifferentiator(String name, double dt, YoRegistry registry) {
        this.previous = new YoDouble(name, registry);
        this.dt = dt;
    }

    public void update(double input) {
        if (this.hasBeenUpdated) {
            this.output = AngleTools.computeAngleDifferenceMinusPiToPi(input, this.previous.getDoubleValue()) / this.dt;
            this.previous.set(input);
        } else {
            this.reset(input);
        }
        this.hasBeenUpdated = true;
    }

    public double val() {
        return this.output;
    }

    public void reset(double resetVal) {
        this.previous.set(resetVal);
        this.output = 0.0;
    }
}

