/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.QuaternionConversion;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public class QuaternionCalculus {
    private final AxisAngle axisAngleForLog = new AxisAngle();
    private final Quaternion tempQ1ForInterpolation = new Quaternion();
    private final AxisAngle axisAngleForPow = new AxisAngle();
    private final Quaternion qConj = new Quaternion();
    private final Vector4D intermediateQDot = new Vector4D();
    private final Vector4D qDotConj = new Vector4D();
    private final Vector3D intermediateAngularAcceleration = new Vector3D();
    private final Vector3D intermediateAngularVelocity = new Vector3D();
    private final Vector4D intermediateQDDot = new Vector4D();
    private final Quaternion qInv = new Quaternion();
    private final Vector4D pureQuatForMultiply = new Vector4D();

    public void log(QuaternionReadOnly q, Vector4DBasics resultToPack) {
        this.axisAngleForLog.set((Orientation3DReadOnly)q);
        resultToPack.set(this.axisAngleForLog.getX(), this.axisAngleForLog.getY(), this.axisAngleForLog.getZ(), 0.0);
        resultToPack.scale(this.axisAngleForLog.getAngle());
    }

    public void log(QuaternionReadOnly q, Vector3DBasics resultToPack) {
        this.axisAngleForLog.set((Orientation3DReadOnly)q);
        resultToPack.set(this.axisAngleForLog.getX(), this.axisAngleForLog.getY(), this.axisAngleForLog.getZ());
        resultToPack.scale(this.axisAngleForLog.getAngle());
    }

    public void exp(Vector3DReadOnly rotationVector, QuaternionBasics quaternionToPack) {
        QuaternionConversion.convertRotationVectorToQuaternion((Vector3DReadOnly)rotationVector, (QuaternionBasics)quaternionToPack);
    }

    public void interpolate(double alpha, QuaternionReadOnly q0, QuaternionReadOnly q1, QuaternionBasics qInterpolatedToPack) {
        this.interpolate(alpha, q0, q1, qInterpolatedToPack, true);
    }

    public void interpolate(double alpha, QuaternionReadOnly q0, QuaternionReadOnly q1, QuaternionBasics qInterpolatedToPack, boolean preventExtraSpin) {
        this.tempQ1ForInterpolation.set(q1);
        if (preventExtraSpin && q0.dot((Tuple4DReadOnly)this.tempQ1ForInterpolation) < 0.0) {
            this.tempQ1ForInterpolation.negate();
        }
        this.computeQuaternionDifference(q0, (QuaternionReadOnly)this.tempQ1ForInterpolation, qInterpolatedToPack);
        this.pow((QuaternionReadOnly)qInterpolatedToPack, alpha, qInterpolatedToPack);
        qInterpolatedToPack.multiply(q0, (QuaternionReadOnly)qInterpolatedToPack);
    }

    public void pow(QuaternionReadOnly q, double power, QuaternionBasics resultToPack) {
        this.axisAngleForPow.set((Orientation3DReadOnly)q);
        this.axisAngleForPow.setAngle(power * this.axisAngleForPow.getAngle());
        resultToPack.set((Orientation3DReadOnly)this.axisAngleForPow);
    }

    public void computeAngularVelocityInBodyFixedFrame(QuaternionReadOnly q, Vector4DReadOnly qDot, Vector3DBasics angularVelocityToPack) {
        this.qConj.setAndConjugate(q);
        this.multiply((QuaternionReadOnly)this.qConj, qDot, angularVelocityToPack);
        angularVelocityToPack.scale(2.0);
    }

    public void computeAngularVelocityInWorldFrame(QuaternionReadOnly q, Vector4DReadOnly qDot, Vector3DBasics angularVelocityToPack) {
        this.qConj.setAndConjugate(q);
        this.multiply(qDot, (QuaternionReadOnly)this.qConj, angularVelocityToPack);
        angularVelocityToPack.scale(2.0);
    }

    public void computeQDotInWorldFrame(QuaternionReadOnly q, Vector3DReadOnly angularVelocityInWorld, Vector4DBasics qDotToPack) {
        this.multiply(angularVelocityInWorld, q, qDotToPack);
        qDotToPack.scale(0.5);
    }

    public void computeQDotInBodyFixedFrame(QuaternionReadOnly q, Vector3DReadOnly angularVelocityInBody, Vector4DBasics qDotToPack) {
        this.multiply(q, angularVelocityInBody, qDotToPack);
        qDotToPack.scale(0.5);
    }

    public void computeQDDotInWorldFrame(QuaternionReadOnly q, Vector4DReadOnly qDot, Vector3DReadOnly angularAcceleration, Vector4DBasics qDDotToPack) {
        this.computeAngularVelocityInWorldFrame(q, qDot, (Vector3DBasics)this.intermediateAngularVelocity);
        this.computeQDDotInWorldFrame(q, qDot, (Vector3DReadOnly)this.intermediateAngularVelocity, angularAcceleration, qDDotToPack);
    }

    public void computeQDDotInWorldFrame(QuaternionReadOnly q, Vector3DReadOnly angularVelocityInWorld, Vector3DReadOnly angularAccelerationInWorld, Vector4DBasics qDDotToPack) {
        this.computeQDotInWorldFrame(q, angularVelocityInWorld, (Vector4DBasics)this.intermediateQDot);
        this.computeQDDotInWorldFrame(q, (Vector4DReadOnly)this.intermediateQDot, angularVelocityInWorld, angularAccelerationInWorld, qDDotToPack);
    }

    public void computeQDDotInWorldFrame(QuaternionReadOnly q, Vector4DReadOnly qDot, Vector3DReadOnly angularVelocity, Vector3DReadOnly angularAcceleration, Vector4DBasics qDDotToPack) {
        this.multiply(angularAcceleration, q, (Vector4DBasics)this.intermediateQDDot);
        this.multiply(angularVelocity, qDot, qDDotToPack);
        qDDotToPack.add((Tuple4DReadOnly)this.intermediateQDDot);
        qDDotToPack.scale(0.5);
    }

    public void computeAngularAccelerationInWorldFrame(QuaternionReadOnly q, Vector4DReadOnly qDDot, Vector3DReadOnly angularVelocityInWorld, Vector3DBasics angularAccelerationToPack) {
        this.computeQDotInWorldFrame(q, angularVelocityInWorld, (Vector4DBasics)this.intermediateQDot);
        this.computeAngularAcceleration(q, (Vector4DReadOnly)this.intermediateQDot, qDDot, angularAccelerationToPack);
    }

    public void computeAngularAcceleration(QuaternionReadOnly q, Vector4DReadOnly qDot, Vector4DReadOnly qDDot, Vector3DBasics angularAccelerationToPack) {
        this.qConj.setAndConjugate(q);
        this.qDotConj.set(-qDot.getX(), -qDot.getY(), -qDot.getZ(), qDot.getS());
        this.multiply(qDot, (Vector4DReadOnly)this.qDotConj, (Vector3DBasics)this.intermediateAngularAcceleration);
        this.multiply(qDDot, (QuaternionReadOnly)this.qConj, angularAccelerationToPack);
        angularAccelerationToPack.add((Tuple3DReadOnly)this.intermediateAngularAcceleration);
        angularAccelerationToPack.scale(2.0);
    }

    public void computeQDotByFiniteDifferenceCentral(QuaternionReadOnly qPrevious, QuaternionReadOnly qNext, double dt, Vector4DBasics qDotToPack) {
        qDotToPack.set((Tuple4DReadOnly)qNext);
        qDotToPack.sub((Tuple4DReadOnly)qPrevious);
        qDotToPack.scale(0.5 / dt);
    }

    public void computeQDDotByFiniteDifferenceCentral(QuaternionReadOnly qPrevious, QuaternionReadOnly q, QuaternionReadOnly qNext, double dt, Vector4DBasics qDDotToPack) {
        qDDotToPack.set((Tuple4DReadOnly)qNext);
        qDDotToPack.sub((Tuple4DReadOnly)q);
        qDDotToPack.sub((Tuple4DReadOnly)q);
        qDDotToPack.add((Tuple4DReadOnly)qPrevious);
        qDDotToPack.scale(1.0 / MathTools.square((double)dt));
    }

    public void computeQuaternionDifference(QuaternionReadOnly q0, QuaternionReadOnly q1, QuaternionBasics resultToPack) {
        resultToPack.setAndConjugate(q0);
        resultToPack.multiply(q1);
    }

    public void multiply(QuaternionReadOnly q, Vector3DReadOnly v, Vector4DBasics resultToPack) {
        this.setAsPureQuaternion(v, resultToPack);
        QuaternionTools.multiply((Tuple4DReadOnly)q, (Tuple4DReadOnly)resultToPack, (Vector4DBasics)resultToPack);
    }

    public void multiply(Vector3DReadOnly v, Vector4DReadOnly q, Vector4DBasics resultToPack) {
        this.setAsPureQuaternion(v, resultToPack);
        QuaternionTools.multiply((Tuple4DReadOnly)resultToPack, (Tuple4DReadOnly)q, (Vector4DBasics)resultToPack);
    }

    public void multiply(Vector3DReadOnly v, QuaternionReadOnly q, Vector4DBasics resultToPack) {
        this.setAsPureQuaternion(v, resultToPack);
        QuaternionTools.multiply((Tuple4DReadOnly)resultToPack, (Tuple4DReadOnly)q, (Vector4DBasics)resultToPack);
    }

    public void multiply(Vector4DReadOnly q1, Vector4DReadOnly q2, Vector3DBasics resultToPack) {
        QuaternionTools.multiply((Tuple4DReadOnly)q1, (Tuple4DReadOnly)q2, (Vector4DBasics)this.pureQuatForMultiply);
        this.setVectorFromPureQuaternion((Vector4DReadOnly)this.pureQuatForMultiply, resultToPack);
    }

    public void multiply(Vector4DReadOnly q1, QuaternionReadOnly q2, Vector3DBasics resultToPack) {
        QuaternionTools.multiply((Tuple4DReadOnly)q1, (Tuple4DReadOnly)q2, (Vector4DBasics)this.pureQuatForMultiply);
        this.setVectorFromPureQuaternion((Vector4DReadOnly)this.pureQuatForMultiply, resultToPack);
    }

    public void multiply(QuaternionReadOnly q1, Vector4DReadOnly q2, Vector3DBasics resultToPack) {
        QuaternionTools.multiply((Tuple4DReadOnly)q1, (Tuple4DReadOnly)q2, (Vector4DBasics)this.pureQuatForMultiply);
        this.setVectorFromPureQuaternion((Vector4DReadOnly)this.pureQuatForMultiply, resultToPack);
    }

    public void inverseMultiply(QuaternionReadOnly q1, QuaternionReadOnly q2, QuaternionBasics resultToPack) {
        this.qInv.setAndConjugate(q1);
        resultToPack.multiply((QuaternionReadOnly)this.qInv, q2);
    }

    public void setAsPureQuaternion(Vector3DReadOnly vector, Vector4DBasics pureQuaternionToSet) {
        pureQuaternionToSet.set(vector.getX(), vector.getY(), vector.getZ(), 0.0);
    }

    public void setVectorFromPureQuaternion(Vector4DReadOnly pureQuaternion, Vector3DBasics vectorToPack) {
        vectorToPack.set(pureQuaternion.getX(), pureQuaternion.getY(), pureQuaternion.getZ());
    }
}

