/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class ColumnSpaceProjector {
    private final LinearSolverDense<DMatrixRMaj> solver;
    private final DMatrixRMaj APlus;
    private final DMatrixRMaj A;
    private final DMatrixRMaj tempVector;

    public ColumnSpaceProjector(LinearSolverDense<DMatrixRMaj> solver, int numRows, int numCols) {
        this.solver = solver;
        this.A = new DMatrixRMaj(numRows, numCols);
        this.APlus = new DMatrixRMaj(numCols, numRows);
        this.tempVector = new DMatrixRMaj(numCols, 1);
    }

    public void setA(DMatrixRMaj A) {
        this.A.set((DMatrixD1)A);
        this.solver.setA((Matrix)A);
        this.solver.invert((Matrix)this.APlus);
    }

    public void project(DMatrixRMaj b, DMatrixRMaj bPlus) {
        CommonOps_DDRM.mult((DMatrix1Row)this.APlus, (DMatrix1Row)b, (DMatrix1Row)this.tempVector);
        CommonOps_DDRM.mult((DMatrix1Row)this.A, (DMatrix1Row)this.tempVector, (DMatrix1Row)bPlus);
    }
}

