/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.interaction;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Line3DMouseDragAlgorithm {
    private final Line3D dragLine = new Line3D();
    private final Plane3D perpendicularPlane = new Plane3D();
    private final Point3D closestPointToPickRay = new Point3D();
    private final Vector3D axisMoveVector = new Vector3D();

    public Vector3DReadOnly calculate(Line3DReadOnly pickRay, Point3D pointOnLine, RotationMatrix lineOrientationInObjectFrame, RigidBodyTransformReadOnly objectTransform) {
        this.dragLine.getPoint().set((Tuple3DReadOnly)pointOnLine);
        this.dragLine.getDirection().set((UnitVector3DReadOnly)Axis3D.Z);
        lineOrientationInObjectFrame.transform((Tuple3DBasics)this.dragLine.getDirection());
        objectTransform.getRotation().transform((Tuple3DBasics)this.dragLine.getDirection());
        this.perpendicularPlane.set((Point3DReadOnly)this.dragLine.getPoint(), (Vector3DReadOnly)this.dragLine.getDirection());
        pickRay.closestPointsWith((Line3DReadOnly)this.dragLine, null, (Point3DBasics)this.closestPointToPickRay);
        double distanceToMove = this.perpendicularPlane.signedDistance((Point3DReadOnly)this.closestPointToPickRay);
        this.axisMoveVector.set((Tuple3DReadOnly)this.dragLine.getDirection());
        this.axisMoveVector.scale(distanceToMove);
        return this.axisMoveVector;
    }
}

