/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.concavePolygon2D;

import java.util.List;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2DReadOnly;

public class GeometryPolygonTools {
    public static boolean isPolygonInsideOtherPolygon(Vertex2DSupplier innerPolygon, ConcavePolygon2DReadOnly outerPolygon) {
        for (int i = 0; i < innerPolygon.getNumberOfVertices(); ++i) {
            if (outerPolygon.isPointInsideEpsilon(innerPolygon.getVertex(i), 1.0E-5)) continue;
            return false;
        }
        Point2D intersection = new Point2D();
        for (int i = 0; i < innerPolygon.getNumberOfVertices(); ++i) {
            Point2DReadOnly vertex = innerPolygon.getVertex(i);
            Point2DReadOnly nextVertex = innerPolygon.getVertex((i + 1) % innerPolygon.getNumberOfVertices());
            for (int j = 0; j < outerPolygon.getNumberOfVertices(); ++j) {
                Point2DReadOnly otherNextVertex;
                Point2DReadOnly otherVertex = outerPolygon.getVertex(j);
                if (!EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)vertex, (Point2DReadOnly)nextVertex, (Point2DReadOnly)otherVertex, (Point2DReadOnly)(otherNextVertex = outerPolygon.getNextVertex(j)), (Point2DBasics)intersection)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean doPolygonsIntersect(ConcavePolygon2DReadOnly polygonA, ConcavePolygon2DReadOnly polygonB) {
        return GeometryPolygonTools.doPolygonsIntersect(polygonA.getBoundingBox(), polygonB.getBoundingBox(), polygonA, polygonB);
    }

    public static boolean doPolygonsIntersect(BoundingBox2DReadOnly boundingBoxA, BoundingBox2DReadOnly boundingBoxB, Vertex2DSupplier polygonA, Vertex2DSupplier polygonB) {
        if (!boundingBoxA.intersectsInclusive(boundingBoxB)) {
            return false;
        }
        return GeometryPolygonTools.doPolygonsIntersect(polygonA, polygonB);
    }

    public static boolean doPolygonsIntersect(Vertex2DSupplier polygonA, Vertex2DSupplier polygonB) {
        return GeometryPolygonTools.doPolygonsIntersectBruteForce(polygonA, polygonB);
    }

    public static boolean doPolygonsIntersectBruteForce(Vertex2DSupplier polygonA, Vertex2DSupplier polygonB) {
        for (int i = 0; i < polygonA.getNumberOfVertices(); ++i) {
            Point2DReadOnly endVertex;
            Point2DReadOnly startVertex = polygonA.getVertex(i);
            if (!GeometryPolygonTools.doesLineSegment2DIntersectPolygon(startVertex, endVertex = polygonA.getVertex(EuclidGeometryPolygonTools.next((int)i, (int)polygonA.getNumberOfVertices())), polygonB)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesLineSegment2DIntersectPolygon(Point2DReadOnly segmentStart, Point2DReadOnly segmentEnd, Vertex2DSupplier polygon) {
        Point2D intersection = new Point2D();
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            Point2DReadOnly endVertex;
            Point2DReadOnly startVertex = polygon.getVertex(i);
            if (EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)segmentStart, (Point2DReadOnly)segmentEnd, (Point2DReadOnly)startVertex, (Point2DReadOnly)(endVertex = polygon.getVertex(EuclidGeometryPolygonTools.next((int)i, (int)polygon.getNumberOfVertices()))), (double)1.0E-5, (double)1.0E-4) || !EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)segmentStart, (Point2DReadOnly)segmentEnd, (Point2DReadOnly)startVertex, (Point2DReadOnly)endVertex, (Point2DBasics)intersection)) continue;
            return true;
        }
        return false;
    }

    public static boolean isClockwiseOrdered3DZUp(List<? extends Point3DReadOnly> concaveHullVertices, int numberOfVertices) {
        GeometryPolygonTools.checkNumberOfVertices3D(concaveHullVertices, numberOfVertices);
        double sumOfAngles = 0.0;
        for (int vertexIndex = 0; vertexIndex < numberOfVertices; ++vertexIndex) {
            int previousVertexIndex = EuclidGeometryPolygonTools.previous((int)vertexIndex, (int)numberOfVertices);
            int nextVertexIndex = EuclidGeometryPolygonTools.next((int)vertexIndex, (int)numberOfVertices);
            Point3DReadOnly previousVertex = concaveHullVertices.get(previousVertexIndex);
            Point3DReadOnly vertex = concaveHullVertices.get(vertexIndex);
            Point3DReadOnly nextVertex = concaveHullVertices.get(nextVertexIndex);
            double firstVectorX = vertex.getX() - previousVertex.getX();
            double firstVectorY = vertex.getY() - previousVertex.getY();
            double secondVectorX = nextVertex.getX() - vertex.getX();
            double secondVectorY = nextVertex.getY() - vertex.getY();
            sumOfAngles += GeometryPolygonTools.angle(firstVectorX, firstVectorY, secondVectorX, secondVectorY);
        }
        return sumOfAngles <= 0.0;
    }

    public static boolean isClockwiseOrdered(List<? extends Point2DReadOnly> concaveHullVertices, int numberOfVertices) {
        GeometryPolygonTools.checkNumberOfVertices(concaveHullVertices, numberOfVertices);
        double sumOfAngles = 0.0;
        for (int vertexIndex = 0; vertexIndex < numberOfVertices; ++vertexIndex) {
            int previousVertexIndex = EuclidGeometryPolygonTools.previous((int)vertexIndex, (int)numberOfVertices);
            int nextVertexIndex = EuclidGeometryPolygonTools.next((int)vertexIndex, (int)numberOfVertices);
            Point2DReadOnly previousVertex = concaveHullVertices.get(previousVertexIndex);
            Point2DReadOnly vertex = concaveHullVertices.get(vertexIndex);
            Point2DReadOnly nextVertex = concaveHullVertices.get(nextVertexIndex);
            double firstVectorX = vertex.getX() - previousVertex.getX();
            double firstVectorY = vertex.getY() - previousVertex.getY();
            double secondVectorX = nextVertex.getX() - vertex.getX();
            double secondVectorY = nextVertex.getY() - vertex.getY();
            sumOfAngles += GeometryPolygonTools.angle(firstVectorX, firstVectorY, secondVectorX, secondVectorY);
        }
        return sumOfAngles <= 0.0;
    }

    public static boolean isPoint2DInsideSimplePolygon2D(Point2DReadOnly queryPoint, List<? extends Point2DReadOnly> polygon, int numberOfVertices) {
        return GeometryPolygonTools.isPoint2DInsideSimplePolygon2D(queryPoint.getX(), queryPoint.getY(), polygon, numberOfVertices);
    }

    public static boolean isPoint2DInsideSimplePolygon2D(double pointX, double pointY, List<? extends Point2DReadOnly> polygon, int numberOfVertices) {
        return GeometryPolygonTools.isPoint2DInsideSimplePolygon2D(pointX, pointY, polygon, numberOfVertices, null, 1.0E-7);
    }

    public static boolean isPoint2DInsideSimplePolygon2D(Point2DReadOnly queryPoint, List<? extends Point2DReadOnly> polygon, int numberOfVertices, double epsilon) {
        return GeometryPolygonTools.isPoint2DInsideSimplePolygon2D(queryPoint.getX(), queryPoint.getY(), polygon, numberOfVertices, epsilon);
    }

    public static boolean isPoint2DInsideSimplePolygon2D(double pointX, double pointY, List<? extends Point2DReadOnly> polygon, int numberOfVertices, double epsilon) {
        return GeometryPolygonTools.isPoint2DInsideSimplePolygon2D(pointX, pointY, polygon, numberOfVertices, null, epsilon);
    }

    public static boolean isPoint2DInsideSimplePolygon2D(double pointX, double pointY, List<? extends Point2DReadOnly> polygon, int numberOfVertices, Point2DBasics intersectionToPack, double epsilon) {
        if (GeometryPolygonTools.isPoint2DOnPerimeterOfSimplePolygon2D(pointX, pointY, polygon, numberOfVertices, epsilon)) {
            return true;
        }
        return GeometryPolygonTools.isPoint2DStrictlyInsideSimplePolygon2D(pointX, pointY, polygon, numberOfVertices, intersectionToPack, false, epsilon);
    }

    public static boolean isPoint2DOnPerimeterOfSimplePolygon2D(Point2DReadOnly point, List<? extends Point2DReadOnly> polygon, int numberOfVertices, double epsilon) {
        return GeometryPolygonTools.isPoint2DOnPerimeterOfSimplePolygon2D(point.getX(), point.getY(), polygon, numberOfVertices, epsilon);
    }

    public static boolean isPoint2DOnPerimeterOfSimplePolygon2D(double pointX, double pointY, List<? extends Point2DReadOnly> polygon, int numberOfVertices, double epsilon) {
        GeometryPolygonTools.checkNumberOfVertices(polygon, numberOfVertices);
        double epsilonSquared = MathTools.square((double)epsilon);
        for (int i = 0; i < numberOfVertices; ++i) {
            Point2DReadOnly nextVertex;
            Point2DReadOnly vertex = polygon.get(i);
            if (!(EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((double)pointX, (double)pointY, (Point2DReadOnly)vertex, (Point2DReadOnly)(nextVertex = polygon.get((i + 1) % numberOfVertices))) < epsilonSquared)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPoint2DStrictlyInsideSimplePolygon2D(Point2DReadOnly point, List<? extends Point2DReadOnly> polygon, int numberOfVertices, Point2DBasics intersectionToPack, double epsilon) {
        return GeometryPolygonTools.isPoint2DStrictlyInsideSimplePolygon2D(point, polygon, numberOfVertices, intersectionToPack, true, epsilon);
    }

    public static boolean isPoint2DStrictlyInsideSimplePolygon2D(double pointX, double pointY, List<? extends Point2DReadOnly> polygon, int numberOfVertices, Point2DBasics intersectionToPack, double epsilon) {
        return GeometryPolygonTools.isPoint2DStrictlyInsideSimplePolygon2D(pointX, pointY, polygon, numberOfVertices, intersectionToPack, true, epsilon);
    }

    public static boolean isPoint2DStrictlyInsideSimplePolygon2D(Point2DReadOnly point, List<? extends Point2DReadOnly> polygon, int numberOfVertices, Point2DBasics intersectionToPack, boolean checkPerimeter, double epsilon) {
        return GeometryPolygonTools.isPoint2DStrictlyInsideSimplePolygon2D(point.getX(), point.getY(), polygon, numberOfVertices, intersectionToPack, checkPerimeter, epsilon);
    }

    public static boolean isPoint2DStrictlyInsideSimplePolygon2D(double pointX, double pointY, List<? extends Point2DReadOnly> polygon, int numberOfVertices, Point2DBasics intersectionToPack, boolean checkPerimeter, double epsilon) {
        if (checkPerimeter && GeometryPolygonTools.isPoint2DOnPerimeterOfSimplePolygon2D(pointX, pointY, polygon, numberOfVertices, epsilon)) {
            return false;
        }
        GeometryPolygonTools.checkNumberOfVertices(polygon, numberOfVertices);
        if (numberOfVertices < 3) {
            return false;
        }
        double lineDirectionX = 1.0;
        double lineDirectionY = 0.0;
        int intersectionsPositive = GeometryPolygonTools.getNumberOfIntersections(pointX, pointY, lineDirectionX, lineDirectionY, polygon, numberOfVertices, intersectionToPack, epsilon);
        int intersectionsNegative = GeometryPolygonTools.getNumberOfIntersections(pointX, pointY, -lineDirectionX, -lineDirectionY, polygon, numberOfVertices, intersectionToPack, epsilon);
        if (intersectionsNegative == 0 || intersectionsPositive == 0) {
            return false;
        }
        if (intersectionsPositive % 2 == 0 && intersectionsNegative % 2 == 0) {
            return false;
        }
        boolean evenNumberOfIntersections = (intersectionsPositive + intersectionsNegative) % 2 == 0;
        return evenNumberOfIntersections;
    }

    private static int getNumberOfIntersections(double pointX, double pointY, double lineDirectionX, double lineDirectionY, List<? extends Point2DReadOnly> polygon, int numberOfVertices, Point2DBasics intersectionToPack, double epsilon) {
        int intersections = 0;
        for (int i = 0; i < numberOfVertices; ++i) {
            boolean isSegmentATurnAround;
            int prevIdx = EuclidGeometryPolygonTools.previous((int)i, (int)numberOfVertices);
            int nextIdx = EuclidGeometryPolygonTools.next((int)i, (int)numberOfVertices);
            int nextNextIdx = EuclidGeometryPolygonTools.next((int)nextIdx, (int)numberOfVertices);
            Point2DReadOnly previousVertex = polygon.get(prevIdx);
            Point2DReadOnly vertex = polygon.get(i);
            Point2DReadOnly nextVertex = polygon.get(nextIdx);
            Point2DReadOnly nextNextVertex = polygon.get(nextNextIdx);
            boolean linesAreCollinear = EuclidGeometryTools.areLine2DsCollinear((double)pointX, (double)pointY, (double)lineDirectionX, (double)lineDirectionY, (double)vertex.getX(), (double)vertex.getY(), (double)(nextVertex.getX() - vertex.getX()), (double)(nextVertex.getY() - vertex.getY()), (double)1.0E-7, (double)epsilon);
            boolean bl = isSegmentATurnAround = EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)previousVertex, (Point2DReadOnly)vertex, (Point2DReadOnly)nextVertex) == EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)nextNextVertex, (Point2DReadOnly)vertex, (Point2DReadOnly)nextVertex);
            if (linesAreCollinear && !isSegmentATurnAround) continue;
            if (EuclidGeometryTools.distanceFromPoint2DToRay2D((double)vertex.getX(), (double)vertex.getY(), (double)pointX, (double)pointY, (double)lineDirectionX, (double)lineDirectionY) < epsilon) {
                if (!linesAreCollinear) continue;
                ++intersections;
                continue;
            }
            boolean intersects = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D((double)pointX, (double)pointY, (double)lineDirectionX, (double)lineDirectionY, (double)vertex.getX(), (double)vertex.getY(), (double)nextVertex.getX(), (double)nextVertex.getY(), (Point2DBasics)intersectionToPack);
            if (!intersects) continue;
            ++intersections;
        }
        return intersections;
    }

    public static boolean isSimplePolygon(List<? extends Point2DReadOnly> concaveHullVertices, int numberOfVertices) {
        return GeometryPolygonTools.isSimplePolygonBruteForce(concaveHullVertices, numberOfVertices);
    }

    public static boolean isSimplePolygonBruteForce(List<? extends Point2DReadOnly> concaveHullVertices, int numberOfVertices) {
        for (int index = 0; index < numberOfVertices; ++index) {
            int previousIndex = EuclidGeometryPolygonTools.previous((int)index, (int)numberOfVertices);
            Point2DReadOnly segmentStart = concaveHullVertices.get(previousIndex);
            Point2DReadOnly segmentEnd = concaveHullVertices.get(index);
            int nextSegmentStart = EuclidGeometryPolygonTools.next((int)index, (int)numberOfVertices);
            int nextSegmentEnd = EuclidGeometryPolygonTools.next((int)nextSegmentStart, (int)numberOfVertices);
            while (nextSegmentEnd != previousIndex) {
                if (EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)segmentStart, (Point2DReadOnly)segmentEnd, (Point2DReadOnly)concaveHullVertices.get(nextSegmentStart), (Point2DReadOnly)concaveHullVertices.get(nextSegmentEnd))) {
                    return false;
                }
                nextSegmentStart = nextSegmentEnd;
                nextSegmentEnd = EuclidGeometryPolygonTools.next((int)nextSegmentStart, (int)numberOfVertices);
            }
        }
        return true;
    }

    private static double angle(Vector2DReadOnly firstVector, Vector2DReadOnly secondVector) {
        return GeometryPolygonTools.angle(firstVector.getX(), firstVector.getY(), secondVector.getX(), secondVector.getY());
    }

    private static double angle(double firstVectorX, double firstVectorY, double secondVectorX, double secondVectorY) {
        double crossProduct = firstVectorX * secondVectorY - firstVectorY * secondVectorX;
        double dotProduct = firstVectorX * secondVectorX + firstVectorY * secondVectorY;
        return EuclidCoreTools.atan2((double)crossProduct, (double)dotProduct);
    }

    private static void checkNumberOfVertices(List<? extends Point2DReadOnly> convexPolygon2D, int numberOfVertices) {
        if (numberOfVertices < 0 || numberOfVertices > convexPolygon2D.size()) {
            throw new IllegalArgumentException("Illegal numberOfVertices: " + numberOfVertices + ", expected a value in ] 0, " + convexPolygon2D.size() + "].");
        }
    }

    private static void checkNumberOfVertices3D(List<? extends Point3DReadOnly> convexPolygon, int numberOfVertices) {
        if (numberOfVertices < 0 || numberOfVertices > convexPolygon.size()) {
            throw new IllegalArgumentException("Illegal numberOfVertices: " + numberOfVertices + ", expected a value in ] 0, " + convexPolygon.size() + "].");
        }
    }
}

