/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.concavePolygon2D;

import us.ihmc.euclid.geometry.interfaces.BoundingBox2DBasics;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2DReadOnly;

public interface ConcavePolygon2DBasics
extends ConcavePolygon2DReadOnly,
Transformable {
    public void update();

    public void updateCentroidAndArea();

    public void clear();

    public void clearAndUpdate();

    default public void setToZero() {
        this.clear();
        this.addVertex(0.0, 0.0);
        this.update();
    }

    default public void setToNaN() {
        this.clear();
        this.addVertex(Double.NaN, Double.NaN);
        this.update();
    }

    default public void updateBoundingBox() {
        BoundingBox2DBasics boundingBox = this.getBoundingBox();
        boundingBox.setToNaN();
        boundingBox.updateToIncludePoints((Vertex2DSupplier)this);
    }

    public void addVertex(double var1, double var3);

    public void removeVertex(int var1);

    default public void insertVertex(int indexToSetVertex, Point2DReadOnly vertexToSet) {
        this.insertVertex(indexToSetVertex, vertexToSet.getX(), vertexToSet.getY());
    }

    public void insertVertex(int var1, double var2, double var4);

    public BoundingBox2DBasics getBoundingBox();

    public void notifyVerticesChanged();

    public Point2DBasics getVertexUnsafe(int var1);

    default public void set(Vertex2DSupplier vertex2DSupplier) {
        this.clear();
        this.addVertices(vertex2DSupplier);
        this.update();
    }

    default public void addVertices(Vertex2DSupplier vertex2DSupplier) {
        for (int index = 0; index < vertex2DSupplier.getNumberOfVertices(); ++index) {
            this.addVertex(vertex2DSupplier.getVertex(index));
        }
    }

    default public void addVertex(Point2DReadOnly vertex) {
        this.addVertex(vertex.getX(), vertex.getY());
    }

    default public void addVertex(Point3DReadOnly vertex) {
        this.addVertex(vertex.getX(), vertex.getY());
    }

    default public void applyTransform(Transform transform) {
        this.applyTransform(transform, true);
    }

    default public void applyTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        this.checkIfUpToDate();
        this.notifyVerticesChanged();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            this.getVertexUnsafe(i).applyTransform(transform, checkIfTransformInXYPlane);
        }
        this.update();
    }

    default public void applyInverseTransform(Transform transform) {
        this.applyInverseTransform(transform, true);
    }

    default public void applyInverseTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        this.checkIfUpToDate();
        this.notifyVerticesChanged();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            this.getVertexUnsafe(i).applyInverseTransform(transform, checkIfTransformInXYPlane);
        }
        this.update();
    }
}

