/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.concavePolygon2D;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DBasics;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.robotics.geometry.concavePolygon2D.ComplexPolygonException;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2DBasics;
import us.ihmc.robotics.geometry.concavePolygon2D.GeometryPolygonTools;

public class ConcavePolygon2D
implements ConcavePolygon2DBasics {
    private final boolean clockwiseOrdered = true;
    private int numberOfVertices = 0;
    private double area;
    private boolean isUpToDate = false;
    private final List<Point2D> vertexBuffer = new ArrayList<Point2D>();
    private final List<Point2D> vertexBufferView = Collections.unmodifiableList(this.vertexBuffer);
    private final BoundingBox2D boundingBox = new BoundingBox2D();
    private final Point2D centroid = new Point2D();

    public ConcavePolygon2D() {
    }

    public ConcavePolygon2D(Vertex2DSupplier vertex2DSupplier) {
        this.set(vertex2DSupplier);
    }

    @Override
    public void clear() {
        this.numberOfVertices = 0;
        this.area = Double.NaN;
        this.centroid.setToNaN();
        this.boundingBox.setToNaN();
        this.isUpToDate = false;
    }

    @Override
    public void clearAndUpdate() {
        this.clear();
        this.isUpToDate = true;
    }

    @Override
    public boolean isClockwiseOrdered() {
        return true;
    }

    @Override
    public void removeVertex(int indexOfVertexToRemove) {
        this.checkNonEmpty();
        this.checkIndexInBoundaries(indexOfVertexToRemove);
        if (indexOfVertexToRemove == this.numberOfVertices - 1) {
            --this.numberOfVertices;
            return;
        }
        this.isUpToDate = false;
        for (int index = indexOfVertexToRemove; index < this.numberOfVertices - 1; ++index) {
            Point2DReadOnly nextVertex = this.getVertex(index + 1);
            this.setOrCreate(nextVertex.getX(), nextVertex.getY(), index);
        }
        --this.numberOfVertices;
    }

    @Override
    public void insertVertex(int indexToSetVertex, double vertexXToSet, double vertexYToSet) {
        this.checkNonEmpty();
        this.checkIndexInBoundaries(indexToSetVertex);
        ++this.numberOfVertices;
        for (int vertex = this.numberOfVertices - 2; vertex >= indexToSetVertex; --vertex) {
            Point2DReadOnly vertexToShift = this.getVertex(vertex);
            this.setOrCreate(vertexToShift.getX(), vertexToShift.getY(), vertex + 1);
        }
        this.setOrCreate(vertexXToSet, vertexYToSet, indexToSetVertex);
        this.isUpToDate = false;
    }

    @Override
    public void update() {
        if (this.isUpToDate) {
            return;
        }
        this.ensureClockwiseOrdering();
        if (!GeometryPolygonTools.isSimplePolygon(this.vertexBuffer, this.numberOfVertices)) {
            throw new ComplexPolygonException("Polygon is not simple, as in it has self intersections.");
        }
        this.removePointsThatAreNotVertices();
        this.isUpToDate = true;
        this.updateCentroidAndArea();
        this.updateBoundingBox();
    }

    private void ensureClockwiseOrdering() {
        if (!GeometryPolygonTools.isClockwiseOrdered(this.vertexBuffer, this.numberOfVertices)) {
            Collections.reverse(this.vertexBuffer);
        }
    }

    @Override
    public void addVertex(double x, double y) {
        this.isUpToDate = false;
        this.setOrCreate(x, y, this.numberOfVertices);
        ++this.numberOfVertices;
    }

    @Override
    public int getNumberOfVertices() {
        return this.numberOfVertices;
    }

    @Override
    public List<? extends Point2DReadOnly> getVertexBufferView() {
        return this.vertexBufferView;
    }

    @Override
    public BoundingBox2DBasics getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    @Override
    public double getArea() {
        this.checkIfUpToDate();
        return this.area;
    }

    @Override
    public Point2DReadOnly getCentroid() {
        this.checkIfUpToDate();
        return this.centroid;
    }

    @Override
    public void notifyVerticesChanged() {
        this.isUpToDate = false;
    }

    @Override
    public Point2DBasics getVertexUnsafe(int index) {
        this.checkNonEmpty();
        this.checkIndexInBoundaries(index);
        return (Point2DBasics)this.vertexBuffer.get(index);
    }

    @Override
    public void updateCentroidAndArea() {
        this.area = EuclidGeometryPolygonTools.computeConvexPolygon2DArea(this.vertexBuffer, (int)this.numberOfVertices, (boolean)true, (Point2DBasics)this.centroid);
    }

    private void setOrCreate(double x, double y, int i) {
        while (i >= this.vertexBuffer.size()) {
            this.vertexBuffer.add(new Point2D());
        }
        this.vertexBuffer.get(i).set(x, y);
    }

    private void removePointsThatAreNotVertices() {
        int i = 0;
        while (i < this.getNumberOfVertices()) {
            Point2DReadOnly nextVertex;
            Point2DReadOnly vertex;
            Point2DReadOnly previousVertex = this.getVertex(EuclidGeometryPolygonTools.previous((int)i, (int)this.getNumberOfVertices()));
            if (EuclidGeometryTools.areLine2DsCollinear((Point2DReadOnly)previousVertex, (Point2DReadOnly)(vertex = this.getVertex(i)), (Point2DReadOnly)vertex, (Point2DReadOnly)(nextVertex = this.getVertex(EuclidGeometryPolygonTools.next((int)i, (int)this.getNumberOfVertices()))), (double)0.001, (double)1.0E-4)) {
                this.removeVertex(i);
                continue;
            }
            ++i;
        }
    }
}

