/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class RigidBodyTransformGenerator {
    private final RigidBodyTransform transform = new RigidBodyTransform();
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();

    public RigidBodyTransformGenerator() {
    }

    public RigidBodyTransformGenerator(RigidBodyTransform transform) {
        this.setTransform(transform);
    }

    public RigidBodyTransformGenerator(RigidBodyTransformGenerator generator) {
        this.setTransform(generator.transform);
    }

    public void set(RigidBodyTransformGenerator transformGenerator) {
        this.transform.set(transformGenerator.transform);
    }

    public void setTransform(RigidBodyTransform transform) {
        this.transform.set(transform);
    }

    public RigidBodyTransform getRigidBodyTransformCopy() {
        return new RigidBodyTransform((RigidBodyTransformReadOnly)this.transform);
    }

    public void getRigidyBodyTransform(RigidBodyTransform transformToPack) {
        transformToPack.set(this.transform);
    }

    public void identity() {
        this.transform.setIdentity();
    }

    public void translate(double x, double y, double z) {
        this.tempTransform.setTranslationAndIdentityRotation(x, y, z);
        this.transform.set(this.transform);
        this.transform.multiply((RigidBodyTransformReadOnly)this.tempTransform);
    }

    public void translate(Tuple3DReadOnly translationVector) {
        this.tempTransform.setTranslationAndIdentityRotation(translationVector);
        this.transform.set(this.transform);
        this.transform.multiply((RigidBodyTransformReadOnly)this.tempTransform);
    }

    public void rotate(double rotationAngle, Axis3D axis) {
        switch (axis) {
            case X: {
                this.tempTransform.setRotationEulerAndZeroTranslation(rotationAngle, 0.0, 0.0);
                break;
            }
            case Y: {
                this.tempTransform.setRotationEulerAndZeroTranslation(0.0, rotationAngle, 0.0);
                break;
            }
            case Z: {
                this.tempTransform.setRotationEulerAndZeroTranslation(0.0, 0.0, rotationAngle);
            }
        }
        this.transform.set(this.transform);
        this.transform.multiply((RigidBodyTransformReadOnly)this.tempTransform);
    }

    public void rotateEuler(double rotateX, double rotateY, double rotateZ) {
        this.tempTransform.setRotationEulerAndZeroTranslation(rotateX, rotateY, rotateZ);
        this.transform.set(this.transform);
        this.transform.multiply((RigidBodyTransformReadOnly)this.tempTransform);
    }

    public void rotateEuler(Vector3DReadOnly eulerAngles) {
        this.tempTransform.setRotationEulerAndZeroTranslation(eulerAngles);
        this.transform.set(this.transform);
        this.transform.multiply((RigidBodyTransformReadOnly)this.tempTransform);
    }

    public void rotate(RotationMatrixReadOnly rotationMatrix) {
        this.tempTransform.setRotationAndZeroTranslation(rotationMatrix);
        this.transform.set(this.transform);
        this.transform.multiply((RigidBodyTransformReadOnly)this.tempTransform);
    }

    public void rotate(QuaternionReadOnly rotationQuaternion) {
        this.tempTransform.setRotationAndZeroTranslation((Orientation3DReadOnly)rotationQuaternion);
        this.transform.set(this.transform);
        this.transform.multiply((RigidBodyTransformReadOnly)this.tempTransform);
    }

    public void translateThenRotate(RigidBodyTransform translateThenRotateTransform) {
        this.tempTransform.set(translateThenRotateTransform);
        this.transform.set(this.transform);
        this.transform.multiply((RigidBodyTransformReadOnly)this.tempTransform);
    }

    public void translateThenRotateEuler(Vector3D translationVector, Vector3D eulerAngles) {
        this.tempTransform.setRotationEulerAndZeroTranslation((Vector3DReadOnly)eulerAngles);
        this.tempTransform.getTranslation().set((Tuple3DReadOnly)translationVector);
        this.transform.set(this.transform);
        this.transform.multiply((RigidBodyTransformReadOnly)this.tempTransform);
    }
}

