/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public class PointToLineUnProjector {
    Point2D pointA = new Point2D();
    Vector2D difference = new Vector2D();
    double zA;
    double zDifference;
    boolean useX = true;
    double qA;
    double qMult;

    public void setLine(Point2D point0, Point2D point1, double point0z, double point1z) {
        this.pointA.set(point0);
        this.difference.sub((Tuple2DReadOnly)point1, (Tuple2DReadOnly)point0);
        this.zA = point0z;
        this.zDifference = point1z - point0z;
        boolean bl = this.useX = Math.abs(this.difference.getX()) > Math.abs(this.difference.getY());
        if (this.useX) {
            this.qA = this.pointA.getX();
            this.qMult = 1.0 / this.difference.getX();
        } else {
            this.qA = this.pointA.getY();
            this.qMult = 1.0 / this.difference.getY();
        }
        if (!Double.isFinite(this.qMult)) {
            this.qMult = 0.0;
        }
    }

    public double unProject(double x, double y) {
        double s = ((this.useX ? x : y) - this.qA) * this.qMult;
        return this.zA + this.zDifference * s;
    }
}

