/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.collision.interfaces.SupportingVertexHolder;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.RegionInWorldInterface;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.geometry.GeometryTools;
import us.ihmc.robotics.geometry.PlanarRegionNormal;
import us.ihmc.robotics.geometry.PlanarRegionOrigin;
import us.ihmc.robotics.geometry.PlanarRegionTools;
import us.ihmc.robotics.random.RandomGeometry;

public class PlanarRegion
implements SupportingVertexHolder,
RegionInWorldInterface<PlanarRegion> {
    public static final int NO_REGION_ID = -1;
    public static final double DEFAULT_BOUNDING_BOX_EPSILON = 0.0;
    private int regionId = -1;
    private int numberOfTimesMatched = 0;
    private int tickOfLastMeasurement = 0;
    private double area = 0.0;
    private final RigidBodyTransform fromLocalToWorldTransform = new RigidBodyTransform();
    private final RigidBodyTransform fromWorldToLocalTransform = new RigidBodyTransform();
    private final RecyclingArrayList<Point2D> concaveHullsVertices = new RecyclingArrayList(Point2D::new);
    private final RecyclingArrayList<ConvexPolygon2D> convexPolygons = new RecyclingArrayList(ConvexPolygon2D::new);
    private final List<Boolean> visited = new ArrayList<Boolean>();
    private final BoundingBox3D boundingBox3dInWorld = new BoundingBox3D((Point3DReadOnly)new Point3D(Double.NaN, Double.NaN, Double.NaN), (Point3DReadOnly)new Point3D(Double.NaN, Double.NaN, Double.NaN));
    private double boundingBoxEpsilon = 0.0;
    private final Point3D tempPointForConvexPolygonProjection = new Point3D();
    private final ConvexPolygon2D convexHull = new ConvexPolygon2D();
    private final ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
    private final PlanarRegionOrigin origin = new PlanarRegionOrigin(this.fromLocalToWorldTransform);
    private final PlanarRegionNormal normal = new PlanarRegionNormal(this.fromLocalToWorldTransform);
    private final ConvexPolygon2D tempPolygon = new ConvexPolygon2D();
    private final Point2D tempPoint2D = new Point2D();
    private final Point3D tempPoint3D = new Point3D();
    private final ConvexPolygon2D projectedPolygonTemp = new ConvexPolygon2D();
    private final ConvexPolygon2D polygonIntersectionTemp = new ConvexPolygon2D();
    private final Point3D localPoint = new Point3D();
    private final Point2D localPoint2D = new Point2D();

    public PlanarRegion() {
        this((RigidBodyTransformReadOnly)new RigidBodyTransform(), new ArrayList<ConvexPolygon2D>());
    }

    public PlanarRegion(RigidBodyTransformReadOnly transformToWorld, List<ConvexPolygon2D> planarRegionConvexPolygons) {
        this(transformToWorld, new ArrayList(), planarRegionConvexPolygons);
        this.updateConcaveHull();
    }

    public PlanarRegion(RigidBodyTransformReadOnly transformToWorld, List<? extends Point2DBasics> concaveHullVertices, List<ConvexPolygon2D> planarRegionConvexPolygons) {
        this.set(transformToWorld, planarRegionConvexPolygons, concaveHullVertices, this.regionId);
    }

    public PlanarRegion(RigidBodyTransformReadOnly transformToWorld, Vertex2DSupplier convexPolygon) {
        this.set(transformToWorld, convexPolygon);
    }

    public void set(RigidBodyTransformReadOnly transformToWorld, Vertex2DSupplier convexPolygon) {
        this.fromLocalToWorldTransform.set(transformToWorld);
        this.fromWorldToLocalTransform.setAndInvert((RigidBodyTransformReadOnly)this.fromLocalToWorldTransform);
        this.concaveHullsVertices.clear();
        for (int i = 0; i < convexPolygon.getNumberOfVertices(); ++i) {
            ((Point2D)this.concaveHullsVertices.add()).set((Tuple2DReadOnly)convexPolygon.getVertex(i));
        }
        this.checkConcaveHullRepeatVertices(false);
        this.convexPolygons.clear();
        ((ConvexPolygon2D)this.convexPolygons.add()).set(convexPolygon);
        this.updateBoundingBox();
        this.updateConvexHull();
        this.updateArea();
    }

    public void set(RigidBodyTransformReadOnly transformToWorld, List<ConvexPolygon2D> planarRegionConvexPolygons) {
        this.set(transformToWorld, planarRegionConvexPolygons, -1);
    }

    public void set(RigidBodyTransformReadOnly transformToWorld, List<ConvexPolygon2D> planarRegionConvexPolygons, int newRegionId) {
        this.fromLocalToWorldTransform.set(transformToWorld);
        this.fromWorldToLocalTransform.setAndInvert((RigidBodyTransformReadOnly)this.fromLocalToWorldTransform);
        this.convexPolygons.clear();
        for (int i = 0; i < planarRegionConvexPolygons.size(); ++i) {
            ((ConvexPolygon2D)this.convexPolygons.add()).set(planarRegionConvexPolygons.get(i));
        }
        this.updateBoundingBox();
        this.updateConvexHull();
        this.updateConcaveHull();
        this.updateArea();
        this.regionId = newRegionId;
    }

    public void set(RigidBodyTransformReadOnly transformToWorld, List<ConvexPolygon2D> planarRegionConvexPolygons, List<? extends Point2DReadOnly> concaveHullVertices, int newRegionId) {
        int i;
        this.fromLocalToWorldTransform.set(transformToWorld);
        this.fromWorldToLocalTransform.setAndInvert((RigidBodyTransformReadOnly)this.fromLocalToWorldTransform);
        this.concaveHullsVertices.clear();
        for (i = 0; i < concaveHullVertices.size(); ++i) {
            ((Point2D)this.concaveHullsVertices.add()).set((Tuple2DReadOnly)concaveHullVertices.get(i));
        }
        this.convexPolygons.clear();
        for (i = 0; i < planarRegionConvexPolygons.size(); ++i) {
            ((ConvexPolygon2D)this.convexPolygons.add()).set(planarRegionConvexPolygons.get(i));
        }
        this.updateConvexHull();
        this.updateBoundingBox();
        this.updateArea();
        this.regionId = newRegionId;
    }

    public boolean isLineSegmentIntersecting(LineSegment2DReadOnly lineSegmentInWorld) {
        LineSegment2D projectedLineSegment = this.projectLineSegmentVerticallyToRegion(lineSegmentInWorld);
        for (int i = 0; i < this.getNumberOfConvexPolygons(); ++i) {
            ConvexPolygon2D polygonToCheck = (ConvexPolygon2D)this.convexPolygons.get(i);
            Point2DBasics[] intersectionPoints = polygonToCheck.intersectionWith((LineSegment2DReadOnly)projectedLineSegment);
            if (intersectionPoints == null || intersectionPoints.length <= 0 || intersectionPoints[0] == null) continue;
            return true;
        }
        return false;
    }

    public void getLineSegmentIntersectionsWhenProjectedVertically(LineSegment2D lineSegmentInWorld, List<Point2DBasics[]> intersectionsInPlaneFrameToPack) {
        LineSegment2D projectedLineSegment = this.projectLineSegmentVerticallyToRegion((LineSegment2DReadOnly)lineSegmentInWorld);
        for (int i = 0; i < this.getNumberOfConvexPolygons(); ++i) {
            Point2DBasics[] intersectionPoints = ((ConvexPolygon2D)this.convexPolygons.get(i)).intersectionWith((LineSegment2DReadOnly)projectedLineSegment);
            if (intersectionPoints == null || intersectionPoints.length <= 0 || intersectionPoints[0] == null) continue;
            intersectionsInPlaneFrameToPack.add(intersectionPoints);
        }
    }

    public boolean isPolygonIntersecting(ConvexPolygon2DReadOnly convexPolygonInWorld) {
        BoundingBox2DReadOnly polygonBoundingBox = convexPolygonInWorld.getBoundingBox();
        if (!this.boundingBox3dInWorld.intersectsInclusiveInXYPlane(polygonBoundingBox)) {
            return false;
        }
        this.projectPolygonVerticallyToRegion(convexPolygonInWorld, (ConvexPolygon2DBasics)this.projectedPolygonTemp);
        if (!this.convexHull.getBoundingBox().intersectsInclusive(this.projectedPolygonTemp.getBoundingBox())) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfConvexPolygons(); ++i) {
            boolean hasIntersection;
            ConvexPolygon2D polygonToCheck = (ConvexPolygon2D)this.convexPolygons.get(i);
            if (!polygonToCheck.getBoundingBox().intersectsExclusive(this.projectedPolygonTemp.getBoundingBox()) || !(hasIntersection = this.convexPolygonTools.doPolygonsIntersect((ConvexPolygon2DReadOnly)polygonToCheck, (ConvexPolygon2DReadOnly)this.projectedPolygonTemp))) continue;
            return true;
        }
        return false;
    }

    public double computeIntersectingArea(ConvexPolygon2DReadOnly convexPolygonInWorld) {
        BoundingBox2DReadOnly polygonBoundingBox = convexPolygonInWorld.getBoundingBox();
        if (!this.boundingBox3dInWorld.intersectsInclusiveInXYPlane(polygonBoundingBox)) {
            return 0.0;
        }
        this.projectPolygonVerticallyToRegion(convexPolygonInWorld, (ConvexPolygon2DBasics)this.projectedPolygonTemp);
        if (!this.convexHull.getBoundingBox().intersectsExclusive(this.projectedPolygonTemp.getBoundingBox())) {
            return 0.0;
        }
        double intersectionArea = 0.0;
        for (int i = 0; i < this.getNumberOfConvexPolygons(); ++i) {
            boolean hasIntersection;
            ConvexPolygon2D polygonToCheck = (ConvexPolygon2D)this.convexPolygons.get(i);
            if (!polygonToCheck.getBoundingBox().intersectsExclusive(this.projectedPolygonTemp.getBoundingBox()) || !(hasIntersection = this.convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)polygonToCheck, (ConvexPolygon2DReadOnly)this.projectedPolygonTemp, (ConvexPolygon2DBasics)this.polygonIntersectionTemp))) continue;
            intersectionArea += this.polygonIntersectionTemp.getArea();
        }
        return intersectionArea;
    }

    public void getPolygonIntersectionsWhenProjectedVertically(ConvexPolygon2DReadOnly convexPolygon2DBasics, ArrayList<ConvexPolygon2D> intersectionsInPlaneFrameToPack) {
        this.projectPolygonVerticallyToRegion(convexPolygon2DBasics, (ConvexPolygon2DBasics)this.tempPolygon);
        for (int i = 0; i < this.getNumberOfConvexPolygons(); ++i) {
            ConvexPolygon2D intersectingPolygon = new ConvexPolygon2D();
            if (!this.convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)this.convexPolygons.get(i), (ConvexPolygon2DReadOnly)this.tempPolygon, (ConvexPolygon2DBasics)intersectingPolygon)) continue;
            intersectionsInPlaneFrameToPack.add(intersectingPolygon);
        }
    }

    public boolean getPolygonIntersection(int convexPolygonIndex, ConvexPolygon2DReadOnly polygonToIntersect, ConvexPolygon2DBasics intersectingPolygonToPack) {
        return this.convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)this.convexPolygons.get(convexPolygonIndex), polygonToIntersect, intersectingPolygonToPack);
    }

    public double getPolygonIntersectionAreaWhenSnapped(ConvexPolygon2D convexPolygon2d, RigidBodyTransform snappingTransform) {
        return this.getPolygonIntersectionAreaWhenSnapped(convexPolygon2d, snappingTransform, null);
    }

    public double getPolygonIntersectionAreaWhenSnapped(ConvexPolygon2D convexPolygon2d, RigidBodyTransform snappingTransform, ConvexPolygon2D intersectionPolygonToPack) {
        ConvexPolygon2D projectedPolygon = this.snapPolygonIntoRegionAndChangeFrameToRegionFrame(convexPolygon2d, snappingTransform);
        double intersectionArea = 0.0;
        if (intersectionPolygonToPack != null) {
            intersectionPolygonToPack.clear();
        }
        RigidBodyTransform inverseSnappingTransform = new RigidBodyTransform((RigidBodyTransformReadOnly)snappingTransform);
        inverseSnappingTransform.invert();
        RigidBodyTransform regionToPolygonTransform = new RigidBodyTransform();
        regionToPolygonTransform.set(inverseSnappingTransform);
        regionToPolygonTransform.multiply((RigidBodyTransformReadOnly)this.fromLocalToWorldTransform);
        for (int i = 0; i < this.getNumberOfConvexPolygons(); ++i) {
            ConvexPolygon2D intersectingPolygon = new ConvexPolygon2D();
            this.convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)this.convexPolygons.get(i), (ConvexPolygon2DReadOnly)projectedPolygon, (ConvexPolygon2DBasics)intersectingPolygon);
            if (intersectingPolygon == null) continue;
            intersectionArea += intersectingPolygon.getArea();
            if (intersectionPolygonToPack == null) continue;
            intersectingPolygon.applyTransform((Transform)regionToPolygonTransform, false);
            intersectionPolygonToPack.addVertices((Vertex2DSupplier)intersectingPolygon);
        }
        if (intersectionPolygonToPack != null) {
            intersectionPolygonToPack.update();
        }
        return intersectionArea;
    }

    public ConvexPolygon2D snapPolygonIntoRegionAndChangeFrameToRegionFrame(ConvexPolygon2D polygonToSnap, RigidBodyTransform snappingTransform) {
        RigidBodyTransform fromPolygonToPlanarRegionTransform = new RigidBodyTransform();
        fromPolygonToPlanarRegionTransform.set(this.fromWorldToLocalTransform);
        fromPolygonToPlanarRegionTransform.multiply((RigidBodyTransformReadOnly)snappingTransform);
        double m02 = Math.abs(fromPolygonToPlanarRegionTransform.getM02());
        double m12 = Math.abs(fromPolygonToPlanarRegionTransform.getM12());
        if (Math.abs(m02) > 1.0E-4 || Math.abs(m12) > 1.0E-4) {
            System.err.println("Snapping transform does not seem consistent with PlanarRegion transform!");
        }
        ConvexPolygon2D snappedPolygonToReturn = new ConvexPolygon2D((Vertex2DSupplier)polygonToSnap);
        snappedPolygonToReturn.applyTransform((Transform)fromPolygonToPlanarRegionTransform, false);
        return snappedPolygonToReturn;
    }

    public ConvexPolygon2D projectPolygonVerticallyToRegion(ConvexPolygon2DReadOnly convexPolygonInWorld) {
        ConvexPolygon2D projectedPolygon = new ConvexPolygon2D();
        this.projectPolygonVerticallyToRegion(convexPolygonInWorld, (ConvexPolygon2DBasics)projectedPolygon);
        return projectedPolygon;
    }

    public void projectPolygonVerticallyToRegion(ConvexPolygon2DReadOnly convexPolygonInWorld, ConvexPolygon2DBasics projectedPolygonToPack) {
        projectedPolygonToPack.clear();
        for (int i = 0; i < convexPolygonInWorld.getNumberOfVertices(); ++i) {
            Point2DReadOnly originalVertex = convexPolygonInWorld.getVertex(i);
            this.tempPoint3D.setX(originalVertex.getX());
            this.tempPoint3D.setY(originalVertex.getY());
            this.tempPoint3D.setZ(this.getPlaneZGivenXY(originalVertex.getX(), originalVertex.getY()));
            this.fromWorldToLocalTransform.transform((Point3DBasics)this.tempPoint3D);
            projectedPolygonToPack.addVertex((Point3DReadOnly)this.tempPoint3D);
        }
        projectedPolygonToPack.update();
    }

    private LineSegment2D projectLineSegmentVerticallyToRegion(LineSegment2DReadOnly lineSegmentInWorld) {
        Point2DReadOnly originalVertex = lineSegmentInWorld.getFirstEndpoint();
        Point3D snappedVertex3d = new Point3D();
        snappedVertex3d.setX(originalVertex.getX());
        snappedVertex3d.setY(originalVertex.getY());
        snappedVertex3d.setZ(this.getPlaneZGivenXY(originalVertex.getX(), originalVertex.getY()));
        this.fromWorldToLocalTransform.transform((Point3DBasics)snappedVertex3d);
        Point2D snappedFirstEndpoint = new Point2D(snappedVertex3d.getX(), snappedVertex3d.getY());
        originalVertex = lineSegmentInWorld.getSecondEndpoint();
        snappedVertex3d.setX(originalVertex.getX());
        snappedVertex3d.setY(originalVertex.getY());
        snappedVertex3d.setZ(this.getPlaneZGivenXY(originalVertex.getX(), originalVertex.getY()));
        this.fromWorldToLocalTransform.transform((Point3DBasics)snappedVertex3d);
        Point2D snappedSecondEndpoint = new Point2D(snappedVertex3d.getX(), snappedVertex3d.getY());
        LineSegment2D projectedLineSegment = new LineSegment2D((Point2DReadOnly)snappedFirstEndpoint, (Point2DReadOnly)snappedSecondEndpoint);
        return projectedLineSegment;
    }

    public boolean isPointInsideByProjectionOntoXYPlane(Point3DReadOnly point3d) {
        return this.isPointInsideByProjectionOntoXYPlane(point3d.getX(), point3d.getY());
    }

    public boolean isPointInsideByProjectionOntoXYPlane(Point2DReadOnly point2d) {
        return this.isPointInsideByProjectionOntoXYPlane(point2d.getX(), point2d.getY());
    }

    public boolean isPointInsideByProjectionOntoXYPlane(double x, double y) {
        Point3D localPoint = new Point3D();
        localPoint.setX(x);
        localPoint.setY(y);
        localPoint.setZ(this.getPlaneZGivenXY(x, y));
        this.fromWorldToLocalTransform.transform((Point3DBasics)localPoint);
        return this.isPointInside(localPoint.getX(), localPoint.getY());
    }

    public boolean isPointInsideByVerticalLineIntersection(double x, double y) {
        Line3D verticalLine = new Line3D(x, y, 0.0, 0.0, 0.0, 1.0);
        return this.intersectWithLine(verticalLine) != null;
    }

    public Point3D intersectWithLine(Line3D projectionLineInWorld) {
        Vector3D planeNormal = new Vector3D(0.0, 0.0, 1.0);
        Point3D pointOnPlane = new Point3D((Tuple2DReadOnly)this.getConvexPolygon(0).getVertex(0));
        Point3D pointOnLineInLocal = new Point3D((Tuple3DReadOnly)projectionLineInWorld.getPoint());
        Vector3D directionOfLineInLocal = new Vector3D((Tuple3DReadOnly)projectionLineInWorld.getDirection());
        this.transformFromWorldToLocal((Transformable)pointOnLineInLocal);
        this.transformFromWorldToLocal((Transformable)directionOfLineInLocal);
        Point3D intersectionWithPlaneInLocal = EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)pointOnLineInLocal, (Vector3DReadOnly)directionOfLineInLocal);
        if (intersectionWithPlaneInLocal == null) {
            return null;
        }
        if (this.isPointInside(intersectionWithPlaneInLocal.getX(), intersectionWithPlaneInLocal.getY())) {
            this.transformFromLocalToWorld((Transformable)intersectionWithPlaneInLocal);
            return intersectionWithPlaneInLocal;
        }
        return null;
    }

    public double distanceToPointByProjectionOntoXYPlane(Point2DReadOnly point2d) {
        return this.distanceToPointByProjectionOntoXYPlane(point2d.getX(), point2d.getY());
    }

    public double distanceToPointByProjectionOntoXYPlane(double x, double y) {
        this.localPoint.setX(x);
        this.localPoint.setY(y);
        this.localPoint.setZ(this.getPlaneZGivenXY(x, y));
        this.fromWorldToLocalTransform.transform((Point3DBasics)this.localPoint);
        this.localPoint2D.set((Tuple3DReadOnly)this.localPoint);
        return this.distanceToPoint((Point2DReadOnly)this.localPoint2D);
    }

    public boolean isPointInside(Point3DReadOnly point3dInWorld, double maximumOrthogonalDistance) {
        Point3D localPoint = new Point3D();
        this.fromWorldToLocalTransform.transform(point3dInWorld, (Point3DBasics)localPoint);
        if (!MathTools.intervalContains((double)localPoint.getZ(), (double)maximumOrthogonalDistance)) {
            return false;
        }
        return this.isPointInside(localPoint.getX(), localPoint.getY());
    }

    public boolean isPointInWorld2DInside(Point3DReadOnly point3dInWorld) {
        return this.isPointInWorld2DInside(point3dInWorld, 1.0E-7);
    }

    public boolean isPointInWorld2DInside(Point3DReadOnly point3dInWorld, double epsilon) {
        Point3D localPoint = new Point3D();
        this.fromWorldToLocalTransform.transform(point3dInWorld, (Point3DBasics)localPoint);
        return this.isPointInside(localPoint.getX(), localPoint.getY(), epsilon);
    }

    public boolean isPointOnOrSlightlyAbove(Point3DReadOnly point3dInWorld, double distanceFromPlane) {
        MathTools.checkPositive((double)distanceFromPlane);
        Point3D localPoint = new Point3D();
        this.fromWorldToLocalTransform.transform(point3dInWorld, (Point3DBasics)localPoint);
        boolean onOrAbove = localPoint.getZ() >= 0.0;
        boolean withinDistance = localPoint.getZ() < distanceFromPlane;
        boolean isInsideXY = this.isPointInsideExclusive(localPoint.getX(), localPoint.getY());
        return onOrAbove && withinDistance && isInsideXY;
    }

    public boolean isPointOnOrSlightlyBelow(Point3DReadOnly point3dInWorld, double distanceFromPlane) {
        MathTools.checkPositive((double)distanceFromPlane);
        Point3D localPoint = new Point3D();
        this.fromWorldToLocalTransform.transform(point3dInWorld, (Point3DBasics)localPoint);
        boolean onOrBelow = localPoint.getZ() <= 0.0;
        boolean withinDistance = localPoint.getZ() > distanceFromPlane * -1.0;
        boolean isInsideXY = this.isPointInsideExclusive(localPoint.getX(), localPoint.getY());
        return onOrBelow && withinDistance && isInsideXY;
    }

    public boolean isPointInside(Point2DReadOnly point2dInLocal) {
        return this.isPointInside(point2dInLocal.getX(), point2dInLocal.getY());
    }

    public boolean isPointInside(Point2DReadOnly point2dInLocal, double epsilon) {
        return this.isPointInside(point2dInLocal.getX(), point2dInLocal.getY(), epsilon);
    }

    public boolean isPointInsideExclusive(double xCoordinateInLocal, double yCoordinateInLocal) {
        return PlanarRegionTools.isPointInLocalInsidePlanarRegion(this, xCoordinateInLocal, yCoordinateInLocal, 0.0);
    }

    @Override
    public boolean isPointInside(double xCoordinateInLocal, double yCoordinateInLocal) {
        return PlanarRegionTools.isPointInLocalInsidePlanarRegion(this, xCoordinateInLocal, yCoordinateInLocal, 1.0E-7);
    }

    public boolean isPointInside(double xCoordinateInLocal, double yCoordinateInLocal, double epsilon) {
        return PlanarRegionTools.isPointInLocalInsidePlanarRegion(this, xCoordinateInLocal, yCoordinateInLocal, epsilon);
    }

    public double distanceToPoint(Point2DReadOnly localPoint) {
        double shortestDistanceToPoint = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.convexPolygons.size(); ++i) {
            double distance = ((ConvexPolygon2D)this.convexPolygons.get(i)).distance(localPoint);
            if (!(distance < shortestDistanceToPoint)) continue;
            shortestDistanceToPoint = distance;
        }
        return shortestDistanceToPoint;
    }

    public double getPlaneZGivenXY(double xWorld, double yWorld) {
        double x0 = this.fromLocalToWorldTransform.getM03();
        double y0 = this.fromLocalToWorldTransform.getM13();
        double z0 = this.fromLocalToWorldTransform.getM23();
        double a = this.fromLocalToWorldTransform.getM02();
        double b = this.fromLocalToWorldTransform.getM12();
        double c = this.fromLocalToWorldTransform.getM22();
        double z = a / c * (x0 - xWorld) + b / c * (y0 - yWorld) + z0;
        return z;
    }

    public void setRegionId(int regionId) {
        this.regionId = regionId;
    }

    @Override
    public int getRegionId() {
        return this.regionId;
    }

    public boolean hasARegionId() {
        return this.regionId != -1;
    }

    public boolean isEmpty() {
        return this.convexPolygons.isEmpty();
    }

    public boolean containsNaN() {
        boolean containsNaN = this.getBoundingBox3dInWorld().containsNaN();
        if (containsNaN) {
            LogTools.error((String)"Region bounding box contained NaN");
        }
        return containsNaN;
    }

    public List<Point2D> getConcaveHull() {
        return this.concaveHullsVertices;
    }

    private void checkConcaveHullRepeatVertices(boolean throwException) {
        if (this.concaveHullsVertices.size() < 2) {
            return;
        }
        for (int i = 0; i < this.concaveHullsVertices.size(); ++i) {
            Point2DReadOnly nextVertex;
            int nextIndex = (i + 1) % this.concaveHullsVertices.size();
            Point2DReadOnly vertex = (Point2DReadOnly)this.concaveHullsVertices.get(i);
            if (!(vertex.distance(nextVertex = (Point2DReadOnly)this.concaveHullsVertices.get(nextIndex)) < 1.0E-7)) continue;
            LogTools.error((String)("Setting concave hull with repeat vertices" + vertex));
            if (!throwException) continue;
            throw new RuntimeException("Setting concave hull with repeat vertices" + vertex);
        }
    }

    public Point2DReadOnly getConcaveHullVertex(int i) {
        return (Point2DReadOnly)this.concaveHullsVertices.get(i);
    }

    public int getConcaveHullSize() {
        return this.concaveHullsVertices.size();
    }

    public int getNumberOfConvexPolygons() {
        return this.convexPolygons.size();
    }

    public List<ConvexPolygon2D> getConvexPolygons() {
        return this.convexPolygons;
    }

    public ConvexPolygon2D getConvexPolygon(int i) {
        return (ConvexPolygon2D)this.convexPolygons.get(i);
    }

    public ConvexPolygon2D getLastConvexPolygon() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getConvexPolygon(this.getNumberOfConvexPolygons() - 1);
    }

    public ConvexPolygon2D pollConvexPolygon(int i) {
        ConvexPolygon2D polledPolygon = (ConvexPolygon2D)this.convexPolygons.remove(i);
        this.updateBoundingBox();
        this.updateConvexHull();
        return polledPolygon;
    }

    public ConvexPolygon2D pollLastConvexPolygon() {
        if (this.isEmpty()) {
            return null;
        }
        return this.pollConvexPolygon(this.getNumberOfConvexPolygons() - 1);
    }

    public Point3DReadOnly getPoint() {
        return this.origin;
    }

    public UnitVector3DReadOnly getNormal() {
        return this.normal;
    }

    public boolean isVertical() {
        return Math.abs(this.fromLocalToWorldTransform.getM22()) < 1.0E-10;
    }

    public void getPointInRegion(Point3DBasics pointToPack) {
        pointToPack.set((Tuple3DReadOnly)this.fromLocalToWorldTransform.getTranslation());
    }

    public void getTransformToWorld(RigidBodyTransform transformToPack) {
        transformToPack.set(this.fromLocalToWorldTransform);
    }

    public void getTransformToLocal(RigidBodyTransform transformToPack) {
        transformToPack.set(this.fromWorldToLocalTransform);
    }

    @Override
    public RigidBodyTransformReadOnly getTransformToLocal() {
        return this.fromWorldToLocalTransform;
    }

    @Override
    public RigidBodyTransformReadOnly getTransformToWorld() {
        return this.fromLocalToWorldTransform;
    }

    public RigidBodyTransform getTransformToWorldCopy() {
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        this.getTransformToWorld(transformToWorld);
        return transformToWorld;
    }

    public RigidBodyTransform getTransformToLocalCopy() {
        RigidBodyTransform transformToLocal = new RigidBodyTransform();
        this.getTransformToLocal(transformToLocal);
        return transformToLocal;
    }

    public BoundingBox3D getBoundingBox3dInWorld() {
        return this.boundingBox3dInWorld;
    }

    public BoundingBox3D getBoundingBox3dInWorldCopy() {
        return new BoundingBox3D((BoundingBox3DReadOnly)this.boundingBox3dInWorld);
    }

    public void getBoundingBox3dInWorld(BoundingBox3D boundingBox3dToPack) {
        boundingBox3dToPack.set(this.boundingBox3dInWorld);
    }

    public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        if (this.convexHull.isEmpty()) {
            return false;
        }
        if (this.convexHull.getNumberOfVertices() == 1) {
            supportingVertexToPack.set((Tuple2DReadOnly)this.convexHull.getVertex(0), 0.0);
            this.transformFromLocalToWorld((Transformable)supportingVertexToPack);
            return true;
        }
        supportingVertexToPack.set((Tuple3DReadOnly)supportDirection);
        this.fromWorldToLocalTransform.getRotation().transform((Tuple3DBasics)supportingVertexToPack);
        double vx = supportingVertexToPack.getX();
        double vy = supportingVertexToPack.getY();
        double dotProduct0 = vx * this.convexHull.getVertex(0).getX() + vy * this.convexHull.getVertex(0).getY();
        double dotProductCW = vx * this.convexHull.getVertex(1).getX() + vy * this.convexHull.getVertex(1).getY();
        double dotProductCCW = vx * this.convexHull.getVertex(this.convexHull.getNumberOfVertices() - 1).getX() + vy * this.convexHull.getVertex(this.convexHull.getNumberOfVertices() - 1).getY();
        int bestVertexIndex = 0;
        if (this.convexHull.getNumberOfVertices() == 2) {
            bestVertexIndex = dotProduct0 > dotProductCW ? 0 : 1;
        } else if (dotProduct0 < Math.max(dotProductCW, dotProductCCW)) {
            double dotProduct;
            int indexToCheck;
            boolean iterateClockwise = dotProductCW > dotProductCCW;
            double previousDotProduct = iterateClockwise ? dotProductCW : dotProductCCW;
            int n = indexToCheck = iterateClockwise ? 2 : this.convexHull.getNumberOfVertices() - 2;
            while ((dotProduct = vx * this.convexHull.getVertex(indexToCheck).getX() + vy * this.convexHull.getVertex(indexToCheck).getY()) > previousDotProduct) {
                previousDotProduct = dotProduct;
                indexToCheck = iterateClockwise ? this.convexHull.getNextVertexIndex(indexToCheck) : this.convexHull.getPreviousVertexIndex(indexToCheck);
            }
            bestVertexIndex = iterateClockwise ? this.convexHull.getPreviousVertexIndex(indexToCheck) : this.convexHull.getNextVertexIndex(indexToCheck);
        }
        supportingVertexToPack.set((Tuple2DReadOnly)this.convexHull.getVertex(bestVertexIndex), 0.0);
        this.transformFromLocalToWorld((Transformable)supportingVertexToPack);
        return true;
    }

    public boolean epsilonEquals(PlanarRegion other, double epsilon) {
        if (!this.fromLocalToWorldTransform.epsilonEquals((EuclidGeometry)other.fromLocalToWorldTransform, epsilon)) {
            return false;
        }
        if (!this.fromWorldToLocalTransform.epsilonEquals((EuclidGeometry)other.fromWorldToLocalTransform, epsilon)) {
            return false;
        }
        if (this.getNumberOfConvexPolygons() != other.getNumberOfConvexPolygons()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfConvexPolygons(); ++i) {
            if (((ConvexPolygon2D)this.convexPolygons.get(i)).epsilonEquals((EuclidGeometry)other.convexPolygons.get(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    public void set(PlanarRegion other) {
        int i;
        this.regionId = other.regionId;
        this.fromLocalToWorldTransform.set(other.fromLocalToWorldTransform);
        this.fromWorldToLocalTransform.set(other.fromWorldToLocalTransform);
        this.convexPolygons.clear();
        for (i = 0; i < other.getNumberOfConvexPolygons(); ++i) {
            ((ConvexPolygon2D)this.convexPolygons.add()).set((ConvexPolygon2D)other.convexPolygons.get(i));
        }
        this.concaveHullsVertices.clear();
        for (i = 0; i < other.getConcaveHullSize(); ++i) {
            ((Point2D)this.concaveHullsVertices.add()).set(other.getConcaveHull().get(i));
        }
        this.updateBoundingBox();
        this.convexHull.set(other.convexHull);
        this.area = other.area;
        this.numberOfTimesMatched = other.numberOfTimesMatched;
        this.tickOfLastMeasurement = other.tickOfLastMeasurement;
    }

    public void setTransformOnly(PlanarRegion other) {
        this.fromLocalToWorldTransform.set(other.fromLocalToWorldTransform);
        this.fromWorldToLocalTransform.set(other.fromWorldToLocalTransform);
    }

    public void setBoundingBoxEpsilon(double epsilon) {
        this.boundingBoxEpsilon = epsilon;
        this.updateBoundingBox();
    }

    public void updateBoundingBox() {
        this.boundingBox3dInWorld.set(Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        for (int i = 0; i < this.getNumberOfConvexPolygons(); ++i) {
            ConvexPolygon2D convexPolygon = this.getConvexPolygon(i);
            for (int j = 0; j < convexPolygon.getNumberOfVertices(); ++j) {
                Point2DReadOnly vertex = convexPolygon.getVertex(j);
                this.tempPointForConvexPolygonProjection.set(vertex.getX(), vertex.getY(), 0.0);
                this.fromLocalToWorldTransform.transform((Point3DBasics)this.tempPointForConvexPolygonProjection);
                this.boundingBox3dInWorld.updateToIncludePoint((Point3DReadOnly)this.tempPointForConvexPolygonProjection);
            }
        }
        Point3DBasics minPoint = this.boundingBox3dInWorld.getMinPoint();
        Point3DBasics maxPoint = this.boundingBox3dInWorld.getMaxPoint();
        this.boundingBox3dInWorld.setMin(minPoint.getX() - this.boundingBoxEpsilon, minPoint.getY() - this.boundingBoxEpsilon, minPoint.getZ() - this.boundingBoxEpsilon);
        this.boundingBox3dInWorld.setMax(maxPoint.getX() + this.boundingBoxEpsilon, maxPoint.getY() + this.boundingBoxEpsilon, maxPoint.getZ() + this.boundingBoxEpsilon);
    }

    public void updateConvexHull() {
        this.convexHull.clear();
        for (int i = 0; i < this.getNumberOfConvexPolygons(); ++i) {
            ConvexPolygon2D convexPolygon = this.getConvexPolygon(i);
            for (int j = 0; j < convexPolygon.getNumberOfVertices(); ++j) {
                this.convexHull.addVertex(convexPolygon.getVertex(j));
            }
        }
        this.convexHull.update();
    }

    private void updateConcaveHull() {
        int iterations;
        this.concaveHullsVertices.clear();
        if (this.convexPolygons.isEmpty()) {
            return;
        }
        if (this.convexPolygons.size() == 1) {
            for (int i = 0; i < ((ConvexPolygon2D)this.convexPolygons.get(0)).getNumberOfVertices(); ++i) {
                ((Point2D)this.concaveHullsVertices.add()).set((Tuple2DReadOnly)((ConvexPolygon2D)this.convexPolygons.get(0)).getVertex(i));
            }
            return;
        }
        this.visited.clear();
        int maximumIterations = 0;
        double minX = Double.MAX_VALUE;
        int minXPolygonIndex = -1;
        for (int i = 0; i < this.convexPolygons.size(); ++i) {
            ConvexPolygon2D polygon = (ConvexPolygon2D)this.convexPolygons.get(i);
            this.visited.add(false);
            if (polygon.getNumberOfVertices() < 3) {
                return;
            }
            if (polygon.getVertex(0).getX() < minX) {
                minX = polygon.getVertex(0).getX();
                minXPolygonIndex = i;
            }
            maximumIterations += polygon.getNumberOfVertices();
        }
        Point2DReadOnly vertex = ((ConvexPolygon2D)this.convexPolygons.get(minXPolygonIndex)).getVertex(0);
        double maxDotProduct = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.convexPolygons.size(); ++i) {
            if (!((ConvexPolygon2D)this.convexPolygons.get(i)).getVertex(0).epsilonEquals((EuclidGeometry)vertex, 1.0E-7)) continue;
            double vx = vertex.getX() - ((ConvexPolygon2D)this.convexPolygons.get(i)).getPreviousVertex(0).getX();
            double vy = vertex.getY() - ((ConvexPolygon2D)this.convexPolygons.get(i)).getPreviousVertex(0).getY();
            double dotProduct = vy / EuclidCoreTools.norm((double)vx, (double)vy);
            if (!(dotProduct > maxDotProduct)) continue;
            maxDotProduct = dotProduct;
            minXPolygonIndex = i;
        }
        ((Point2D)this.concaveHullsVertices.add()).set((Tuple2DReadOnly)((ConvexPolygon2D)this.convexPolygons.get(minXPolygonIndex)).getVertex(0));
        this.visited.set(minXPolygonIndex, true);
        int polygonIndex = minXPolygonIndex;
        int vertexIndex = 0;
        for (iterations = 0; iterations < maximumIterations; ++iterations) {
            int[] neighborRegionAndVertexIndices = this.findNeighborRegionSharingConcaveHullVertex(polygonIndex, vertexIndex);
            if (neighborRegionAndVertexIndices == null) {
                vertexIndex = ((ConvexPolygon2D)this.convexPolygons.get(polygonIndex)).getNextVertexIndex(vertexIndex);
            } else {
                polygonIndex = neighborRegionAndVertexIndices[0];
                vertexIndex = ((ConvexPolygon2D)this.convexPolygons.get(polygonIndex)).getNextVertexIndex(neighborRegionAndVertexIndices[1]);
            }
            if (polygonIndex == minXPolygonIndex && vertexIndex == 0) break;
            ((Point2D)this.concaveHullsVertices.add()).set((Tuple2DReadOnly)((ConvexPolygon2D)this.convexPolygons.get(polygonIndex)).getVertex(vertexIndex));
            this.visited.set(polygonIndex, true);
        }
        if (iterations == maximumIterations) {
            LogTools.error((String)("Unable to solve for concave hull. region " + this.regionId));
            this.concaveHullsVertices.clear();
        }
    }

    public void checkConcaveHullIsNotSeparated() {
        boolean allVisited = true;
        for (Boolean value : this.visited) {
            allVisited &= value.booleanValue();
        }
        if (!allVisited) {
            LogTools.error((String)("Concave hull is separated. Not all convex polygons were visited. This planar region is invalid. " + this.visited));
            throw new RuntimeException("Concave hull is separated. Not all convex polygons were visited. This planar region is invalid. " + this.visited);
        }
    }

    private int[] findNeighborRegionSharingConcaveHullVertex(int polygonIndex, int vertexIndex) {
        ConvexPolygon2D inputPolygon = (ConvexPolygon2D)this.convexPolygons.get(polygonIndex);
        Point2DReadOnly vertex = inputPolygon.getVertex(vertexIndex);
        Point2DReadOnly previousVertex = inputPolygon.getPreviousVertex(vertexIndex);
        double vx = previousVertex.getX() - vertex.getX();
        double vy = previousVertex.getY() - vertex.getY();
        double maxDotProduct = Double.NEGATIVE_INFINITY;
        int neighborPolygonIndex = -1;
        int neighborPolygonVertexIndex = -1;
        double epsilon = 1.0E-7;
        block0: for (int i = 0; i < this.convexPolygons.size(); ++i) {
            if (i == polygonIndex) continue;
            ConvexPolygon2D polygon = (ConvexPolygon2D)this.convexPolygons.get(i);
            for (int j = 0; j < polygon.getNumberOfVertices(); ++j) {
                Point2DReadOnly candidateVertex = polygon.getVertex(j);
                if (!candidateVertex.epsilonEquals((EuclidGeometry)vertex, epsilon)) continue;
                Point2DReadOnly nextCandidateVertex = polygon.getNextVertex(j);
                double ux = nextCandidateVertex.getX() - candidateVertex.getX();
                double uy = nextCandidateVertex.getY() - candidateVertex.getY();
                double dotProduct = (ux * vx + uy * vy) / EuclidCoreTools.norm((double)ux, (double)uy);
                double crossProduct = ux * vy - uy * vx;
                if (crossProduct < 0.0) {
                    dotProduct = -2.0 - dotProduct;
                }
                if (!(dotProduct > maxDotProduct)) continue block0;
                maxDotProduct = dotProduct;
                neighborPolygonIndex = i;
                neighborPolygonVertexIndex = j;
                continue block0;
            }
        }
        if (neighborPolygonIndex >= 0) {
            return new int[]{neighborPolygonIndex, neighborPolygonVertexIndex};
        }
        return null;
    }

    public PlanarRegion copy() {
        PlanarRegion planarRegion = new PlanarRegion();
        planarRegion.set(this);
        return planarRegion;
    }

    public ConvexPolygon2D getConvexHull() {
        return this.convexHull;
    }

    public static PlanarRegion generatePlanarRegionFromRandomPolygonsWithRandomTransform(Random random, int numberOfRandomlyGeneratedPolygons, double maxAbsoluteXYForPolygons, int numberOfPossiblePointsForPolygons) {
        ArrayList<ConvexPolygon2D> regionConvexPolygons = new ArrayList<ConvexPolygon2D>();
        for (int i = 0; i < numberOfRandomlyGeneratedPolygons; ++i) {
            ConvexPolygon2D randomPolygon = EuclidGeometryRandomTools.nextConvexPolygon2D((Random)random, (double)maxAbsoluteXYForPolygons, (int)numberOfPossiblePointsForPolygons);
            regionConvexPolygons.add(randomPolygon);
        }
        for (ConvexPolygon2D convexPolygon : regionConvexPolygons) {
            convexPolygon.update();
        }
        Vector3D randomTranslation = RandomGeometry.nextVector3D(random, 10.0);
        Quaternion randomOrientation = RandomGeometry.nextQuaternion(random, Math.toRadians(45.0));
        RigidBodyTransform regionTransform = new RigidBodyTransform((Orientation3DReadOnly)randomOrientation, (Tuple3DReadOnly)randomTranslation);
        return new PlanarRegion((RigidBodyTransformReadOnly)regionTransform, regionConvexPolygons);
    }

    public void applyTransform(RigidBodyTransformReadOnly transform) {
        transform.transform((RigidBodyTransformBasics)this.fromLocalToWorldTransform);
        this.fromWorldToLocalTransform.set(this.fromLocalToWorldTransform);
        this.fromWorldToLocalTransform.invert();
        this.updateBoundingBox();
        this.updateConvexHull();
    }

    public void update() {
        this.updateBoundingBox();
        this.updateConvexHull();
    }

    public Line3D intersectionWith(Plane3D plane) {
        Plane3D thisPlane = this.getPlane();
        Point3D intersectionPoint = new Point3D();
        Vector3D intersectionDirection = new Vector3D();
        EuclidGeometryTools.intersectionBetweenTwoPlane3Ds((Point3DReadOnly)thisPlane.getPoint(), (Vector3DReadOnly)thisPlane.getNormal(), (Point3DReadOnly)plane.getPoint(), (Vector3DReadOnly)plane.getNormal(), (Point3DBasics)intersectionPoint, (Vector3DBasics)intersectionDirection);
        return new Line3D((Point3DReadOnly)intersectionPoint, (Vector3DReadOnly)intersectionDirection);
    }

    public List<LineSegment3D> intersect(PlanarRegion other) {
        ArrayList<LineSegment3D> ret = new ArrayList<LineSegment3D>();
        if (!this.boundingBox3dInWorld.intersectsInclusive((BoundingBox3DReadOnly)other.boundingBox3dInWorld)) {
            return ret;
        }
        Line3D fullIntersectionLine = this.intersectionWith(other.getPlane());
        List<LineSegment3D> intersectionsWithThis = this.projectAndIntersect(fullIntersectionLine);
        List<LineSegment3D> intersectionsWithOther = other.projectAndIntersect(fullIntersectionLine);
        for (LineSegment3D intersectionWithThis : intersectionsWithThis) {
            Point3DBasics start = intersectionWithThis.getFirstEndpoint();
            Point3DBasics end = intersectionWithThis.getSecondEndpoint();
            for (LineSegment3D intersectionWithOther : intersectionsWithOther) {
                if (intersectionWithThis.getDirection(false).dot((Tuple3DReadOnly)intersectionWithOther.getDirection(false)) < 0.0) {
                    intersectionWithOther.flipDirection();
                }
                double startPercent = EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)start, (Point3DReadOnly)intersectionWithOther.getFirstEndpoint(), (Point3DReadOnly)intersectionWithOther.getSecondEndpoint());
                double endPercent = EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)end, (Point3DReadOnly)intersectionWithOther.getFirstEndpoint(), (Point3DReadOnly)intersectionWithOther.getSecondEndpoint());
                if (startPercent < 0.0 && endPercent < 0.0 || startPercent > 1.0 && endPercent > 1.0) continue;
                boolean startThisInOther = MathTools.intervalContains((double)startPercent, (double)0.0, (double)1.0);
                boolean endThisInOther = MathTools.intervalContains((double)endPercent, (double)0.0, (double)1.0);
                if (startThisInOther && endThisInOther) {
                    ret.add(intersectionWithThis);
                    continue;
                }
                if (!startThisInOther && !endThisInOther) {
                    ret.add(intersectionWithOther);
                    continue;
                }
                if (startThisInOther && !endThisInOther) {
                    ret.add(new LineSegment3D((Point3DReadOnly)start, (Point3DReadOnly)intersectionWithOther.getSecondEndpoint()));
                    continue;
                }
                if (!startThisInOther && endThisInOther) {
                    ret.add(new LineSegment3D((Point3DReadOnly)intersectionWithOther.getFirstEndpoint(), (Point3DReadOnly)end));
                    continue;
                }
                throw new RuntimeException("Mistake in Algorithm.");
            }
        }
        return ret;
    }

    public List<LineSegment3D> projectAndIntersect(Line3D line) {
        Line3D localLine = new Line3D((Line3DReadOnly)line);
        localLine.applyTransform((Transform)this.fromWorldToLocalTransform);
        Line2D lineInPlane = new Line2D(localLine.getPointX(), localLine.getPointY(), localLine.getDirectionX(), localLine.getDirectionY());
        ArrayList<LineSegment3D> ret = new ArrayList<LineSegment3D>();
        for (ConvexPolygon2D polygon : this.convexPolygons) {
            Point2DBasics[] intersectionPoints = polygon.intersectionWith((Line2DReadOnly)lineInPlane);
            if (intersectionPoints == null || intersectionPoints.length < 2) continue;
            Point3D point0 = new Point3D((Tuple2DReadOnly)intersectionPoints[0]);
            Point3D point1 = new Point3D((Tuple2DReadOnly)intersectionPoints[1]);
            LineSegment3D intersection = new LineSegment3D((Point3DReadOnly)point0, (Point3DReadOnly)point1);
            intersection.applyTransform((Transform)this.fromLocalToWorldTransform);
            ret.add(intersection);
        }
        return ret;
    }

    public Plane3D getPlane() {
        Plane3D ret = new Plane3D();
        ret.getPoint().set(this.fromLocalToWorldTransform.getM03(), this.fromLocalToWorldTransform.getM13(), this.fromLocalToWorldTransform.getM23());
        ret.getNormal().set(this.fromLocalToWorldTransform.getM02(), this.fromLocalToWorldTransform.getM12(), this.fromLocalToWorldTransform.getM22());
        return ret;
    }

    public void projectOntoPlane(Vector4D plane) {
        UnitVector3D futureNormal = new UnitVector3D(plane.getX(), plane.getY(), plane.getZ());
        Point3D futureOrigin = GeometryTools.projectPointOntoPlane((Vector4DReadOnly)plane, this.getPoint());
        Vector3D axis = new Vector3D();
        axis.cross((Tuple3DReadOnly)this.getNormal(), (Tuple3DReadOnly)futureNormal);
        double angle = this.getNormal().angle((Vector3DReadOnly)futureNormal);
        AxisAngle rotationToFutureRegion = new AxisAngle((Vector3DReadOnly)axis, angle);
        Vector3D translationToFutureRegion = new Vector3D();
        translationToFutureRegion.sub((Tuple3DReadOnly)futureOrigin, (Tuple3DReadOnly)this.getPoint());
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.appendOrientation((Orientation3DReadOnly)rotationToFutureRegion);
        transform.appendTranslation((Tuple3DReadOnly)translationToFutureRegion);
        this.applyTransform((RigidBodyTransformReadOnly)transform);
    }

    public void transformFromWorldToLocal(Transformable objectToTransform) {
        objectToTransform.applyTransform((Transform)this.fromWorldToLocalTransform);
    }

    public void transformFromLocalToWorld(Transformable objectToTransform) {
        objectToTransform.applyTransform((Transform)this.fromLocalToWorldTransform);
    }

    public void updateArea() {
        this.area = PlanarRegionTools.computePlanarRegionArea(this);
    }

    public ConvexPolygonTools getConvexPolygonTools() {
        return this.convexPolygonTools;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("boundingBox: " + this.boundingBox3dInWorld.toString() + "\n");
        buffer.append("number of polygons: " + this.convexPolygons.size() + "\n");
        buffer.append("transformToWorld:\n" + this.fromLocalToWorldTransform + "\n");
        int maxNumberOfPolygonsToPrint = 5;
        for (int i = 0; i < Math.min(maxNumberOfPolygonsToPrint, this.convexPolygons.size()); ++i) {
            buffer.append(this.convexPolygons.get(i) + "\n");
        }
        if (this.convexPolygons.size() > maxNumberOfPolygonsToPrint) {
            buffer.append("...\n");
        }
        return buffer.toString();
    }

    public String getDebugString() {
        return String.format("Regions ID: %d\nArea: %.2f\nConcave Hull Size: %d\nMatched: %d\nOrigin: %s\nNormal: %s\nTime: %d", this.regionId, this.getArea(), this.getConcaveHullSize(), this.getNumberOfTimesMatched(), String.format("%.2f, %.2f, %.2f", this.origin.getX(), this.origin.getY(), this.origin.getZ()), String.format("%.2f, %.2f, %.2f", this.normal.getX(), this.normal.getY(), this.normal.getZ()), this.getTickOfLastMeasurement());
    }

    public Point3D getConcaveHullPoint3DInWorld(int index) {
        Point2D pointInPlane = (Point2D)this.concaveHullsVertices.get(index);
        Point3D pointInWorld = new Point3D(pointInPlane.getX(), pointInPlane.getY(), 0.0);
        pointInWorld.applyTransform((Transform)this.fromLocalToWorldTransform);
        return pointInWorld;
    }

    public int getNumberOfTimesMatched() {
        return this.numberOfTimesMatched;
    }

    public void incrementNumberOfTimesMatched() {
        ++this.numberOfTimesMatched;
    }

    public double getArea() {
        return this.area;
    }

    public void setArea(double area) {
        this.area = area;
    }

    public int getTickOfLastMeasurement() {
        return this.tickOfLastMeasurement;
    }

    public void setTickOfLastMeasurement(int tickOfLastMeasurement) {
        this.tickOfLastMeasurement = tickOfLastMeasurement;
    }
}

