/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.robotics.geometry.PlanarLandmark;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class PlanarLandmarkList {
    private ArrayList<PlanarLandmark> planes = new ArrayList();

    public void addPlane(PlanarLandmark plane) {
        this.planes.add(plane);
    }

    public PlanarLandmark getPlanarLandmarkById(int id) {
        return this.planes.get(id);
    }

    public PlanarLandmarkList() {
    }

    public PlanarLandmarkList(PlanarRegionsList planarRegionsList) {
        for (PlanarRegion planarRegion : planarRegionsList.getPlanarRegionsAsList()) {
            PlanarLandmark plane = new PlanarLandmark(planarRegion.getRegionId(), planarRegion.getPlane(), planarRegion.getBoundingBox3dInWorld(), planarRegion.getTransformToWorld(), planarRegion.getArea());
            this.planes.add(plane);
        }
    }

    public ArrayList<PlanarLandmark> getPlanarLandmarksAsList() {
        return this.planes;
    }

    public PlanarLandmarkList copy() {
        PlanarLandmarkList landmarksListCopy = new PlanarLandmarkList();
        for (PlanarLandmark landmark : this.planes) {
            landmarksListCopy.addPlane(new PlanarLandmark(landmark));
        }
        return landmarksListCopy;
    }

    public void applyTransform(RigidBodyTransformReadOnly transform) {
        for (PlanarLandmark plane : this.planes) {
            plane.applyTransform(transform);
        }
    }

    public void clear() {
        this.planes.clear();
    }

    public void addAll(PlanarLandmarkList other) {
        this.planes.addAll(other.getPlanarLandmarksAsList());
    }

    public void addAll(PlanarRegionsList regions) {
        for (PlanarRegion region : regions.getPlanarRegionsAsList()) {
            PlanarLandmark plane = new PlanarLandmark(region.getRegionId(), region.getPlane(), region.getBoundingBox3dInWorld(), region.getTransformToWorld(), region.getArea());
            this.planes.add(plane);
        }
    }
}

