/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import gnu.trove.list.array.TIntArrayList;
import java.util.List;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.Bound;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DBasics;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.EuclidCoreMissingTools;
import us.ihmc.robotics.EuclidGeometryPolygonMissingTools;
import us.ihmc.robotics.geometry.ConvexPolygonConstructorFromInteriorOfRays;
import us.ihmc.robotics.geometry.ConvexPolygonCutResult;
import us.ihmc.robotics.geometry.algorithms.FrameConvexPolygonWithLineIntersector2d;
import us.ihmc.robotics.robotSide.RobotSide;

public class ConvexPolygonTools {
    private static final boolean DEBUG = false;
    private final transient int[][] verticesIndices = new int[2][2];
    private final transient Vector2D caliperForPolygonP = new Vector2D();
    private final transient Vector2D caliperForPolygonQ = new Vector2D();
    private final transient Point2D lineStart = new Point2D();
    private final transient Point2D lineEnd = new Point2D();
    private final transient TIntArrayList bridgeIndicesP = new TIntArrayList();
    private final transient TIntArrayList bridgeIndicesQ = new TIntArrayList();
    private final transient TIntArrayList bridgeWasOnLeft = new TIntArrayList();
    private final transient Vector2D vectorToNextPointOnPolygonP = new Vector2D();
    private final transient Vector2D vectorToNextPointOnPolygonQ = new Vector2D();
    private final transient LineSegment2D polygonWithTwoVerticesAsLineSegment = new LineSegment2D();
    private final transient Point2D intersection1 = new Point2D();
    private final transient Point2D intersection2 = new Point2D();
    private final transient Point2D intersection = new Point2D();
    private final transient RecyclingArrayList<TIntArrayList> crossingIndices = new RecyclingArrayList(TIntArrayList.class);
    private final transient Point2D referencePointInPCopy = new Point2D();
    private final transient RecyclingArrayList<Line2D> rays = new RecyclingArrayList(Line2D.class);
    private final transient Vector2D edgeOnQ = new Vector2D();
    private final transient Vector2D edgeOnP = new Vector2D();
    private final transient ConvexPolygonConstructorFromInteriorOfRays convexPolygonConstructorFromInteriorOfRays = new ConvexPolygonConstructorFromInteriorOfRays();
    private final transient Point2D intersectionPoint1 = new Point2D();
    private final transient Point2D intersectionPoint2 = new Point2D();
    private final transient ConvexPolygon2D intersectingPolygonToPack = new ConvexPolygon2D();
    private final transient int[] v1Tangents = new int[2];
    private final transient int[] v2Tangents = new int[2];
    private final transient int[] updatedIndices = new int[4];
    private final transient Vector2D tangent1 = new Vector2D();
    private final transient Vector2D tangent2 = new Vector2D();
    private final transient Vector2D base = new Vector2D();
    private final transient Vector2D first = new Vector2D();
    private final transient Vector2D second = new Vector2D();
    private final transient Vector2D m = new Vector2D();
    private final transient Vector2D mReversed = new Vector2D();
    private final transient Vector2D edge1A = new Vector2D();
    private final transient Vector2D edge1B = new Vector2D();
    private final transient Vector2D edge2A = new Vector2D();
    private final transient Vector2D edge2B = new Vector2D();
    private final transient int[] range1 = new int[2];
    private final transient int[] range2 = new int[2];
    private final transient int[] updatedIndicesInBinaryElimination = new int[4];
    private final transient LineSegment2D p = new LineSegment2D();
    private final transient LineSegment2D edge1 = new LineSegment2D();
    private final transient LineSegment2D edge2 = new LineSegment2D();
    private final transient Point2D proj1AOnto2 = new Point2D();
    private final transient Point2D proj1BOnto2 = new Point2D();
    private final transient Point2D proj2AOnto1 = new Point2D();
    private final transient Point2D proj2BOnto1 = new Point2D();
    private final transient Point2D[][] possiblePointPairsWithProj = new Point2D[][]{{new Point2D(), new Point2D()}, {new Point2D(), new Point2D()}, {new Point2D(), new Point2D()}, {new Point2D(), new Point2D()}};
    private final transient Point2D[][] possiblePointPairsWithoutProj = new Point2D[][]{{new Point2D(), new Point2D()}, {new Point2D(), new Point2D()}, {new Point2D(), new Point2D()}, {new Point2D(), new Point2D()}};
    private final transient double[] possibleDistancesWithProj = new double[4];
    private final transient double[] possibleDistancesWithoutProj = new double[4];
    private final transient boolean[] possiblePointPairsWithProjValid = new boolean[4];
    private final transient LineSegment2D pFinalPhasePoint = new LineSegment2D();
    private final transient ConvexPolygon2D intersectionToThrowAway = new ConvexPolygon2D();

    public static boolean findConnectingEdgesVerticesIndexes(ConvexPolygon2DReadOnly polygon1, ConvexPolygon2DReadOnly polygon2, int[][] verticesIndices) {
        boolean success = false;
        if (polygon1.isEmpty() || polygon2.isEmpty()) {
            return false;
        }
        if (polygon1.getNumberOfVertices() == 1 && polygon2.getNumberOfVertices() == 1) {
            verticesIndices[0][0] = 0;
            verticesIndices[0][1] = 0;
            verticesIndices[1][0] = 0;
            verticesIndices[1][1] = 0;
            return true;
        }
        if (polygon1.getNumberOfVertices() == 1) {
            verticesIndices[0][0] = 0;
            verticesIndices[0][1] = 0;
            int lineOfSightStartIndex = polygon2.lineOfSightStartIndex(polygon1.getVertex(0));
            int lineOfSightEndIndex = polygon2.lineOfSightEndIndex(polygon1.getVertex(0));
            success = lineOfSightStartIndex > -1 && lineOfSightEndIndex > -1;
            verticesIndices[1][0] = lineOfSightStartIndex;
            verticesIndices[1][1] = lineOfSightStartIndex;
            return success;
        }
        if (polygon2.getNumberOfVertices() == 1) {
            verticesIndices[1][0] = 0;
            verticesIndices[1][1] = 0;
            int lineOfSightStartIndex = polygon1.lineOfSightStartIndex(polygon2.getVertex(0));
            int lineOfSightEndIndex = polygon1.lineOfSightEndIndex(polygon2.getVertex(0));
            success = lineOfSightStartIndex > -1 && lineOfSightEndIndex > -1;
            verticesIndices[0][0] = lineOfSightStartIndex;
            verticesIndices[0][1] = lineOfSightStartIndex;
            return success;
        }
        Point2DReadOnly vertex = polygon1.getVertex(0);
        int lineOfSight1StartIndex = polygon2.lineOfSightStartIndex(vertex);
        if (lineOfSight1StartIndex == -1) {
            return false;
        }
        int lineOfSight1EndIndex = polygon2.lineOfSightEndIndex(vertex);
        if (lineOfSight1EndIndex == -1) {
            return false;
        }
        int L2 = lineOfSight1StartIndex;
        int R2 = lineOfSight1EndIndex;
        lineOfSight1StartIndex = polygon1.lineOfSightStartIndex(polygon2.getVertex(R2));
        if (lineOfSight1StartIndex == -1) {
            return false;
        }
        lineOfSight1EndIndex = polygon1.lineOfSightEndIndex(polygon2.getVertex(R2));
        if (lineOfSight1EndIndex == -1) {
            return false;
        }
        int lineOfSight2StartIndex = polygon1.lineOfSightStartIndex(polygon2.getVertex(L2));
        if (lineOfSight2StartIndex == -1) {
            return false;
        }
        int lineOfSight2EndIndex = polygon1.lineOfSightEndIndex(polygon2.getVertex(L2));
        if (lineOfSight2EndIndex == -1) {
            return false;
        }
        int L1 = lineOfSight1StartIndex;
        int R1 = lineOfSight2EndIndex;
        boolean done = false;
        while (!done) {
            lineOfSight1EndIndex = polygon2.lineOfSightEndIndex(polygon1.getVertex(L1));
            if (lineOfSight1EndIndex == -1) {
                return false;
            }
            lineOfSight2StartIndex = polygon2.lineOfSightStartIndex(polygon1.getVertex(R1));
            if (lineOfSight2StartIndex == -1) {
                return false;
            }
            if (L2 == lineOfSight2StartIndex && R2 == lineOfSight1EndIndex) {
                done = true;
                break;
            }
            L2 = lineOfSight2StartIndex;
            R2 = lineOfSight1EndIndex;
            lineOfSight1EndIndex = polygon1.lineOfSightEndIndex(polygon2.getVertex(L2));
            if (lineOfSight1EndIndex == -1) {
                return false;
            }
            lineOfSight2StartIndex = polygon1.lineOfSightStartIndex(polygon2.getVertex(R2));
            if (lineOfSight2StartIndex == -1) {
                return false;
            }
            if (L1 == lineOfSight2StartIndex && R1 == lineOfSight1EndIndex) {
                done = true;
                break;
            }
            L1 = lineOfSight2StartIndex;
            R1 = lineOfSight1EndIndex;
        }
        verticesIndices[0][0] = L1;
        verticesIndices[0][1] = R1;
        verticesIndices[1][0] = R2;
        verticesIndices[1][1] = L2;
        return true;
    }

    public boolean combineDisjointPolygons(ConvexPolygon2DReadOnly polygon1, ConvexPolygon2DReadOnly polygon2, ConvexPolygon2DBasics combinedPolygonToPack, LineSegment2DBasics connectingEdge1ToPack, LineSegment2DBasics connectingEdge2Topack) {
        boolean success = ConvexPolygonTools.findConnectingEdgesVerticesIndexes(polygon1, polygon2, this.verticesIndices);
        if (!success) {
            return false;
        }
        combinedPolygonToPack.clear();
        polygon1.getVerticesInClockwiseOrder(this.verticesIndices[0][1], this.verticesIndices[0][0], combinedPolygonToPack);
        polygon2.getVerticesInClockwiseOrder(this.verticesIndices[1][0], this.verticesIndices[1][1], combinedPolygonToPack);
        combinedPolygonToPack.update();
        ConvexPolygonTools.getConnectingEdges(polygon1, polygon2, connectingEdge1ToPack, connectingEdge2Topack, this.verticesIndices);
        return true;
    }

    public boolean findConnectingEdges(ConvexPolygon2DReadOnly polygon1, ConvexPolygon2DReadOnly polygon2, LineSegment2DBasics connectingEdge1ToPack, LineSegment2DBasics connectingEdge2Topack) {
        boolean success = ConvexPolygonTools.findConnectingEdgesVerticesIndexes(polygon1, polygon2, this.verticesIndices);
        if (!success) {
            return false;
        }
        ConvexPolygonTools.getConnectingEdges(polygon1, polygon2, connectingEdge1ToPack, connectingEdge2Topack, this.verticesIndices);
        return true;
    }

    protected static void getConnectingEdges(ConvexPolygon2DReadOnly polygon1, ConvexPolygon2DReadOnly polygon2, LineSegment2DBasics connectingEdge1ToPack, LineSegment2DBasics connectingEdge2ToPack, int[][] verticesIndices) {
        connectingEdge1ToPack.set(polygon1.getVertex(verticesIndices[0][0]), polygon2.getVertex(verticesIndices[1][0]));
        connectingEdge2ToPack.set(polygon2.getVertex(verticesIndices[1][1]), polygon1.getVertex(verticesIndices[0][1]));
    }

    public double distanceBetweenTwoConvexPolygon2Ds(ConvexPolygon2DReadOnly polygonA, ConvexPolygon2DReadOnly polygonB) {
        if (this.doPolygonsIntersect(polygonA, polygonB)) {
            return 0.0;
        }
        double minDistance = Double.POSITIVE_INFINITY;
        for (int indexA = 0; indexA < polygonA.getNumberOfVertices(); ++indexA) {
            for (int indexB = 0; indexB < polygonB.getNumberOfVertices(); ++indexB) {
                double distance = EuclidCoreMissingTools.distanceBetweenTwoLineSegment2Ds(polygonA.getVertex(indexA), polygonA.getNextVertex(indexA), polygonB.getVertex(indexB), polygonB.getNextVertex(indexB));
                minDistance = Math.min(minDistance, distance);
            }
        }
        return minDistance;
    }

    public boolean computeIntersectionOfPolygons(ConvexPolygon2DReadOnly polygonP, ConvexPolygon2DReadOnly polygonQ, ConvexPolygon2DBasics intersectingPolygonToPack) {
        boolean isOnLeft;
        int currentQPolygonPointIndex;
        int currentPPolygonPointIndex;
        if (polygonP == null || polygonP.isEmpty()) {
            return false;
        }
        if (polygonQ == null || polygonQ.isEmpty()) {
            return false;
        }
        if (polygonP.getNumberOfVertices() == 2 && polygonQ.getNumberOfVertices() >= 2) {
            return this.computeIntersectionOfPolygonsIfOnePolygonHasExactlyTwoVerticesAndTheOtherHasAtLeastTwoVertices(polygonP, polygonQ, intersectingPolygonToPack);
        }
        if (polygonQ.getNumberOfVertices() == 2) {
            return this.computeIntersectionOfPolygonsIfOnePolygonHasExactlyTwoVerticesAndTheOtherHasAtLeastTwoVertices(polygonQ, polygonP, intersectingPolygonToPack);
        }
        if (polygonP.getNumberOfVertices() == 1 && !polygonQ.isEmpty()) {
            return ConvexPolygonTools.computeIntersectionOfPolygonsIfOnePolygonHasExactlyOneVertex(polygonP, polygonQ, intersectingPolygonToPack);
        }
        if (polygonQ.getNumberOfVertices() == 1) {
            return ConvexPolygonTools.computeIntersectionOfPolygonsIfOnePolygonHasExactlyOneVertex(polygonQ, polygonP, intersectingPolygonToPack);
        }
        int initialPolygonPIndex = currentPPolygonPointIndex = EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)polygonP, (boolean)true, (Bound)Bound.MIN, (Bound)Bound.MIN);
        Point2DReadOnly currentPolygonPPoint = polygonP.getVertex(currentPPolygonPointIndex);
        int initialPolygonQIndex = currentQPolygonPointIndex = EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)polygonQ, (boolean)true, (Bound)Bound.MIN, (Bound)Bound.MIN);
        Point2DReadOnly currentPolygonQPoint = polygonQ.getVertex(currentQPolygonPointIndex);
        this.caliperForPolygonP.set(0.0, 1.0);
        this.caliperForPolygonQ.set(0.0, 1.0);
        this.lineStart.set((Tuple2DReadOnly)currentPolygonPPoint);
        this.lineEnd.set((Tuple2DReadOnly)currentPolygonPPoint);
        this.lineEnd.add((Tuple2DReadOnly)this.caliperForPolygonP);
        boolean wasOnLeft = isOnLeft = EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)currentPolygonQPoint, (Point2DReadOnly)this.lineStart, (Point2DReadOnly)this.lineEnd);
        boolean gotAroundPOnce = false;
        boolean gotAroundQOnce = false;
        boolean DONE = false;
        int bridgeCount = 0;
        this.bridgeIndicesP.reset();
        this.bridgeIndicesQ.reset();
        this.bridgeWasOnLeft.reset();
        do {
            if (gotAroundPOnce && gotAroundQOnce) {
                DONE = true;
            }
            this.vectorToNextPointOnPolygonP.set((Tuple2DReadOnly)polygonP.getNextVertex(currentPPolygonPointIndex));
            this.vectorToNextPointOnPolygonP.sub((Tuple2DReadOnly)polygonP.getVertex(currentPPolygonPointIndex));
            this.vectorToNextPointOnPolygonP.normalize();
            double dotProductToNextPointOnPolygonP = this.caliperForPolygonP.dot((Tuple2DReadOnly)this.vectorToNextPointOnPolygonP);
            this.vectorToNextPointOnPolygonQ.set((Tuple2DReadOnly)polygonQ.getNextVertex(currentQPolygonPointIndex));
            this.vectorToNextPointOnPolygonQ.sub((Tuple2DReadOnly)polygonQ.getVertex(currentQPolygonPointIndex));
            this.vectorToNextPointOnPolygonQ.normalize();
            double dotProductToNextPointOnPolygonQ = this.caliperForPolygonQ.dot((Tuple2DReadOnly)this.vectorToNextPointOnPolygonQ);
            boolean moveCaliperP = false;
            boolean moveCaliperQ = false;
            if (dotProductToNextPointOnPolygonP == dotProductToNextPointOnPolygonQ) {
                this.caliperForPolygonP.set(this.vectorToNextPointOnPolygonP);
                this.caliperForPolygonQ.set(this.caliperForPolygonP);
                moveCaliperP = true;
                moveCaliperQ = true;
            } else if (dotProductToNextPointOnPolygonP > dotProductToNextPointOnPolygonQ) {
                this.caliperForPolygonP.set(this.vectorToNextPointOnPolygonP);
                this.caliperForPolygonQ.set(this.caliperForPolygonP);
                moveCaliperP = true;
            } else {
                this.caliperForPolygonQ.set(this.vectorToNextPointOnPolygonQ);
                this.caliperForPolygonP.set(this.caliperForPolygonQ);
                moveCaliperQ = true;
            }
            this.lineStart.set((Tuple2DReadOnly)currentPolygonPPoint);
            this.lineEnd.set((Tuple2DReadOnly)currentPolygonPPoint);
            this.lineEnd.add((Tuple2DReadOnly)this.caliperForPolygonP);
            isOnLeft = EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)currentPolygonQPoint, (Point2DReadOnly)this.lineStart, (Point2DReadOnly)this.lineEnd);
            if (wasOnLeft != isOnLeft) {
                boolean addThisOne = true;
                if (DONE && !this.bridgeIndicesP.isEmpty() && this.bridgeIndicesP.get(0) == currentPPolygonPointIndex && this.bridgeIndicesQ.get(0) == currentQPolygonPointIndex) {
                    addThisOne = false;
                }
                if (addThisOne) {
                    this.bridgeIndicesP.add(currentPPolygonPointIndex);
                    this.bridgeIndicesQ.add(currentQPolygonPointIndex);
                    this.bridgeWasOnLeft.add(wasOnLeft ? 1 : 0);
                    ++bridgeCount;
                    wasOnLeft = isOnLeft;
                }
            }
            if (moveCaliperP) {
                currentPPolygonPointIndex = polygonP.getNextVertexIndex(currentPPolygonPointIndex);
                currentPolygonPPoint = polygonP.getVertex(currentPPolygonPointIndex);
                if (currentPPolygonPointIndex == initialPolygonPIndex % polygonP.getNumberOfVertices()) {
                    gotAroundPOnce = true;
                }
            }
            if (!moveCaliperQ) continue;
            currentQPolygonPointIndex = polygonQ.getNextVertexIndex(currentQPolygonPointIndex);
            currentPolygonQPoint = polygonQ.getVertex(currentQPolygonPointIndex);
            if (currentQPolygonPointIndex != initialPolygonQIndex % polygonQ.getNumberOfVertices()) continue;
            gotAroundQOnce = true;
        } while (!DONE);
        if (bridgeCount == 0) {
            if (intersectingPolygonToPack == null) {
                return true;
            }
            if (polygonP.isPointInside(polygonQ.getVertex(0))) {
                intersectingPolygonToPack.set((Vertex2DSupplier)polygonQ);
            }
            if (polygonQ.isPointInside(polygonP.getVertex(0))) {
                intersectingPolygonToPack.set((Vertex2DSupplier)polygonP);
            }
        } else {
            boolean success = this.buildCommonPolygonFromBridges(this.bridgeIndicesP, this.bridgeIndicesQ, this.bridgeWasOnLeft, polygonP, polygonQ, intersectingPolygonToPack);
            if (!success) {
                if (intersectingPolygonToPack != null) {
                    intersectingPolygonToPack.clearAndUpdate();
                }
                return false;
            }
        }
        return true;
    }

    public boolean doPolygonsIntersect(ConvexPolygon2DReadOnly polygonP, ConvexPolygon2DReadOnly polygonQ) {
        boolean isOnLeft;
        int currentQPolygonPointIndex;
        int currentPPolygonPointIndex;
        if (polygonP == null || polygonP.isEmpty()) {
            return false;
        }
        if (polygonQ == null || polygonQ.isEmpty()) {
            return false;
        }
        if (polygonP.getNumberOfVertices() == 2 && polygonQ.getNumberOfVertices() >= 2) {
            return ConvexPolygonTools.computeIfPolygonsIntersectIfOnePolygonHasExactlyTwoVerticesAndTheOtherHasAtLeastTwoVertices(polygonP, polygonQ);
        }
        if (polygonQ.getNumberOfVertices() == 2) {
            return ConvexPolygonTools.computeIfPolygonsIntersectIfOnePolygonHasExactlyTwoVerticesAndTheOtherHasAtLeastTwoVertices(polygonQ, polygonP);
        }
        if (polygonP.getNumberOfVertices() == 1 && !polygonQ.isEmpty() || polygonQ.getNumberOfVertices() == 1) {
            return false;
        }
        int initialPolygonPIndex = currentPPolygonPointIndex = EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)polygonP, (boolean)true, (Bound)Bound.MIN, (Bound)Bound.MIN);
        Point2DReadOnly currentPolygonPPoint = polygonP.getVertex(currentPPolygonPointIndex);
        int initialPolygonQIndex = currentQPolygonPointIndex = EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)polygonQ, (boolean)true, (Bound)Bound.MIN, (Bound)Bound.MIN);
        Point2DReadOnly currentPolygonQPoint = polygonQ.getVertex(currentQPolygonPointIndex);
        this.caliperForPolygonP.set(0.0, 1.0);
        this.caliperForPolygonQ.set(0.0, 1.0);
        this.lineStart.set((Tuple2DReadOnly)currentPolygonPPoint);
        this.lineEnd.set((Tuple2DReadOnly)currentPolygonPPoint);
        this.lineEnd.add((Tuple2DReadOnly)this.caliperForPolygonP);
        boolean wasOnLeft = isOnLeft = EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)currentPolygonQPoint, (Point2DReadOnly)this.lineStart, (Point2DReadOnly)this.lineEnd);
        boolean gotAroundPOnce = false;
        boolean gotAroundQOnce = false;
        boolean DONE = false;
        int bridgeCount = 0;
        this.bridgeIndicesP.reset();
        this.bridgeIndicesQ.reset();
        this.bridgeWasOnLeft.reset();
        do {
            if (gotAroundPOnce && gotAroundQOnce) {
                DONE = true;
            }
            this.vectorToNextPointOnPolygonP.set((Tuple2DReadOnly)polygonP.getNextVertex(currentPPolygonPointIndex));
            this.vectorToNextPointOnPolygonP.sub((Tuple2DReadOnly)polygonP.getVertex(currentPPolygonPointIndex));
            this.vectorToNextPointOnPolygonP.normalize();
            double dotProductToNextPointOnPolygonP = this.caliperForPolygonP.dot((Tuple2DReadOnly)this.vectorToNextPointOnPolygonP);
            this.vectorToNextPointOnPolygonQ.set((Tuple2DReadOnly)polygonQ.getNextVertex(currentQPolygonPointIndex));
            this.vectorToNextPointOnPolygonQ.sub((Tuple2DReadOnly)polygonQ.getVertex(currentQPolygonPointIndex));
            this.vectorToNextPointOnPolygonQ.normalize();
            double dotProductToNextPointOnPolygonQ = this.caliperForPolygonQ.dot((Tuple2DReadOnly)this.vectorToNextPointOnPolygonQ);
            boolean moveCaliperP = false;
            boolean moveCaliperQ = false;
            if (dotProductToNextPointOnPolygonP == dotProductToNextPointOnPolygonQ) {
                this.caliperForPolygonP.set(this.vectorToNextPointOnPolygonP);
                this.caliperForPolygonQ.set(this.caliperForPolygonP);
                moveCaliperP = true;
                moveCaliperQ = true;
            } else if (dotProductToNextPointOnPolygonP > dotProductToNextPointOnPolygonQ) {
                this.caliperForPolygonP.set(this.vectorToNextPointOnPolygonP);
                this.caliperForPolygonQ.set(this.caliperForPolygonP);
                moveCaliperP = true;
            } else {
                this.caliperForPolygonQ.set(this.vectorToNextPointOnPolygonQ);
                this.caliperForPolygonP.set(this.caliperForPolygonQ);
                moveCaliperQ = true;
            }
            this.lineStart.set((Tuple2DReadOnly)currentPolygonPPoint);
            this.lineEnd.set((Tuple2DReadOnly)currentPolygonPPoint);
            this.lineEnd.add((Tuple2DReadOnly)this.caliperForPolygonP);
            isOnLeft = EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)currentPolygonQPoint, (Point2DReadOnly)this.lineStart, (Point2DReadOnly)this.lineEnd);
            if (wasOnLeft != isOnLeft) {
                boolean addThisOne = true;
                if (DONE && !this.bridgeIndicesP.isEmpty() && this.bridgeIndicesP.get(0) == currentPPolygonPointIndex && this.bridgeIndicesQ.get(0) == currentQPolygonPointIndex) {
                    addThisOne = false;
                }
                if (addThisOne) {
                    this.bridgeIndicesP.add(currentPPolygonPointIndex);
                    this.bridgeIndicesQ.add(currentQPolygonPointIndex);
                    this.bridgeWasOnLeft.add(wasOnLeft ? 1 : 0);
                    ++bridgeCount;
                    wasOnLeft = isOnLeft;
                }
            }
            if (moveCaliperP) {
                currentPPolygonPointIndex = polygonP.getNextVertexIndex(currentPPolygonPointIndex);
                currentPolygonPPoint = polygonP.getVertex(currentPPolygonPointIndex);
                if (currentPPolygonPointIndex == initialPolygonPIndex % polygonP.getNumberOfVertices()) {
                    gotAroundPOnce = true;
                }
            }
            if (!moveCaliperQ) continue;
            currentQPolygonPointIndex = polygonQ.getNextVertexIndex(currentQPolygonPointIndex);
            currentPolygonQPoint = polygonQ.getVertex(currentQPolygonPointIndex);
            if (currentQPolygonPointIndex != initialPolygonQIndex % polygonQ.getNumberOfVertices()) continue;
            gotAroundQOnce = true;
        } while (!DONE);
        if (bridgeCount == 0) {
            return true;
        }
        return this.doPolygonsIntersectFromBridges(this.bridgeIndicesP, this.bridgeIndicesQ, this.bridgeWasOnLeft, polygonP, polygonQ);
    }

    private static boolean computeIntersectionOfPolygonsIfOnePolygonHasExactlyOneVertex(ConvexPolygon2DReadOnly polygonWithExactlyOneVertex, ConvexPolygon2DReadOnly otherPolygon, ConvexPolygon2DBasics intersectingPolygon) {
        if (intersectingPolygon == null) {
            return false;
        }
        if (otherPolygon.pointIsOnPerimeter(polygonWithExactlyOneVertex.getVertex(0))) {
            intersectingPolygon.set((Vertex2DSupplier)polygonWithExactlyOneVertex);
            return false;
        }
        intersectingPolygon.clearAndUpdate();
        return false;
    }

    private boolean computeIntersectionOfPolygonsIfOnePolygonHasExactlyTwoVerticesAndTheOtherHasAtLeastTwoVertices(ConvexPolygon2DReadOnly polygonWithExactlyTwoVertices, ConvexPolygon2DReadOnly polygonWithAtLeastTwoVertices, ConvexPolygon2DBasics intersectingPolygon) {
        this.polygonWithTwoVerticesAsLineSegment.set(polygonWithExactlyTwoVertices.getVertex(0), polygonWithExactlyTwoVertices.getVertex(1));
        int intersections = polygonWithAtLeastTwoVertices.intersectionWith((LineSegment2DReadOnly)this.polygonWithTwoVerticesAsLineSegment, (Point2DBasics)this.intersection1, (Point2DBasics)this.intersection2);
        if (intersections == 0) {
            if (intersectingPolygon != null) {
                intersectingPolygon.clearAndUpdate();
            }
            return false;
        }
        if (intersections == 1) {
            if (intersectingPolygon != null) {
                intersectingPolygon.clear();
                intersectingPolygon.addVertex((Point2DReadOnly)this.intersection1);
                if (polygonWithAtLeastTwoVertices.isPointInside(polygonWithExactlyTwoVertices.getVertex(0))) {
                    intersectingPolygon.addVertex(polygonWithExactlyTwoVertices.getVertex(0));
                } else if (polygonWithAtLeastTwoVertices.isPointInside(polygonWithExactlyTwoVertices.getVertex(1))) {
                    intersectingPolygon.addVertex(polygonWithExactlyTwoVertices.getVertex(1));
                }
                intersectingPolygon.update();
            }
            return true;
        }
        if (intersectingPolygon != null) {
            intersectingPolygon.clear();
            intersectingPolygon.addVertex((Point2DReadOnly)this.intersection1);
            intersectingPolygon.addVertex((Point2DReadOnly)this.intersection2);
            intersectingPolygon.update();
        }
        return true;
    }

    private static boolean computeIfPolygonsIntersectIfOnePolygonHasExactlyTwoVerticesAndTheOtherHasAtLeastTwoVertices(ConvexPolygon2DReadOnly polygonWithExactlyTwoVertices, ConvexPolygon2DReadOnly polygonWithAtLeastTwoVertices) {
        return EuclidGeometryPolygonMissingTools.doLineSegment2DAndConvexPolygon2DIntersect(polygonWithExactlyTwoVertices.getVertex(0), polygonWithExactlyTwoVertices.getVertex(1), polygonWithAtLeastTwoVertices.getPolygonVerticesView(), polygonWithAtLeastTwoVertices.getNumberOfVertices());
    }

    private static boolean findCrossingIndices(boolean decrementP, int bridgeIndexForPolygonP, int bridgeIndexForPolygonQ, ConvexPolygon2DReadOnly polygonP, ConvexPolygon2DReadOnly polygonQ, TIntArrayList indicesToPack) {
        boolean finished;
        int incrementP = 1;
        int incrementQ = 1;
        if (decrementP) {
            incrementP = -1;
        } else {
            incrementQ = -1;
        }
        int indexPStart = bridgeIndexForPolygonP;
        int indexQStart = bridgeIndexForPolygonQ;
        int indexPEnd = (indexPStart + incrementP) % polygonP.getNumberOfVertices();
        int indexQEnd = (indexQStart + incrementQ) % polygonQ.getNumberOfVertices();
        if (indexPEnd < 0) {
            indexPEnd = polygonP.getNumberOfVertices() - 1;
        }
        if (indexQEnd < 0) {
            indexQEnd = polygonQ.getNumberOfVertices() - 1;
        }
        Point2DReadOnly linePStart = polygonP.getVertex(indexPStart);
        Point2DReadOnly linePEnd = polygonP.getVertex(indexPEnd);
        Point2DReadOnly lineQStart = polygonQ.getVertex(indexQStart);
        Point2DReadOnly lineQEnd = polygonQ.getVertex(indexQEnd);
        int initialPPolygonStartIndex = indexPStart;
        int initialQPolygonStartIndex = indexQStart;
        do {
            finished = true;
            while (decrementP ^ EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)lineQEnd, (Point2DReadOnly)linePStart, (Point2DReadOnly)linePEnd)) {
                lineQStart = lineQEnd;
                indexQStart = indexQEnd;
                if ((indexQEnd = (indexQEnd + incrementQ) % polygonQ.getNumberOfVertices()) < 0) {
                    indexQEnd = polygonQ.getNumberOfVertices() - 1;
                }
                lineQEnd = polygonQ.getVertex(indexQEnd);
                finished = false;
                if (indexQStart != initialQPolygonStartIndex) continue;
                return false;
            }
            while (!decrementP ^ EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)linePEnd, (Point2DReadOnly)lineQStart, (Point2DReadOnly)lineQEnd)) {
                linePStart = linePEnd;
                indexPStart = indexPEnd;
                if ((indexPEnd = (indexPEnd + incrementP) % polygonP.getNumberOfVertices()) < 0) {
                    indexPEnd = polygonP.getNumberOfVertices() - 1;
                }
                linePEnd = polygonP.getVertex(indexPEnd);
                finished = false;
                if (indexPStart != initialPPolygonStartIndex) continue;
                return false;
            }
        } while (!finished);
        indicesToPack.reset();
        indicesToPack.add(indexPStart);
        indicesToPack.add(indexPEnd);
        indicesToPack.add(indexQStart);
        indicesToPack.add(indexQEnd);
        return true;
    }

    protected boolean constructPolygonForIntersection(List<TIntArrayList> crossingIndices, ConvexPolygon2DReadOnly polygonP, ConvexPolygon2DReadOnly polygonQ, ConvexPolygon2DBasics intersectingPolygonToPack) {
        boolean incrementPNext;
        int startIndexP1 = crossingIndices.get(0).get(0);
        int endIndexP1 = crossingIndices.get(0).get(1);
        int startIndexQ1 = crossingIndices.get(0).get(2);
        int endIndexQ1 = crossingIndices.get(0).get(3);
        if ((startIndexP1 + 1) % polygonP.getNumberOfVertices() == endIndexP1) {
            incrementPNext = true;
        } else if ((startIndexQ1 + 1) % polygonQ.getNumberOfVertices() == endIndexQ1) {
            incrementPNext = false;
        } else {
            throw new RuntimeException("Neither P1, nor P2 increment!!!");
        }
        if (intersectingPolygonToPack != null) {
            intersectingPolygonToPack.clear();
        }
        for (int i = 0; i < crossingIndices.size(); ++i) {
            Point2DReadOnly endQ;
            Point2DReadOnly startQ;
            Point2DReadOnly endP;
            int startIndexP = crossingIndices.get(i).get(0);
            int endIndexP = crossingIndices.get(i).get(1);
            int startIndexQ = crossingIndices.get(i).get(2);
            int endIndexQ = crossingIndices.get(i).get(3);
            Point2DReadOnly startP = polygonP.getVertex(startIndexP);
            boolean success = EuclidCoreMissingTools.intersectionBetweenTwoLine2Ds(startP, endP = polygonP.getVertex(endIndexP), startQ = polygonQ.getVertex(startIndexQ), endQ = polygonQ.getVertex(endIndexQ), (Point2DBasics)this.intersection);
            if (!success) {
                if (intersectingPolygonToPack != null) {
                    intersectingPolygonToPack.clear();
                    intersectingPolygonToPack.update();
                }
                return false;
            }
            if (intersectingPolygonToPack != null) {
                intersectingPolygonToPack.addVertex((Point2DReadOnly)this.intersection);
            }
            if (incrementPNext) {
                int indexP = crossingIndices.get(i).get(1);
                int indexPNext = crossingIndices.get((i + 1) % crossingIndices.size()).get(0);
                while (indexP != indexPNext) {
                    if (intersectingPolygonToPack != null) {
                        intersectingPolygonToPack.addVertex(polygonP.getVertex(indexP));
                    }
                    indexP = polygonP.getNextVertexIndex(indexP);
                }
            } else {
                int indexQ = crossingIndices.get(i).get(3);
                int indexQNext = crossingIndices.get((i + 1) % crossingIndices.size()).get(2);
                while (indexQ != indexQNext) {
                    if (intersectingPolygonToPack != null) {
                        intersectingPolygonToPack.addVertex(polygonQ.getVertex(indexQ));
                    }
                    indexQ = polygonQ.getNextVertexIndex(indexQ);
                }
            }
            incrementPNext = !incrementPNext;
        }
        if (intersectingPolygonToPack != null) {
            intersectingPolygonToPack.update();
            if (intersectingPolygonToPack.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    private boolean buildCommonPolygonFromBridges(TIntArrayList bridgeIndicesP, TIntArrayList bridgeIndicesQ, TIntArrayList bridgeWasOnLeft, ConvexPolygon2DReadOnly polygonP, ConvexPolygon2DReadOnly polygonQ, ConvexPolygon2DBasics intersectingPolygonToPack) {
        this.crossingIndices.clear();
        for (int i = 0; i < bridgeIndicesP.size(); ++i) {
            int bridgeIndexForPolygonP = bridgeIndicesP.get(i);
            int bridgeIndexForPolygonQ = bridgeIndicesQ.get(i);
            TIntArrayList indices = (TIntArrayList)this.crossingIndices.add();
            boolean success = ConvexPolygonTools.findCrossingIndices(bridgeWasOnLeft.get(i) == 1, bridgeIndexForPolygonP, bridgeIndexForPolygonQ, polygonP, polygonQ, indices);
            if (success) continue;
            if (intersectingPolygonToPack != null) {
                intersectingPolygonToPack.clearAndUpdate();
            }
            return false;
        }
        return this.constructPolygonForIntersection((List<TIntArrayList>)this.crossingIndices, polygonP, polygonQ, intersectingPolygonToPack);
    }

    private boolean doPolygonsIntersectFromBridges(TIntArrayList bridgeIndicesP, TIntArrayList bridgeIndicesQ, TIntArrayList bridgeWasOnLeft, ConvexPolygon2DReadOnly polygonP, ConvexPolygon2DReadOnly polygonQ) {
        this.crossingIndices.clear();
        for (int i = 0; i < bridgeIndicesP.size(); ++i) {
            int bridgeIndexForPolygonP = bridgeIndicesP.get(i);
            int bridgeIndexForPolygonQ = bridgeIndicesQ.get(i);
            TIntArrayList indices = (TIntArrayList)this.crossingIndices.add();
            if (ConvexPolygonTools.findCrossingIndices(bridgeWasOnLeft.get(i) == 1, bridgeIndexForPolygonP, bridgeIndexForPolygonQ, polygonP, polygonQ, indices)) continue;
            return false;
        }
        return true;
    }

    public boolean shrinkInto(ConvexPolygon2DReadOnly polygonP, Point2DReadOnly referencePointInP, ConvexPolygon2DReadOnly polygonQ, ConvexPolygon2D polygonToPack) {
        if (!polygonQ.isEmpty() && polygonQ.getNumberOfVertices() < 3) {
            polygonToPack.set((Vertex2DSupplier)polygonQ);
            return true;
        }
        this.rays.clear();
        this.referencePointInPCopy.set((Tuple2DReadOnly)referencePointInP);
        int leftMostIndexOnPolygonQ = EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)polygonQ, (boolean)true, (Bound)Bound.MIN, (Bound)Bound.MIN);
        Point2DReadOnly vertexQ = polygonQ.getVertex(leftMostIndexOnPolygonQ);
        int nextVertexQIndex = polygonQ.getNextVertexIndex(leftMostIndexOnPolygonQ);
        Point2DReadOnly nextVertexQ = polygonQ.getVertex(nextVertexQIndex);
        int leftMostIndexOnPolygonP = EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)polygonP, (boolean)true, (Bound)Bound.MIN, (Bound)Bound.MIN);
        Point2DReadOnly vertexP = polygonP.getVertex(leftMostIndexOnPolygonP);
        int nextVertexPIndex = polygonP.getNextVertexIndex(leftMostIndexOnPolygonP);
        Point2DReadOnly nextVertexP = polygonP.getVertex(nextVertexPIndex);
        for (int i = 0; i < polygonQ.getNumberOfVertices(); ++i) {
            block4: {
                this.edgeOnQ.set(nextVertexQ.getX() - vertexQ.getX(), nextVertexQ.getY() - vertexQ.getY());
                for (int j = 0; j < polygonP.getNumberOfVertices(); ++j) {
                    this.edgeOnP.set(nextVertexP.getX() - vertexP.getX(), nextVertexP.getY() - vertexP.getY());
                    double crossProduct = this.edgeOnQ.getX() * this.edgeOnP.getY() - this.edgeOnP.getX() * this.edgeOnQ.getY();
                    if (!(crossProduct <= 0.0)) {
                        vertexP = nextVertexP;
                        nextVertexPIndex = polygonP.getNextVertexIndex(nextVertexPIndex);
                        nextVertexP = polygonP.getVertex(nextVertexPIndex);
                        continue;
                    }
                    break block4;
                }
                throw new RuntimeException("Should never get here!!");
            }
            this.referencePointInPCopy.setX(referencePointInP.getX() + vertexQ.getX() - vertexP.getX());
            this.referencePointInPCopy.setY(referencePointInP.getY() + vertexQ.getY() - vertexP.getY());
            ((Line2D)this.rays.add()).set((Point2DReadOnly)this.referencePointInPCopy, (Vector2DReadOnly)this.edgeOnQ);
            vertexQ = nextVertexQ;
            nextVertexQIndex = polygonQ.getNextVertexIndex(nextVertexQIndex);
            nextVertexQ = polygonQ.getVertex(nextVertexQIndex);
        }
        return this.convexPolygonConstructorFromInteriorOfRays.constructFromInteriorOfRays((List<Line2D>)this.rays, (ConvexPolygon2DBasics)polygonToPack);
    }

    public boolean combineDisjointPolygons(FrameConvexPolygon2DReadOnly polygon1, FrameConvexPolygon2DReadOnly polygon2, FrameConvexPolygon2DBasics combinedPolygonToPack, FrameLineSegment2DBasics connectingEdge1ToPack, FrameLineSegment2DBasics connectingEdge2ToPack) {
        combinedPolygonToPack.clear(polygon1.getReferenceFrame());
        combinedPolygonToPack.checkReferenceFrameMatch((ReferenceFrameHolder)connectingEdge1ToPack);
        combinedPolygonToPack.checkReferenceFrameMatch((ReferenceFrameHolder)connectingEdge2ToPack);
        boolean success = this.combineDisjointPolygons((ConvexPolygon2DReadOnly)polygon1, (ConvexPolygon2DReadOnly)polygon2, (ConvexPolygon2DBasics)combinedPolygonToPack, (LineSegment2DBasics)connectingEdge1ToPack, (LineSegment2DBasics)connectingEdge2ToPack);
        if (!success) {
            return false;
        }
        combinedPolygonToPack.update();
        return true;
    }

    public static ConvexPolygonCutResult cutPolygonToLeftOfLine(ConvexPolygon2DReadOnly polygonToCut, Line2DReadOnly cuttingLine, ConvexPolygon2DBasics croppedPolygonToPack) {
        return ConvexPolygonTools.cutPolygonToLeftOfLine(polygonToCut, cuttingLine, croppedPolygonToPack, (Point2DBasics)new Point2D(), (Point2DBasics)new Point2D());
    }

    public static ConvexPolygonCutResult cutPolygonToLeftOfLine(ConvexPolygon2DReadOnly polygonToCut, Line2DReadOnly cuttingLine, ConvexPolygon2DBasics croppedPolygonToPack, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        if (polygonToCut.isEmpty()) {
            croppedPolygonToPack.clearAndUpdate();
            return ConvexPolygonCutResult.REMOVE_ALL;
        }
        Vector2D upDirection = new Vector2D((Tuple2DReadOnly)cuttingLine.getDirection());
        upDirection.normalize();
        upDirection.set(-upDirection.getY(), upDirection.getX());
        int intersectionCount = EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D((Point2DReadOnly)cuttingLine.getPoint(), (Vector2DReadOnly)cuttingLine.getDirection(), (List)polygonToCut.getVertexBufferView(), (int)polygonToCut.getNumberOfVertices(), (boolean)polygonToCut.isClockwiseOrdered(), (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
        LogTools.trace((String)"Intersection count: {}", (Object)intersectionCount);
        boolean vertex0IsAbove = EuclidGeometryTools.isPoint2DInFrontOfRay2D((Point2DReadOnly)polygonToCut.getVertex(0), (Point2DReadOnly)cuttingLine.getPoint(), (Vector2DReadOnly)upDirection);
        if (intersectionCount == 0) {
            if (vertex0IsAbove) {
                croppedPolygonToPack.set((Vertex2DSupplier)polygonToCut);
                return ConvexPolygonCutResult.KEEP_ALL;
            }
            croppedPolygonToPack.clearAndUpdate();
            return ConvexPolygonCutResult.REMOVE_ALL;
        }
        if (intersectionCount == 1) {
            if (polygonToCut.getNumberOfVertices() > 1) {
                boolean isOnOrAboveTwo = EuclidGeometryTools.isPoint2DInFrontOfRay2D((Point2DReadOnly)polygonToCut.getVertex(1), (Point2DReadOnly)cuttingLine.getPoint(), (Vector2DReadOnly)upDirection);
                if (vertex0IsAbove && isOnOrAboveTwo) {
                    croppedPolygonToPack.set((Vertex2DSupplier)polygonToCut);
                    return ConvexPolygonCutResult.KEEP_ALL;
                }
                croppedPolygonToPack.clearAndUpdate();
                return ConvexPolygonCutResult.REMOVE_ALL;
            }
            croppedPolygonToPack.clearAndUpdate();
            return ConvexPolygonCutResult.REMOVE_ALL;
        }
        croppedPolygonToPack.clear();
        for (int i = 0; i < polygonToCut.getNumberOfVertices(); ++i) {
            croppedPolygonToPack.addVertex(polygonToCut.getVertex(i));
        }
        croppedPolygonToPack.update();
        ConvexPolygonTools.cutPolygonWithLinePrivate(cuttingLine, croppedPolygonToPack, RobotSide.LEFT.getOppositeSide(), firstIntersectionToPack, secondIntersectionToPack);
        return ConvexPolygonCutResult.CUT;
    }

    public int cutPolygonWithLine(Line2DReadOnly cuttingLine, ConvexPolygon2DBasics polygonToCut, RobotSide sideOfLineToCut) {
        return ConvexPolygonTools.cutPolygonWithLine(cuttingLine, polygonToCut, sideOfLineToCut, this.intersectionPoint1, this.intersectionPoint2);
    }

    public int cutPolygonWithLine(FrameLine2DReadOnly cuttingLine, FixedFrameConvexPolygon2DBasics polygonToCut, RobotSide sideOfLineToCut) {
        cuttingLine.checkReferenceFrameMatch((ReferenceFrameHolder)polygonToCut);
        return this.cutPolygonWithLine((Line2DReadOnly)cuttingLine, (ConvexPolygon2DBasics)polygonToCut, sideOfLineToCut);
    }

    public static int cutPolygonWithLine(FrameLine2DReadOnly cuttingLine, FixedFrameConvexPolygon2DBasics polygonToCut, FrameConvexPolygonWithLineIntersector2d lineIntersector2d, RobotSide sideOfLineToCut) {
        lineIntersector2d.intersectWithLine((FrameConvexPolygon2DReadOnly)polygonToCut, cuttingLine);
        if (lineIntersector2d.getIntersectionResult() == FrameConvexPolygonWithLineIntersector2d.IntersectionResult.NO_INTERSECTION || lineIntersector2d.getIntersectionResult() == FrameConvexPolygonWithLineIntersector2d.IntersectionResult.POINT_INTERSECTION) {
            return -1;
        }
        return ConvexPolygonTools.cutPolygonWithLinePrivate((Line2DReadOnly)cuttingLine, (ConvexPolygon2DBasics)polygonToCut, sideOfLineToCut, (Point2DBasics)lineIntersector2d.getIntersectionPointOne(), (Point2DBasics)lineIntersector2d.getIntersectionPointTwo());
    }

    public static int cutPolygonWithLine(Line2DReadOnly cuttingLine, ConvexPolygon2DBasics polygonToCut, RobotSide sideOfLineToCut, Point2D intersectionPoint1, Point2D intersectionPoint2) {
        int intersectionPoints = polygonToCut.intersectionWith(cuttingLine, (Point2DBasics)intersectionPoint1, (Point2DBasics)intersectionPoint2);
        if (intersectionPoints < 2) {
            return -1;
        }
        return ConvexPolygonTools.cutPolygonWithLinePrivate(cuttingLine, polygonToCut, sideOfLineToCut, (Point2DBasics)intersectionPoint1, (Point2DBasics)intersectionPoint2);
    }

    private static int cutPolygonWithLinePrivate(Line2DReadOnly cuttingLine, ConvexPolygon2DBasics polygonToCut, RobotSide sideOfLineToCut, Point2DBasics intersectionPoint1, Point2DBasics intersectionPoint2) {
        int numberOfVerticesRemoved = 0;
        int index = 0;
        while (index < polygonToCut.getNumberOfVertices()) {
            Point2DReadOnly vertex = polygonToCut.getVertex(index);
            if (cuttingLine.isPointOnSideOfLine(vertex, sideOfLineToCut == RobotSide.LEFT)) {
                polygonToCut.removeVertex(index);
                polygonToCut.update();
                ++numberOfVerticesRemoved;
                continue;
            }
            ++index;
        }
        polygonToCut.addVertex((Point2DReadOnly)intersectionPoint1);
        polygonToCut.addVertex((Point2DReadOnly)intersectionPoint2);
        polygonToCut.update();
        return numberOfVerticesRemoved;
    }

    public static void limitVerticesConservative(ConvexPolygon2DBasics polygon, int desiredVertices) {
        polygon.checkNonEmpty();
        if (desiredVertices == 0) {
            polygon.clear();
            polygon.update();
            return;
        }
        int vertices = polygon.getNumberOfVertices();
        while (vertices > desiredVertices) {
            int removeVertex = -1;
            double leastAreaLost = Double.POSITIVE_INFINITY;
            for (int i = 0; i < vertices; ++i) {
                Point2DReadOnly nextVertex;
                Point2DReadOnly vertex;
                Point2DReadOnly previousVertex = polygon.getPreviousVertex(i);
                double areaLostWithoutVertex = EuclidGeometryTools.triangleArea((Point2DReadOnly)previousVertex, (Point2DReadOnly)(vertex = polygon.getVertex(i)), (Point2DReadOnly)(nextVertex = polygon.getNextVertex(i)));
                if (!(areaLostWithoutVertex < leastAreaLost)) continue;
                leastAreaLost = areaLostWithoutVertex;
                removeVertex = i;
            }
            polygon.removeVertex(removeVertex);
            polygon.update();
            vertices = polygon.getNumberOfVertices();
        }
        int numberOfFailedIterations = 0;
        while (vertices < desiredVertices) {
            int index = -1;
            double longestEdgeLength = Double.NEGATIVE_INFINITY;
            Point2DReadOnly lastVertex = polygon.getVertex(0);
            for (int i = 1; i < vertices + 1; ++i) {
                Point2DReadOnly nextVertex = null;
                nextVertex = i == vertices ? polygon.getVertex(0) : polygon.getVertex(i);
                double edgeLength = lastVertex.distance(nextVertex);
                if (edgeLength > longestEdgeLength) {
                    longestEdgeLength = edgeLength;
                    index = i;
                }
                lastVertex = nextVertex;
            }
            int idx1 = -1;
            int idx2 = -1;
            if (index == vertices) {
                idx1 = vertices - 1;
                idx2 = 0;
            } else {
                idx1 = index - 1;
                idx2 = index;
            }
            Point2DReadOnly vertexA = polygon.getVertex(idx1);
            Point2DReadOnly vertexB = polygon.getVertex(idx2);
            double xNew = (vertexA.getX() + vertexB.getX()) / 2.0;
            double yNew = (vertexA.getY() + vertexB.getY()) / 2.0;
            double dx = -(vertexB.getY() - vertexA.getY());
            double dy = vertexB.getX() - vertexA.getX();
            double length = Math.sqrt(EuclidCoreTools.normSquared((double)dx, (double)dy));
            double scale = 1.0E-7 / length;
            polygon.addVertex(xNew += dx * scale, yNew += dy * scale);
            polygon.update();
            int verticesPreviousValue = vertices;
            vertices = polygon.getNumberOfVertices();
            numberOfFailedIterations = vertices == verticesPreviousValue ? ++numberOfFailedIterations : 0;
            if (numberOfFailedIterations < 5) continue;
            LogTools.warn((String)"Not able to increase number of polygon vertices.");
            break;
        }
    }

    public static void limitVerticesConservative(FixedFrameConvexPolygon2DBasics polygon, int desiredVertices) {
        ConvexPolygonTools.limitVerticesConservative((ConvexPolygon2DBasics)polygon, desiredVertices);
    }

    public void computeMinimumDistancePoints(ConvexPolygon2DReadOnly polygon1, ConvexPolygon2DReadOnly polygon2, double epsilon, Point2DBasics point1ToPack, Point2DBasics point2ToPack) {
        if (this.computeIntersectionOfPolygons(polygon1, polygon2, (ConvexPolygon2DBasics)this.intersectingPolygonToPack)) {
            throw new RuntimeException("Cannot compute minimum distance between intersecting polygons.");
        }
        if (polygon1.getNumberOfVertices() < 3 || polygon2.getNumberOfVertices() < 3) {
            throw new RuntimeException("Polygon inputs are degenerate.");
        }
        this.findStartAndEndTangents(polygon2.getVertex(0), polygon1, epsilon, this.v1Tangents);
        this.findStartAndEndTangents(polygon1.getVertex(0), polygon2, epsilon, this.v2Tangents);
        int v1Start = this.v1Tangents[0];
        int v1End = this.v1Tangents[1];
        int v2Start = this.v2Tangents[0];
        int v2End = this.v2Tangents[1];
        this.binaryElimination(polygon1, polygon2, v1Start, v1End, v2Start, v2End, epsilon, this.updatedIndices);
        v1Start = this.updatedIndices[0];
        v1End = this.updatedIndices[1];
        v2Start = this.updatedIndices[2];
        v2End = this.updatedIndices[3];
        this.getClosestPointsFromRemainingEdgesAndVertices(polygon1, polygon2, v1Start, v1End, v2Start, v2End, point1ToPack, point2ToPack);
    }

    public void computeMinimumDistancePoints(ConvexPolygon2DReadOnly polygon1, ConvexPolygon2DReadOnly polygon2, Point2DBasics point1ToPack, Point2DBasics point2ToPack) {
        this.computeMinimumDistancePoints(polygon1, polygon2, 0.01, point1ToPack, point2ToPack);
    }

    private void findStartAndEndTangents(Point2DReadOnly point, ConvexPolygon2DReadOnly polygon, double epsilon, int[] tangetsToPack) {
        int vIndex = 0;
        while (!this.pointMakesTangentToPolygon(polygon, point, vIndex, epsilon)) {
            ++vIndex;
            vIndex %= polygon.getNumberOfVertices();
        }
        int tangentIndex1 = vIndex++;
        this.tangent1.set(polygon.getVertex(tangentIndex1).getX() - point.getX(), polygon.getVertex(tangentIndex1).getY() - point.getY());
        vIndex %= polygon.getNumberOfVertices();
        while (!this.pointMakesTangentToPolygon(polygon, point, vIndex, epsilon)) {
            ++vIndex;
            vIndex %= polygon.getNumberOfVertices();
        }
        int tangentIndex2 = vIndex;
        this.tangent2.set(polygon.getVertex(tangentIndex2).getX() - point.getX(), polygon.getVertex(tangentIndex2).getY() - point.getY());
        if (this.tangent1.angle((Vector2DReadOnly)this.tangent2) >= 0.0) {
            tangetsToPack[0] = tangentIndex1;
            tangetsToPack[1] = tangentIndex2;
        } else {
            tangetsToPack[0] = tangentIndex2;
            tangetsToPack[1] = tangentIndex1;
        }
    }

    private boolean pointMakesTangentToPolygon(ConvexPolygon2DReadOnly polygon, Point2DReadOnly point, int vertexIndex, double epsilon) {
        Point2DReadOnly vertex = polygon.getVertex(vertexIndex);
        Point2DReadOnly previous = polygon.getPreviousVertex(vertexIndex);
        Point2DReadOnly next = polygon.getNextVertex(vertexIndex);
        this.base.set(point.getX() - vertex.getX(), point.getY() - vertex.getY());
        this.first.set(previous.getX() - vertex.getX(), previous.getY() - vertex.getY());
        this.second.set(next.getX() - vertex.getX(), next.getY() - vertex.getY());
        double firstAngle = this.base.angle((Vector2DReadOnly)this.first);
        double secondAngle = this.base.angle((Vector2DReadOnly)this.second);
        if (firstAngle * secondAngle >= 0.0) {
            return true;
        }
        return MathTools.epsilonEquals((double)firstAngle, (double)0.0, (double)epsilon) || MathTools.epsilonEquals((double)secondAngle, (double)0.0, (double)epsilon);
    }

    private static boolean isInRange(int index, int low, int high) {
        if (low <= index && index <= high) {
            return true;
        }
        return high < low && (index >= low || index <= high);
    }

    private void binaryElimination(ConvexPolygon2DReadOnly polygon1, ConvexPolygon2DReadOnly polygon2, int v1Start, int v1End, int v2Start, int v2End, double epsilon, int[] indicesToPack) {
        int numberOfVertices1 = polygon1.getNumberOfVertices();
        int numberOfVertices2 = polygon2.getNumberOfVertices();
        while ((numberOfVertices1 + v1End - v1Start) % numberOfVertices1 + 1 > 2 || (numberOfVertices2 + v2End - v2Start) % numberOfVertices2 + 1 > 2) {
            int v1MedianIndex = v1Start <= v1End ? (v1End + v1Start + 1) / 2 : (v1End + v1Start + 1 + numberOfVertices1) / 2 % numberOfVertices1;
            int v2MedianIndex = v2Start <= v2End ? (v2End + v2Start) / 2 : (v2End + v2Start + numberOfVertices2) / 2 % numberOfVertices2;
            Point2DReadOnly v1Median = polygon1.getVertex(v1MedianIndex);
            Point2DReadOnly v2Median = polygon2.getVertex(v2MedianIndex);
            this.m.set(v2Median.getX() - v1Median.getX(), v2Median.getY() - v1Median.getY());
            this.mReversed.set(v1Median.getX() - v2Median.getX(), v1Median.getY() - v2Median.getY());
            int edge1AStart = (v1MedianIndex + numberOfVertices1 - 1) % numberOfVertices1;
            int edge1BEnd = (v1MedianIndex + 1) % numberOfVertices1;
            int edge2BStart = (v2MedianIndex + numberOfVertices2 - 1) % numberOfVertices2;
            int edge2AEnd = (v2MedianIndex + 1) % numberOfVertices2;
            this.edge1A.set(polygon1.getVertex(edge1AStart).getX() - v1Median.getX(), polygon1.getVertex(edge1AStart).getY() - v1Median.getY());
            this.edge1B.set(polygon1.getVertex(edge1BEnd).getX() - v1Median.getX(), polygon1.getVertex(edge1BEnd).getY() - v1Median.getY());
            this.edge2A.set(polygon2.getVertex(edge2AEnd).getX() - v2Median.getX(), polygon2.getVertex(edge2AEnd).getY() - v2Median.getY());
            this.edge2B.set(polygon2.getVertex(edge2BStart).getX() - v2Median.getX(), polygon2.getVertex(edge2BStart).getY() - v2Median.getY());
            double angle1A = this.m.angle((Vector2DReadOnly)this.edge1A);
            double angle1B = this.edge1B.angle((Vector2DReadOnly)this.m);
            double angle2A = this.edge2A.angle((Vector2DReadOnly)this.mReversed);
            double angle2B = this.mReversed.angle((Vector2DReadOnly)this.edge2B);
            this.findStartAndEndTangents(v2Median, polygon1, epsilon, this.range1);
            this.findStartAndEndTangents(v1Median, polygon2, epsilon, this.range2);
            angle1A = MathTools.epsilonEquals((double)angle1A, (double)0.0, (double)0.01) ? 0.0 : angle1A;
            angle1B = MathTools.epsilonEquals((double)angle1B, (double)0.0, (double)0.01) ? 0.0 : angle1B;
            angle2A = MathTools.epsilonEquals((double)angle2A, (double)0.0, (double)0.01) ? 0.0 : angle2A;
            angle2B = MathTools.epsilonEquals((double)angle2B, (double)0.0, (double)0.01) ? 0.0 : angle2B;
            angle1A += angle1A <= 0.0 && ConvexPolygonTools.isInRange(v1MedianIndex, this.range1[0], this.range1[1]) ? Math.PI * 2 : 0.0;
            angle1B += (angle1A += angle1A <= 0.0 && (angle1B += angle1B <= 0.0 && ConvexPolygonTools.isInRange(v1MedianIndex, this.range1[0], this.range1[1]) ? Math.PI * 2 : 0.0) <= 0.0 && angle1A < angle1B ? Math.PI * 2 : 0.0) <= 0.0 && angle1B <= 0.0 && angle1B < angle1A ? Math.PI * 2 : 0.0;
            angle2B += (angle2A += angle2A <= 0.0 && (angle2B += angle2B <= 0.0 && ConvexPolygonTools.isInRange(v2MedianIndex, this.range2[0], this.range2[1]) ? Math.PI * 2 : 0.0) <= 0.0 && (angle2A += angle2A <= 0.0 && ConvexPolygonTools.isInRange(v2MedianIndex, this.range2[0], this.range2[1]) ? Math.PI * 2 : 0.0) < angle2B ? Math.PI * 2 : 0.0) <= 0.0 && angle2B <= 0.0 && angle2B < angle2A ? Math.PI * 2 : 0.0;
            if (v1Start == v1End || v2Start == v2End) {
                ConvexPolygonTools.binaryEliminationCase1(angle1A, angle1B, angle2A, angle2B, v1Start, v1MedianIndex, v1End, v2Start, v2MedianIndex, v2End, polygon1, polygon2, this.updatedIndicesInBinaryElimination);
                v1Start = this.updatedIndicesInBinaryElimination[0];
                v1End = this.updatedIndicesInBinaryElimination[1];
                v2Start = this.updatedIndicesInBinaryElimination[2];
                v2End = this.updatedIndicesInBinaryElimination[3];
                continue;
            }
            if ((v1End - v1Start + numberOfVertices1) % numberOfVertices1 == 1) {
                this.binaryEliminationCase2(angle1A, angle1B, angle2A, angle2B, v1Start, v1MedianIndex, v1End, v2Start, v2MedianIndex, v2End, polygon1, polygon2, this.updatedIndicesInBinaryElimination);
                v1Start = this.updatedIndicesInBinaryElimination[0];
                v1End = this.updatedIndicesInBinaryElimination[1];
                v2Start = this.updatedIndicesInBinaryElimination[2];
                v2End = this.updatedIndicesInBinaryElimination[3];
                continue;
            }
            if ((v2End - v2Start + numberOfVertices2) % numberOfVertices2 == 1) {
                this.binaryEliminationCase2(angle2A, angle2B, angle1A, angle1B, v2End, v2MedianIndex, v2Start, v1End, v1MedianIndex, v1Start, polygon2, polygon1, this.updatedIndicesInBinaryElimination);
                v2End = this.updatedIndicesInBinaryElimination[0];
                v2Start = this.updatedIndicesInBinaryElimination[1];
                v1End = this.updatedIndicesInBinaryElimination[2];
                v1Start = this.updatedIndicesInBinaryElimination[3];
                continue;
            }
            ConvexPolygonTools.binaryEliminationCase3(angle1A, angle1B, angle2A, angle2B, v1Start, v1MedianIndex, v1End, v2Start, v2MedianIndex, v2End, this.updatedIndicesInBinaryElimination);
            v1Start = this.updatedIndicesInBinaryElimination[0];
            v1End = this.updatedIndicesInBinaryElimination[1];
            v2Start = this.updatedIndicesInBinaryElimination[2];
            v2End = this.updatedIndicesInBinaryElimination[3];
        }
        indicesToPack[0] = v1Start;
        indicesToPack[1] = v1End;
        indicesToPack[2] = v2Start;
        indicesToPack[3] = v2End;
    }

    private static void binaryEliminationCase1(double angle1A, double angle1B, double angle2A, double angle2B, int v1Start, int v1MedianIndex, int v1End, int v2Start, int v2MedianIndex, int v2End, ConvexPolygon2DReadOnly polygon1, ConvexPolygon2DReadOnly polygon2, int[] updatedIndices) {
        if (v1Start == v1End) {
            if (angle2A >= 1.5707963267948966) {
                v2End = v2MedianIndex;
            }
            if (angle2B >= 1.5707963267948966) {
                v2Start = v2MedianIndex;
            }
        } else if (v2Start == v2End) {
            if (angle1A >= 1.5707963267948966) {
                v1Start = v1MedianIndex;
            }
            if (angle1B >= 1.5707963267948966) {
                v1End = v1MedianIndex;
            }
        }
        updatedIndices[0] = v1Start;
        updatedIndices[1] = v1End;
        updatedIndices[2] = v2Start;
        updatedIndices[3] = v2End;
    }

    private void binaryEliminationCase2(double angle1A, double angle1B, double angle2A, double angle2B, int v1Start, int v1MedianIndex, int v1End, int v2Start, int v2MedianIndex, int v2End, ConvexPolygon2DReadOnly polygon1, ConvexPolygon2DReadOnly polygon2, int[] updatedIndices) {
        if (angle1A > 0.0) {
            if (angle1A + angle2A >= Math.PI) {
                if (angle1A >= 1.5707963267948966) {
                    v1Start = v1End;
                }
                if (angle2A >= 1.5707963267948966) {
                    v2End = v2MedianIndex;
                }
            }
            if (angle2B >= 1.5707963267948966) {
                v2Start = v2MedianIndex;
            }
            if (angle1A < angle2B && angle2B < 1.5707963267948966) {
                Point2D proj = EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)polygon2.getVertex(v2MedianIndex), (Point2DReadOnly)polygon1.getVertex(v1Start), (Point2DReadOnly)polygon1.getVertex(v1End));
                this.p.set(polygon1.getVertex(v1Start), polygon1.getVertex(v1End));
                if (this.p.isBetweenEndpoints((Point2DReadOnly)proj, 0.0)) {
                    v2Start = v2MedianIndex;
                } else {
                    v1End = v1Start;
                }
            }
        } else {
            v1End = v1Start;
            if (angle2A >= Math.PI) {
                v2End = v2MedianIndex;
            }
            if (angle2B >= Math.PI) {
                v2Start = v2MedianIndex;
            }
        }
        updatedIndices[0] = v1Start;
        updatedIndices[1] = v1End;
        updatedIndices[2] = v2Start;
        updatedIndices[3] = v2End;
    }

    private static void binaryEliminationCase3(double angle1A, double angle1B, double angle2A, double angle2B, int v1Start, int v1MedianIndex, int v1End, int v2Start, int v2MedianIndex, int v2End, int[] updatedIndices) {
        if (angle1A > 0.0 && angle1B > 0.0 && angle2A > 0.0 && angle2B > 0.0) {
            if (angle1A + angle2A > Math.PI) {
                if (angle1A >= 1.5707963267948966) {
                    v1Start = v1MedianIndex;
                }
                if (angle2A >= 1.5707963267948966) {
                    v2End = v2MedianIndex;
                }
            }
            if (angle1B + angle2B > Math.PI) {
                if (angle1B >= 1.5707963267948966) {
                    v1End = v1MedianIndex;
                }
                if (angle2B >= 1.5707963267948966) {
                    v2Start = v2MedianIndex;
                }
            }
        }
        if (angle1A <= 0.0) {
            v1End = v1MedianIndex;
        }
        if (angle1B <= 0.0) {
            v1Start = v1MedianIndex;
        }
        if (angle2A <= 0.0) {
            v2Start = v2MedianIndex;
        }
        if (angle2B <= 0.0) {
            v2End = v2MedianIndex;
        }
        updatedIndices[0] = v1Start;
        updatedIndices[1] = v1End;
        updatedIndices[2] = v2Start;
        updatedIndices[3] = v2End;
    }

    private void getClosestPointsFromRemainingEdgesAndVertices(ConvexPolygon2DReadOnly polygon1, ConvexPolygon2DReadOnly polygon2, int v1Start, int v1End, int v2Start, int v2End, Point2DBasics point1ToPack, Point2DBasics point2ToPack) {
        if (v1Start == v1End && v2Start == v2End) {
            point1ToPack.set((Tuple2DReadOnly)polygon1.getVertex(v1Start));
            point2ToPack.set((Tuple2DReadOnly)polygon2.getVertex(v2Start));
        } else if (v1Start == v1End) {
            this.finalPhasePointAndEdge(polygon2.getVertex(v2Start), polygon2.getVertex(v2End), polygon1.getVertex(v1Start), point1ToPack, point2ToPack);
        } else if (v2Start == v2End) {
            this.finalPhasePointAndEdge(polygon1.getVertex(v1Start), polygon1.getVertex(v1End), polygon2.getVertex(v2Start), point2ToPack, point1ToPack);
        } else {
            this.finalPhaseTwoEdges(polygon1.getVertex(v1Start), polygon1.getVertex(v1End), polygon2.getVertex(v2Start), polygon2.getVertex(v2End), point1ToPack, point2ToPack);
        }
    }

    private void finalPhaseTwoEdges(Point2DReadOnly edgePoint1A, Point2DReadOnly edgePoint1B, Point2DReadOnly edgePoint2A, Point2DReadOnly edgePoint2B, Point2DBasics point1ToPack, Point2DBasics point2ToPack) {
        this.edge1.set(edgePoint1A, edgePoint1B);
        this.edge2.set(edgePoint2A, edgePoint2B);
        EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)edgePoint1A, (Point2DReadOnly)edgePoint2A, (Point2DReadOnly)edgePoint2B, (Point2DBasics)this.proj1AOnto2);
        EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)edgePoint1B, (Point2DReadOnly)edgePoint2A, (Point2DReadOnly)edgePoint2B, (Point2DBasics)this.proj1BOnto2);
        EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)edgePoint2A, (Point2DReadOnly)edgePoint1A, (Point2DReadOnly)edgePoint1B, (Point2DBasics)this.proj2AOnto1);
        EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)edgePoint2B, (Point2DReadOnly)edgePoint1A, (Point2DReadOnly)edgePoint1B, (Point2DBasics)this.proj2BOnto1);
        this.possiblePointPairsWithProjValid[0] = this.edge2.isBetweenEndpoints((Point2DReadOnly)this.proj1AOnto2);
        this.possiblePointPairsWithProjValid[1] = this.edge2.isBetweenEndpoints((Point2DReadOnly)this.proj1BOnto2);
        this.possiblePointPairsWithProjValid[2] = this.edge1.isBetweenEndpoints((Point2DReadOnly)this.proj2AOnto1);
        this.possiblePointPairsWithProjValid[3] = this.edge1.isBetweenEndpoints((Point2DReadOnly)this.proj2BOnto1);
        if (this.possiblePointPairsWithProjValid[0]) {
            this.possiblePointPairsWithProj[0][0].set((Tuple2DReadOnly)edgePoint1A);
            this.possiblePointPairsWithProj[0][1].set(this.proj1AOnto2);
        }
        if (this.possiblePointPairsWithProjValid[1]) {
            this.possiblePointPairsWithProj[1][0].set((Tuple2DReadOnly)edgePoint1B);
            this.possiblePointPairsWithProj[1][1].set(this.proj1BOnto2);
        }
        if (this.possiblePointPairsWithProjValid[2]) {
            this.possiblePointPairsWithProj[2][0].set(this.proj2AOnto1);
            this.possiblePointPairsWithProj[2][1].set((Tuple2DReadOnly)edgePoint2A);
        }
        if (this.possiblePointPairsWithProjValid[3]) {
            this.possiblePointPairsWithProj[3][0].set(this.proj2BOnto1);
            this.possiblePointPairsWithProj[3][1].set((Tuple2DReadOnly)edgePoint2B);
        }
        this.possiblePointPairsWithoutProj[0][0].set((Tuple2DReadOnly)edgePoint1A);
        this.possiblePointPairsWithoutProj[0][1].set((Tuple2DReadOnly)edgePoint2A);
        this.possiblePointPairsWithoutProj[1][0].set((Tuple2DReadOnly)edgePoint1A);
        this.possiblePointPairsWithoutProj[1][1].set((Tuple2DReadOnly)edgePoint2B);
        this.possiblePointPairsWithoutProj[2][0].set((Tuple2DReadOnly)edgePoint1B);
        this.possiblePointPairsWithoutProj[2][1].set((Tuple2DReadOnly)edgePoint2A);
        this.possiblePointPairsWithoutProj[3][0].set((Tuple2DReadOnly)edgePoint1B);
        this.possiblePointPairsWithoutProj[3][1].set((Tuple2DReadOnly)edgePoint2B);
        for (int i = 0; i < 4; ++i) {
            this.possibleDistancesWithProj[i] = !this.possiblePointPairsWithProjValid[i] ? Double.MAX_VALUE : this.possiblePointPairsWithProj[i][0].distance((Point2DReadOnly)this.possiblePointPairsWithProj[i][1]);
            this.possibleDistancesWithoutProj[i] = this.possiblePointPairsWithoutProj[i][0].distance((Point2DReadOnly)this.possiblePointPairsWithoutProj[i][1]);
        }
        if (this.possibleDistancesWithProj[ConvexPolygonTools.indexOfMin(this.possibleDistancesWithProj)] != Double.MAX_VALUE) {
            Point2D[] pair = this.possiblePointPairsWithProj[ConvexPolygonTools.indexOfMin(this.possibleDistancesWithProj)];
            point1ToPack.set((Tuple2DReadOnly)pair[0]);
            point2ToPack.set((Tuple2DReadOnly)pair[1]);
        } else {
            Point2D[] pair = this.possiblePointPairsWithoutProj[ConvexPolygonTools.indexOfMin(this.possibleDistancesWithoutProj)];
            point1ToPack.set((Tuple2DReadOnly)pair[0]);
            point2ToPack.set((Tuple2DReadOnly)pair[1]);
        }
    }

    private static int indexOfMin(double[] d) {
        if (d == null || d.length == 0) {
            throw new RuntimeException("Cannot find minimum of empty or null array.");
        }
        int minIndex = 0;
        double minValue = d[minIndex];
        for (int searchIndex = 1; searchIndex < d.length; ++searchIndex) {
            if (!(d[searchIndex] < minValue)) continue;
            minIndex = searchIndex;
            minValue = d[searchIndex];
        }
        return minIndex;
    }

    private void finalPhasePointAndEdge(Point2DReadOnly edgePoint1, Point2DReadOnly edgePoint2, Point2DReadOnly lonePoint, Point2DBasics point1ToPack, Point2DBasics point2ToPack) {
        Point2D proj = EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)lonePoint, (Point2DReadOnly)edgePoint1, (Point2DReadOnly)edgePoint2);
        this.pFinalPhasePoint.set(edgePoint1, edgePoint2);
        if (this.pFinalPhasePoint.isBetweenEndpoints((Point2DReadOnly)proj, 0.0)) {
            point1ToPack.set((Tuple2DReadOnly)lonePoint);
            point2ToPack.set((Tuple2DReadOnly)proj);
        } else {
            point1ToPack.set((Tuple2DReadOnly)lonePoint);
            point2ToPack.set((Tuple2DReadOnly)(lonePoint.distance(edgePoint1) < lonePoint.distance(edgePoint2) ? edgePoint1 : edgePoint2));
        }
    }

    public static boolean doesSegmentIntersectConvexPolygon2D(Point2DReadOnly P0, Point2DReadOnly P1, ConvexPolygon2DReadOnly convexPolygon2d) {
        if (P0.equals((EuclidGeometry)P1)) {
            return convexPolygon2d.isPointInside(P0);
        }
        if (convexPolygon2d.isPointInside(P0, 1.0E-4) || convexPolygon2d.isPointInside(P1, 1.0E-4)) {
            return true;
        }
        if (convexPolygon2d.pointIsOnPerimeter(P0) || convexPolygon2d.pointIsOnPerimeter(P1)) {
            return true;
        }
        return ConvexPolygonTools.doesSegmentPassCompletelyThroughPolygon(P0, P1, convexPolygon2d);
    }

    private static boolean doesSegmentPassCompletelyThroughPolygon(Point2DReadOnly P0, Point2DReadOnly P1, ConvexPolygon2DReadOnly convexPolygon2d) {
        double tE = 0.0;
        double tL = 1.0;
        double dSx = P1.getX() - P0.getX();
        double dSy = P1.getY() - P0.getY();
        int numberOfVertices = convexPolygon2d.getNumberOfVertices();
        for (int i = 0; i < numberOfVertices; ++i) {
            double V0toV1y;
            double V0x = convexPolygon2d.getVertexCCW(i).getX();
            double V0y = convexPolygon2d.getVertexCCW(i).getY();
            double V1x = convexPolygon2d.getNextVertexCCW(i).getX();
            double V1y = convexPolygon2d.getNextVertexCCW(i).getY();
            double V0toV1x = V1x - V0x;
            double nix = V0toV1y = V1y - V0y;
            double niy = -V0toV1x;
            double P0toVix = P0.getX() - V0x;
            double P0toViy = P0.getY() - V0y;
            double N = -(P0toVix * nix + P0toViy * niy);
            double D = dSx * nix + dSy * niy;
            if (D == 0.0) {
                if (!(N < 0.0)) continue;
                return false;
            }
            double t = N / D;
            if (!(D < 0.0 ? (tE = Math.max(tE, t)) > tL : D > 0.0 && (tL = Math.min(tL, t)) < tE)) continue;
            return false;
        }
        return true;
    }

    public double computeIntersectionAreaOfPolygons(ConvexPolygon2DReadOnly polygonP, ConvexPolygon2DReadOnly polygonQ) {
        if (this.computeIntersectionOfPolygons(polygonP, polygonQ, (ConvexPolygon2DBasics)this.intersectionToThrowAway)) {
            return this.intersectionToThrowAway.getArea();
        }
        return 0.0;
    }

    public static void main(String[] args) {
        ConvexPolygon2D testPolygon = new ConvexPolygon2D();
        testPolygon.addVertex(-0.11999999991888388, 0.0700000001158462);
        testPolygon.addVertex(0.060091502969015664, 0.07000000011584623);
        testPolygon.addVertex(0.12000000008111611, 0.0700000001158462);
        testPolygon.addVertex(0.12000000008111678, -0.06999999988415362);
        testPolygon.addVertex(-0.11999999991888366, -0.0699999998841539);
        testPolygon.update();
        ConvexPolygonTools.limitVerticesConservative((ConvexPolygon2DBasics)testPolygon, 4);
        System.out.println(testPolygon);
    }
}

