/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.dataStructures.parameters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.robotics.dataStructures.PolynomialReadOnly;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ParameterPolynomial
implements PolynomialReadOnly {
    private final List<DoubleProvider> coefficients;
    private double value;

    public ParameterPolynomial(String prefix, int numberOfCoefficients, YoRegistry registry) {
        ArrayList<DoubleParameter> coefficients = new ArrayList<DoubleParameter>();
        for (int index = 0; index < numberOfCoefficients; ++index) {
            coefficients.add(new DoubleParameter(prefix + "Coefficient" + index, registry));
        }
        this.coefficients = Collections.unmodifiableList(coefficients);
    }

    public ParameterPolynomial(String prefix, double[] defaultCoefficients, YoRegistry registry) {
        ArrayList<DoubleParameter> coefficients = new ArrayList<DoubleParameter>();
        for (int index = 0; index < defaultCoefficients.length; ++index) {
            coefficients.add(new DoubleParameter(prefix + "Coefficient" + index, registry, defaultCoefficients[index]));
        }
        this.coefficients = Collections.unmodifiableList(coefficients);
    }

    @Override
    public void compute(double x) {
        double x_n = 1.0;
        this.value = 0.0;
        for (int index = 0; index < this.coefficients.size(); ++index) {
            this.value += this.coefficients.get(index).getValue() * x_n;
            x_n *= x;
        }
    }

    @Override
    public double getValue() {
        return this.value;
    }
}

