/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.dataStructures;

import java.util.List;
import us.ihmc.commons.MathTools;

public class ComplexNumber {
    private static final double TAU = Math.PI * 2;
    private double real;
    private double imag;

    public static ComplexNumber[] getComplexArray(int n) {
        ComplexNumber[] tempComplex = new ComplexNumber[n];
        for (int i = 0; i < tempComplex.length; ++i) {
            tempComplex[i] = new ComplexNumber();
        }
        return tempComplex;
    }

    public static void copyComplexArray(ComplexNumber[] arrayToPack, ComplexNumber[] arrayToCopy) {
        int index;
        if (arrayToPack.length < arrayToCopy.length) {
            throw new RuntimeException("Insufficient size for copying complex number array, available: " + arrayToPack.length + " needed: " + arrayToCopy.length);
        }
        for (index = 0; index < arrayToCopy.length; ++index) {
            arrayToPack[index].set(arrayToCopy[index]);
        }
        while (index < arrayToPack.length) {
            arrayToPack[index].set(0.0, 0.0);
            ++index;
        }
    }

    public ComplexNumber() {
        this(0.0, 0.0);
    }

    public ComplexNumber(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public ComplexNumber(ComplexNumber complexNumber) {
        this.real = complexNumber.real;
        this.imag = complexNumber.imag;
    }

    public void set(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public void set(ComplexNumber other) {
        this.set(other.real, other.imag);
    }

    public void setReal(double real) {
        this.real = real;
    }

    public void setImaginary(double imag) {
        this.imag = imag;
    }

    public void setToPurelyReal(double real) {
        this.real = real;
        this.imag = 0.0;
    }

    public void setFromEuler(double magnitude, double argument) {
        this.real = magnitude * Math.cos(argument);
        this.imag = magnitude * Math.sin(argument);
    }

    public void setToZero() {
        this.real = 0.0;
        this.imag = 0.0;
    }

    public double real() {
        return this.real;
    }

    public double imag() {
        return this.imag;
    }

    public double magnitude() {
        if (this.real != 0.0 || this.imag != 0.0) {
            return Math.sqrt(this.real * this.real + this.imag * this.imag);
        }
        return 0.0;
    }

    public double magnitudeSquared() {
        if (this.real != 0.0 || this.imag != 0.0) {
            return this.real * this.real + this.imag * this.imag;
        }
        return 0.0;
    }

    public double angle() {
        return Math.atan2(this.imag, this.real);
    }

    public ComplexNumber conj() {
        return new ComplexNumber(this.real, -this.imag);
    }

    public ComplexNumber plus(ComplexNumber w) {
        ComplexNumber complexNumber = new ComplexNumber(this);
        complexNumber.plusAndStore(w);
        return complexNumber;
    }

    public void plusAndStore(ComplexNumber c1, ComplexNumber c2) {
        this.set(c1);
        this.plusAndStore(c2);
    }

    public void plusAndStore(ComplexNumber other) {
        this.plusAndStore(other.real, other.imag);
    }

    public void plusAndStore(double real, double imag) {
        this.real += real;
        this.imag += imag;
    }

    public ComplexNumber plus(double d) {
        ComplexNumber complexNumber = new ComplexNumber(this);
        complexNumber.plusAndStore(d, 0.0);
        return complexNumber;
    }

    public ComplexNumber minus(ComplexNumber w) {
        ComplexNumber complexNumber = new ComplexNumber(this);
        complexNumber.minusAndStore(w);
        return complexNumber;
    }

    public ComplexNumber minus(double d) {
        ComplexNumber complexNumber = new ComplexNumber(this);
        complexNumber.minusAndStore(d, 0.0);
        return complexNumber;
    }

    public void minusAndStore(ComplexNumber c1, ComplexNumber c2) {
        this.set(c1);
        this.minusAndStore(c2);
    }

    public void minusAndStore(ComplexNumber other) {
        this.minusAndStore(other.real, other.imag);
    }

    public void minusAndStore(double real, double imag) {
        this.real -= real;
        this.imag -= imag;
    }

    public ComplexNumber times(ComplexNumber w) {
        ComplexNumber complexNumber = new ComplexNumber(this);
        complexNumber.timesAndStore(w);
        return complexNumber;
    }

    public ComplexNumber times(double w) {
        ComplexNumber complexNumber = new ComplexNumber(this);
        complexNumber.timesAndStore(w, 0.0);
        return complexNumber;
    }

    public void timesAndStore(ComplexNumber other) {
        this.timesAndStore(other.real, other.imag);
    }

    public void timesAndStore(double real, double imag) {
        double tempVal1 = this.real * real - this.imag * imag;
        this.imag = this.real * imag + real * this.imag;
        this.real = tempVal1;
    }

    public void timesAndStore(ComplexNumber c1, ComplexNumber c2) {
        this.set(c1);
        this.timesAndStore(c2);
    }

    public ComplexNumber dividedBy(ComplexNumber w) {
        double den = MathTools.square((double)w.magnitude());
        return new ComplexNumber((this.real * w.real() + this.imag * w.imag()) / den, (this.imag * w.real() - this.real * w.imag()) / den);
    }

    public void scale(double scalar) {
        this.real *= scalar;
        this.imag *= scalar;
    }

    public ComplexNumber exp() {
        return new ComplexNumber(Math.exp(this.real) * Math.cos(this.imag), Math.exp(this.real) * Math.sin(this.imag));
    }

    public ComplexNumber log() {
        return new ComplexNumber(Math.log(this.magnitude()), this.angle());
    }

    public ComplexNumber sqrt() {
        double r = Math.sqrt(this.magnitude());
        double theta = this.angle() / 2.0;
        return new ComplexNumber(r * Math.cos(theta), r * Math.sin(theta));
    }

    private double cosh(double theta) {
        return (Math.exp(theta) + Math.exp(-theta)) / 2.0;
    }

    private double sinh(double theta) {
        return (Math.exp(theta) - Math.exp(-theta)) / 2.0;
    }

    public ComplexNumber sin() {
        return new ComplexNumber(this.cosh(this.imag) * Math.sin(this.real), this.sinh(this.imag) * Math.cos(this.real));
    }

    public ComplexNumber cos() {
        return new ComplexNumber(this.cosh(this.imag) * Math.cos(this.real), -this.sinh(this.imag) * Math.sin(this.real));
    }

    public ComplexNumber sinh() {
        return new ComplexNumber(this.sinh(this.real) * Math.cos(this.imag), this.cosh(this.real) * Math.sin(this.imag));
    }

    public ComplexNumber cosh() {
        return new ComplexNumber(this.cosh(this.real) * Math.cos(this.imag), this.sinh(this.real) * Math.sin(this.imag));
    }

    public ComplexNumber tan() {
        return this.sin().dividedBy(this.cos());
    }

    public ComplexNumber changeSign() {
        return new ComplexNumber(-this.real, -this.imag);
    }

    public boolean epsilonEquals(double realNumber, double epsilon) {
        if (Math.abs(this.real - realNumber) > epsilon) {
            return false;
        }
        return !(Math.abs(this.imag) > epsilon);
    }

    public boolean epsilonEquals(ComplexNumber complexNumber, double epsilon) {
        if (Math.abs(this.real - complexNumber.real()) > epsilon) {
            return false;
        }
        return !(Math.abs(this.imag - complexNumber.imag()) > epsilon);
    }

    public void getRoots(ComplexNumber root1, ComplexNumber root2) {
        double tempVal1 = Math.sqrt(this.magnitude());
        double tempVal2 = this.angle();
        root1.setFromEuler(tempVal1, tempVal2 / 2.0);
        root2.setFromEuler(tempVal1, (tempVal2 + Math.PI * 2) / 2.0);
    }

    public void getRoots(List<ComplexNumber> rootsToPack, int n) {
        double tempVal1 = Math.pow(this.magnitude(), 1.0 / (double)n);
        double tempVal2 = this.angle() / (double)n;
        for (int i = 0; i < n; ++i) {
            rootsToPack.get(i).setFromEuler(tempVal1, tempVal2 + Math.PI * 2 * (double)i / (double)n);
        }
    }

    public String toString() {
        if (this.real != 0.0 && this.imag > 0.0) {
            return this.real + " + " + this.imag + "i";
        }
        if (this.real != 0.0 && this.imag < 0.0) {
            return this.real + " - " + -this.imag + "i";
        }
        if (this.imag == 0.0) {
            return String.valueOf(this.real);
        }
        if (this.real == 0.0) {
            return this.imag + "i";
        }
        return this.real + " + i*" + this.imag;
    }
}

