/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.pidGains.implementations;

import us.ihmc.robotics.controllers.pidGains.GainCalculator;
import us.ihmc.robotics.controllers.pidGains.PDGainsReadOnly;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoPDGains
implements PDGainsReadOnly {
    private final YoDouble kp;
    private final YoDouble kd;
    private final YoDouble zeta;
    private final YoDouble maximumFeedback;
    private final YoDouble maximumFeedbackRate;
    private final YoDouble positionDeadband;

    public YoPDGains(String suffix, YoRegistry registry) {
        this.kp = new YoDouble("kp" + suffix, registry);
        this.zeta = new YoDouble("zeta" + suffix, registry);
        this.kd = new YoDouble("kd" + suffix, registry);
        this.maximumFeedback = new YoDouble("maximumFeedback" + suffix, registry);
        this.maximumFeedbackRate = new YoDouble("maximumFeedbackRate" + suffix, registry);
        this.positionDeadband = new YoDouble("positionDeadband" + suffix, registry);
        this.maximumFeedback.set(Double.POSITIVE_INFINITY);
        this.maximumFeedbackRate.set(Double.POSITIVE_INFINITY);
    }

    public void setPDGains(double kp, double zeta) {
        this.kp.set(kp);
        this.zeta.set(zeta);
    }

    public void setKp(double kp) {
        this.kp.set(kp);
    }

    public void setKd(double kd) {
        this.kd.set(kd);
    }

    public void setZeta(double zeta) {
        this.zeta.set(zeta);
    }

    public void setMaximumFeedback(double maxFeedback) {
        this.maximumFeedback.set(maxFeedback);
    }

    public void setMaximumFeedbackRate(double maxFeedbackRate) {
        this.maximumFeedbackRate.set(maxFeedbackRate);
    }

    public void setMaximumFeedbackAndMaximumFeedbackRate(double maxFeedback, double maxFeedbackRate) {
        this.maximumFeedback.set(maxFeedback);
        this.maximumFeedbackRate.set(maxFeedbackRate);
    }

    public void setPositionDeadband(double deadband) {
        this.positionDeadband.set(deadband);
    }

    @Override
    public double getKp() {
        return this.kp.getDoubleValue();
    }

    public double getZeta() {
        return this.zeta.getDoubleValue();
    }

    @Override
    public double getKd() {
        return this.kd.getDoubleValue();
    }

    @Override
    public double getMaximumFeedback() {
        return this.maximumFeedback.getDoubleValue();
    }

    @Override
    public double getMaximumFeedbackRate() {
        return this.maximumFeedbackRate.getDoubleValue();
    }

    @Override
    public double getPositionDeadband() {
        return this.positionDeadband.getDoubleValue();
    }

    public YoDouble getYoKp() {
        return this.kp;
    }

    public YoDouble getYoZeta() {
        return this.zeta;
    }

    public YoDouble getYoKd() {
        return this.kd;
    }

    public YoDouble getYoMaximumFeedback() {
        return this.maximumFeedback;
    }

    public YoDouble getYoMaximumFeedbackRate() {
        return this.maximumFeedbackRate;
    }

    public YoDouble getYoPositionDeadband() {
        return this.positionDeadband;
    }

    public void createDerivativeGainUpdater(boolean updateNow) {
        YoVariableChangedListener kdUpdater = new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                YoPDGains.this.kd.set(GainCalculator.computeDerivativeGain(YoPDGains.this.kp.getDoubleValue(), YoPDGains.this.zeta.getDoubleValue()));
            }
        };
        this.kp.addListener(kdUpdater);
        this.zeta.addListener(kdUpdater);
        if (updateNow) {
            kdUpdater.changed(null);
        }
    }

    public void set(YoPDGains other) {
        this.kp.set(other.kp.getDoubleValue());
        this.kd.set(other.kd.getDoubleValue());
        this.zeta.set(other.zeta.getDoubleValue());
        this.maximumFeedback.set(other.maximumFeedback.getDoubleValue());
        this.maximumFeedbackRate.set(other.maximumFeedbackRate.getDoubleValue());
        this.positionDeadband.set(other.positionDeadband.getDoubleValue());
    }

    public void set(PDGainsReadOnly pdGains) {
        this.setKp(pdGains.getKp());
        this.setKd(pdGains.getKd());
        this.setZeta(GainCalculator.computeDampingRatio(pdGains.getKp(), pdGains.getKd()));
        this.setMaximumFeedback(pdGains.getMaximumFeedback());
        this.setMaximumFeedbackRate(pdGains.getMaximumFeedbackRate());
        this.setPositionDeadband(pdGains.getPositionDeadband());
    }

    public boolean equals(Object object) {
        if (object instanceof PDGainsReadOnly) {
            return PDGainsReadOnly.super.equals((PDGainsReadOnly)object);
        }
        return false;
    }
}

