/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.robotics.controllers.AxisAngleOrientationController;
import us.ihmc.robotics.controllers.EuclideanPositionController;
import us.ihmc.robotics.controllers.pidGains.PID3DGains;
import us.ihmc.robotics.controllers.pidGains.PIDSE3Gains;
import us.ihmc.robotics.controllers.pidGains.YoPIDSE3Gains;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SE3PIDController {
    private final ReferenceFrame bodyFrame;
    private final AxisAngleOrientationController orientationController;
    private final FrameQuaternion desiredOrientation = new FrameQuaternion();
    private final FrameVector3D desiredAngularVelocity = new FrameVector3D();
    private final FrameVector3D feedForwardAngularAction = new FrameVector3D();
    private final FrameVector3D currentAngularVelocity = new FrameVector3D();
    private final FrameVector3D angularActionFromOrientationController = new FrameVector3D();
    private final EuclideanPositionController positionController;
    private final FramePoint3D desiredPosition = new FramePoint3D();
    private final FrameVector3D desiredVelocity = new FrameVector3D();
    private final FrameVector3D feedForwardLinearAction = new FrameVector3D();
    private final FrameVector3D currentVelocity = new FrameVector3D();
    private final FrameVector3D actionFromPositionController = new FrameVector3D();

    public SE3PIDController(String namePrefix, ReferenceFrame bodyFrame, double dt, YoRegistry registry) {
        this(namePrefix, bodyFrame, dt, null, registry);
    }

    public SE3PIDController(String namePrefix, ReferenceFrame bodyFrame, double dt, YoPIDSE3Gains gains, YoRegistry registry) {
        this.bodyFrame = bodyFrame;
        if (gains != null) {
            this.orientationController = new AxisAngleOrientationController(namePrefix, bodyFrame, dt, gains.getOrientationGains(), registry);
            this.positionController = new EuclideanPositionController(namePrefix, bodyFrame, dt, gains.getPositionGains(), registry);
        } else {
            this.orientationController = new AxisAngleOrientationController(namePrefix, bodyFrame, dt, registry);
            this.positionController = new EuclideanPositionController(namePrefix, bodyFrame, dt, registry);
        }
    }

    public void reset() {
        this.orientationController.reset();
        this.positionController.reset();
    }

    public void resetIntegrator() {
        this.orientationController.resetIntegrator();
        this.positionController.resetIntegrator();
    }

    public void compute(Twist twistToPack, FramePose3D desiredPose, TwistReadOnly desiredTwist) {
        this.checkBodyFrames(desiredTwist, (TwistReadOnly)twistToPack);
        this.checkBaseFrames(desiredTwist, (TwistReadOnly)twistToPack);
        this.checkExpressedInFrames(desiredTwist, (TwistReadOnly)twistToPack);
        twistToPack.setToZero(this.bodyFrame, desiredTwist.getBaseFrame(), this.bodyFrame);
        this.desiredOrientation.setIncludingFrame((FrameQuaternionReadOnly)desiredPose.getOrientation());
        this.desiredAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredTwist.getAngularPart());
        this.feedForwardAngularAction.setIncludingFrame((FrameTuple3DReadOnly)desiredTwist.getAngularPart());
        this.orientationController.compute(this.angularActionFromOrientationController, this.desiredOrientation, this.desiredAngularVelocity, null, this.feedForwardAngularAction);
        twistToPack.getAngularPart().set((FrameTuple3DReadOnly)this.angularActionFromOrientationController);
        this.desiredPosition.setIncludingFrame((FrameTuple3DReadOnly)desiredPose.getPosition());
        this.desiredVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredTwist.getLinearPart());
        this.feedForwardLinearAction.setIncludingFrame((FrameTuple3DReadOnly)desiredTwist.getLinearPart());
        this.positionController.compute(this.actionFromPositionController, this.desiredPosition, this.desiredVelocity, null, this.feedForwardLinearAction);
        twistToPack.getLinearPart().set((FrameTuple3DReadOnly)this.actionFromPositionController);
    }

    public void compute(SpatialAcceleration spatialAccelerationToPack, FramePose3D desiredPose, TwistReadOnly desiredTwist, SpatialAccelerationReadOnly feedForwardAcceleration, TwistReadOnly currentTwist) {
        this.checkBodyFrames(desiredTwist, feedForwardAcceleration, currentTwist);
        this.checkBaseFrames(desiredTwist, feedForwardAcceleration, currentTwist);
        this.checkExpressedInFrames(desiredTwist, feedForwardAcceleration, currentTwist);
        spatialAccelerationToPack.setToZero(this.bodyFrame, feedForwardAcceleration.getBaseFrame(), this.bodyFrame);
        this.desiredOrientation.setIncludingFrame((FrameQuaternionReadOnly)desiredPose.getOrientation());
        this.desiredAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredTwist.getAngularPart());
        this.feedForwardAngularAction.setIncludingFrame((FrameTuple3DReadOnly)feedForwardAcceleration.getAngularPart());
        this.currentAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)currentTwist.getAngularPart());
        this.orientationController.compute(this.angularActionFromOrientationController, this.desiredOrientation, this.desiredAngularVelocity, this.currentAngularVelocity, this.feedForwardAngularAction);
        spatialAccelerationToPack.getAngularPart().set((FrameTuple3DReadOnly)this.angularActionFromOrientationController);
        this.desiredPosition.setIncludingFrame((FrameTuple3DReadOnly)desiredPose.getPosition());
        this.desiredVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredTwist.getLinearPart());
        this.feedForwardLinearAction.setIncludingFrame((FrameTuple3DReadOnly)feedForwardAcceleration.getLinearPart());
        this.currentVelocity.setIncludingFrame((FrameTuple3DReadOnly)currentTwist.getLinearPart());
        this.positionController.compute(this.actionFromPositionController, this.desiredPosition, this.desiredVelocity, this.currentVelocity, this.feedForwardLinearAction);
        spatialAccelerationToPack.getLinearPart().set((FrameTuple3DReadOnly)this.actionFromPositionController);
    }

    private void checkBodyFrames(TwistReadOnly desiredTwist, TwistReadOnly currentTwist) {
        desiredTwist.getBodyFrame().checkReferenceFrameMatch(this.bodyFrame);
        currentTwist.getBodyFrame().checkReferenceFrameMatch(this.bodyFrame);
    }

    private void checkBaseFrames(TwistReadOnly desiredTwist, TwistReadOnly currentTwist) {
        desiredTwist.getBaseFrame().checkReferenceFrameMatch(currentTwist.getBaseFrame());
    }

    private void checkExpressedInFrames(TwistReadOnly desiredTwist, TwistReadOnly currentTwist) {
        desiredTwist.getReferenceFrame().checkReferenceFrameMatch(this.bodyFrame);
        currentTwist.getReferenceFrame().checkReferenceFrameMatch(this.bodyFrame);
    }

    private void checkBodyFrames(TwistReadOnly desiredTwist, SpatialAccelerationReadOnly feedForwardAcceleration, TwistReadOnly currentTwist) {
        this.checkBodyFrames(desiredTwist, currentTwist);
        feedForwardAcceleration.getBodyFrame().checkReferenceFrameMatch(this.bodyFrame);
    }

    private void checkBaseFrames(TwistReadOnly desiredTwist, SpatialAccelerationReadOnly feedForwardAcceleration, TwistReadOnly currentTwist) {
        this.checkBaseFrames(desiredTwist, currentTwist);
        desiredTwist.getBaseFrame().checkReferenceFrameMatch(feedForwardAcceleration.getBaseFrame());
    }

    private void checkExpressedInFrames(TwistReadOnly desiredTwist, SpatialAccelerationReadOnly feedForwardAcceleration, TwistReadOnly currentTwist) {
        this.checkExpressedInFrames(desiredTwist, currentTwist);
        feedForwardAcceleration.getReferenceFrame().checkReferenceFrameMatch(this.bodyFrame);
    }

    public void setPositionProportionalGains(double kpx, double kpy, double kpz) {
        this.positionController.setProportionalGains(kpx, kpy, kpz);
    }

    public void setPositionDerivativeGains(double kdx, double kdy, double kdz) {
        this.positionController.setDerivativeGains(kdx, kdy, kdz);
    }

    public void setPositionIntegralGains(double kix, double kiy, double kiz, double maxIntegralError) {
        this.positionController.setIntegralGains(kix, kiy, kiz, maxIntegralError);
    }

    public void setOrientationProportionalGains(double kpx, double kpy, double kpz) {
        this.orientationController.setProportionalGains(kpx, kpy, kpz);
    }

    public void setOrientationDerivativeGains(double kdx, double kdy, double kdz) {
        this.orientationController.setDerivativeGains(kdx, kdy, kdz);
    }

    public void setOrientationIntegralGains(double kix, double kiy, double kiz, double maxIntegralError) {
        this.orientationController.setIntegralGains(kix, kiy, kiz, maxIntegralError);
    }

    public void setPositionMaxFeedbackAndFeedbackRate(double maxFeedback, double maxFeedbackRate) {
        this.positionController.setMaxFeedbackAndFeedbackRate(maxFeedback, maxFeedbackRate);
    }

    public void setPositionMaxDerivativeError(double maxDerivativeError) {
        this.positionController.setMaxDerivativeError(maxDerivativeError);
    }

    public void setPositionMaxProportionalError(double maxProportionalError) {
        this.positionController.setMaxProportionalError(maxProportionalError);
    }

    public void setOrientationMaxFeedbackAndFeedbackRate(double maxAcceleration, double maxFeedbackRate) {
        this.orientationController.setMaxFeedbackAndFeedbackRate(maxAcceleration, maxFeedbackRate);
    }

    public void setOrientationMaxDerivativeError(double maxDerivativeError) {
        this.orientationController.setMaxDerivativeError(maxDerivativeError);
    }

    public void setOrientationMaxProportionalError(double maxProportionalError) {
        this.orientationController.setMaxProportionalError(maxProportionalError);
    }

    public void setGains(PIDSE3Gains gains) {
        this.positionController.setGains(gains.getPositionGains());
        this.orientationController.setGains(gains.getOrientationGains());
    }

    public void setPositionGains(PID3DGains gains) {
        this.positionController.setGains(gains);
    }

    public void setOrientationGains(PID3DGains gains) {
        this.orientationController.setGains(gains);
    }
}

