/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.robotics.controllers.AbstractPDController;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ParameterizedPDController
extends AbstractPDController {
    private final DoubleProvider proportionalGain;
    private final DoubleProvider derivativeGain;
    private final DoubleProvider positionDeadband;

    public ParameterizedPDController(String suffix, YoRegistry registry) {
        super(suffix, registry);
        this.proportionalGain = new DoubleParameter("kp_" + suffix, registry, 0.0);
        this.derivativeGain = new DoubleParameter("kd_" + suffix, registry, 0.0);
        this.positionDeadband = new DoubleParameter("positionDeadband_" + suffix, registry, 0.0);
    }

    public ParameterizedPDController(DoubleProvider proportionalGain, DoubleProvider derivativeGain, DoubleProvider positionDeadband, String suffix, YoRegistry registry) {
        super(suffix, registry);
        this.proportionalGain = proportionalGain;
        this.derivativeGain = derivativeGain;
        this.positionDeadband = positionDeadband;
    }

    public ParameterizedPDController(DoubleProvider proportionalGain, DoubleProvider derivativeGain, String suffix, YoRegistry registry) {
        super(suffix, registry);
        this.proportionalGain = proportionalGain;
        this.derivativeGain = derivativeGain;
        this.positionDeadband = () -> 0.0;
    }

    @Override
    public double getProportionalGain() {
        return this.proportionalGain.getValue();
    }

    @Override
    public double getDerivativeGain() {
        return this.derivativeGain.getValue();
    }

    @Override
    public double getPositionDeadband() {
        return this.positionDeadband.getValue();
    }
}

