/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.robotics.math.DeadbandTools;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public abstract class AbstractPDController {
    private final YoDouble positionError;
    private final YoDouble rateError;
    private final YoDouble actionP;
    private final YoDouble actionD;

    protected AbstractPDController(String suffix, YoRegistry registry) {
        this.positionError = new YoDouble("positionError_" + suffix, registry);
        this.positionError.set(0.0);
        this.rateError = new YoDouble("rateError_" + suffix, registry);
        this.rateError.set(0.0);
        this.actionP = new YoDouble("action_P_" + suffix, registry);
        this.actionP.set(0.0);
        this.actionD = new YoDouble("action_D_" + suffix, registry);
        this.actionD.set(0.0);
    }

    public abstract double getProportionalGain();

    public abstract double getDerivativeGain();

    public abstract double getPositionDeadband();

    public double getPositionError() {
        return this.positionError.getDoubleValue();
    }

    public double getRateError() {
        return this.rateError.getDoubleValue();
    }

    public double compute(double currentPosition, double desiredPosition, double currentRate, double desiredRate) {
        this.positionError.set(DeadbandTools.applyDeadband(this.getPositionDeadband(), desiredPosition - currentPosition));
        this.rateError.set(desiredRate - currentRate);
        this.actionP.set(this.getProportionalGain() * this.positionError.getDoubleValue());
        this.actionD.set(this.getDerivativeGain() * this.rateError.getDoubleValue());
        return this.actionP.getDoubleValue() + this.actionD.getDoubleValue();
    }

    public double computeForAngles(double currentPosition, double desiredPosition, double currentRate, double desiredRate) {
        this.positionError.set(DeadbandTools.applyDeadband(this.getPositionDeadband(), AngleTools.computeAngleDifferenceMinusPiToPi(desiredPosition, currentPosition)));
        this.rateError.set(desiredRate - currentRate);
        this.actionP.set(this.getProportionalGain() * this.positionError.getDoubleValue());
        this.actionD.set(this.getDerivativeGain() * this.rateError.getDoubleValue());
        return this.actionP.getDoubleValue() + this.actionD.getDoubleValue();
    }

    public static AbstractPDController createPDController(String suffix, final DoubleProvider proportionalGain, final DoubleProvider derivativeGain, final DoubleProvider deadband, YoRegistry registry) {
        return new AbstractPDController(suffix, registry){

            @Override
            public double getProportionalGain() {
                return proportionalGain.getValue();
            }

            @Override
            public double getPositionDeadband() {
                return deadband.getValue();
            }

            @Override
            public double getDerivativeGain() {
                return derivativeGain.getValue();
            }
        };
    }
}

