/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.alphaToAlpha;

import us.ihmc.robotics.alphaToAlpha.AlphaToAlphaFunction;

public class StretchedSlowAtStartAlphaToAlphaFunction
implements AlphaToAlphaFunction {
    private double derivativeAtEnd;
    private double ratio;
    private double alphaToStartAt;
    private double a2;
    private double a3;
    private double a4;

    public StretchedSlowAtStartAlphaToAlphaFunction(double derivativeAtEnd) {
        this.derivativeAtEnd = derivativeAtEnd;
        this.calculateInternalParameters();
    }

    private void calculateInternalParameters() {
        if (this.derivativeAtEnd < 1.0) {
            throw new RuntimeException("We are assuming derivativeAtEnd >= 1.0!!!");
        }
        if (this.derivativeAtEnd > 2.0) {
            this.alphaToStartAt = (this.derivativeAtEnd - 2.0) / this.derivativeAtEnd;
            this.ratio = 2.0;
        } else {
            this.alphaToStartAt = 0.0;
            this.ratio = this.derivativeAtEnd;
        }
        this.a2 = 6.0 - 3.0 * this.ratio;
        this.a3 = -8.0 + 5.0 * this.ratio;
        this.a4 = 3.0 - 2.0 * this.ratio;
    }

    @Override
    public double getAlphaPrime(double alpha) {
        if (alpha < 0.0) {
            return 0.0;
        }
        if (alpha > 1.0) {
            return 1.0;
        }
        if (alpha < this.alphaToStartAt) {
            return 0.0;
        }
        double ret = this.a2 * (alpha = (alpha - this.alphaToStartAt) / (1.0 - this.alphaToStartAt)) * alpha + this.a3 * alpha * alpha * alpha + this.a4 * alpha * alpha * alpha * alpha;
        if (ret < 0.0) {
            return 0.0;
        }
        if (ret > 1.0) {
            return 1.0;
        }
        return ret;
    }

    public void setDerivativeAtEnd(double derivativeAtEnd) {
        this.derivativeAtEnd = derivativeAtEnd;
        this.calculateInternalParameters();
    }

    @Override
    public double getMaxAlpha() {
        return 1.0;
    }

    public static void main(String[] args) {
        new StretchedSlowAtStartAlphaToAlphaFunction(6.0);
    }

    @Override
    public double getDerivativeAtAlpha(double alpha) {
        throw new RuntimeException("Not implemented yet!");
    }

    @Override
    public double getSecondDerivativeAtAlpha(double alpha) {
        throw new RuntimeException("Not implemented yet!");
    }
}

