/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics;

import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.math3.util.Pair;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.geometry.FramePlanarRegionsList;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class PlanarRegionFileTools {
    public static String createDefaultTimeStampedFolderName() {
        return PlanarRegionFileTools.getDate() + "_PlanarRegion";
    }

    public static String getDate() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
        return LocalDateTime.now().format(dateTimeFormatter);
    }

    public static boolean exportPlanarRegionData(Path folderPath, PlanarRegionsList planarRegionData) {
        try {
            Files.createDirectories(folderPath, new FileAttribute[0]);
            PlanarRegionFileTools.writePlanarRegionsData(folderPath, planarRegionData);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean exportPlanarRegionDataAsFile(Path filePath, PlanarRegionsList planarRegionData) {
        try {
            Files.createFile(filePath, new FileAttribute[0]);
            FileOutputStream ostream = new FileOutputStream(filePath.toFile());
            PlanarRegionFileTools.writePlanarRegionsDataToStream(ostream, planarRegionData);
            ostream.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean exportPlanarRegionDataToStream(OutputStream ostream, PlanarRegionsList planarRegionData) {
        try {
            PlanarRegionFileTools.writePlanarRegionsDataToStream(ostream, planarRegionData);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean exportFramePlanarRegionDataToStream(OutputStream ostream, FramePlanarRegionsList framePlanarRegions) {
        try {
            PlanarRegionFileTools.writeFramePlanarRegionsDataToStream(ostream, framePlanarRegions);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isPlanarRegionFile(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                return PlanarRegionFileTools.importPlanarRegionDataInternal(filename -> new File(file, filename)) != null;
            }
            return PlanarRegionFileTools.importPlanarRegionDataFromFileInternal(file) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static PlanarRegionsList importPlanarRegionData(File data) {
        try {
            PlanarRegionsList loadedRegions = data.isDirectory() ? PlanarRegionFileTools.importPlanarRegionDataInternal(filename -> new File(data, filename)) : PlanarRegionFileTools.importPlanarRegionDataFromFileInternal(data);
            if (loadedRegions == null) {
                LogTools.error((String)("Could not load the file: " + data.getName()));
            }
            return loadedRegions;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static FramePlanarRegionsList importFramePlanarRegionsData(File data) {
        try {
            FramePlanarRegionsList loadedRegions = PlanarRegionFileTools.importFramePlanarRegionFromFile(data);
            if (loadedRegions == null) {
                LogTools.error((String)("Could not load the file: " + data.getName()));
            }
            return loadedRegions;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PlanarRegionsList importPlanarRegionData(Class<?> clazz, String dataFolder) {
        try {
            PlanarRegionsList loadedRegions = PlanarRegionFileTools.importPlanarRegionDataInternalForTests(filename -> {
                String resourceName = dataFolder + "/" + filename;
                InputStream inputStream = clazz.getResourceAsStream(resourceName);
                if (inputStream == null) {
                    LogTools.error((String)("Could not open resource: " + resourceName), PlanarRegionsList.class);
                    return null;
                }
                return new BufferedReader(new InputStreamReader(inputStream));
            });
            if (loadedRegions == null) {
                LogTools.error((String)("Could not load the file: " + dataFolder));
            }
            return loadedRegions;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PlanarRegionsList importPlanarRegionData(ClassLoader classLoader, String dataFolder) {
        try {
            PlanarRegionsList loadedRegions = PlanarRegionFileTools.importPlanarRegionDataInternalForTests(filename -> {
                String resourceName = dataFolder + "/" + filename;
                InputStream inputStream = classLoader.getResourceAsStream(resourceName);
                if (inputStream == null) {
                    LogTools.error((String)("Could not open resource: " + resourceName), PlanarRegionsList.class);
                    return null;
                }
                return new BufferedReader(new InputStreamReader(inputStream));
            });
            if (loadedRegions == null) {
                LogTools.error((String)("Could not load the file: " + dataFolder));
            }
            return loadedRegions;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PlanarRegionsList importPlanarRegionData(Class<?> loadingClass, Path dataFolderRelativePath) {
        try {
            PlanarRegionsList loadedRegions = PlanarRegionFileTools.importPlanarRegionDataInternal(filename -> PlanarRegionFileTools.fileFromClassPath(loadingClass, Paths.get(dataFolderRelativePath.toString(), filename)));
            if (loadedRegions == null) {
                LogTools.error((String)("Could not load the file: " + dataFolderRelativePath.toString()));
            }
            return loadedRegions;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static PlanarRegionsList importPlanarRegionDataInternal(FileCreator fileCreator) throws IOException {
        TIntArrayList convexPolygonsSize;
        MutableInt concaveHullSize;
        MutableInt regionId;
        AxisAngle orientation;
        Point3D origin;
        String fileName;
        File headerFile = fileCreator.createFile("header.txt");
        ArrayList<PlanarRegion> planarRegions = new ArrayList<PlanarRegion>();
        FileReader fileReader = new FileReader(headerFile);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        while ((fileName = PlanarRegionFileTools.readHeaderLine(bufferedReader, origin = new Point3D(), orientation = new AxisAngle(), regionId = new MutableInt(), concaveHullSize = new MutableInt(), convexPolygonsSize = new TIntArrayList())) != null) {
            File regionFile = fileCreator.createFile(fileName);
            FileReader regionFileReader = new FileReader(regionFile);
            BufferedReader regionBufferedReader = new BufferedReader(regionFileReader);
            PlanarRegion loadedRegion = PlanarRegionFileTools.loadPlanarRegionVertices(regionBufferedReader, concaveHullSize.intValue(), convexPolygonsSize.toArray(), regionId.intValue(), origin, orientation);
            regionBufferedReader.close();
            if (loadedRegion != null) {
                planarRegions.add(loadedRegion);
                continue;
            }
            bufferedReader.close();
            return null;
        }
        bufferedReader.close();
        return new PlanarRegionsList(planarRegions);
    }

    private static PlanarRegionsList importPlanarRegionDataFromFileInternal(File file) throws IOException {
        TIntArrayList convexPolygonsSize;
        MutableInt concaveHullSize;
        MutableInt regionId;
        AxisAngle orientation;
        Point3D origin;
        String regionName;
        Scanner scan = new Scanner(file);
        scan.useDelimiter("\\*\n");
        ArrayList<PlanarRegion> planarRegions = new ArrayList<PlanarRegion>();
        BufferedReader headerBufferedReader = new BufferedReader(new StringReader(scan.next()));
        HashMap<String, String> regionStrings = new HashMap<String, String>();
        while (scan.hasNext()) {
            scan.nextLine();
            regionStrings.put(scan.nextLine(), scan.next());
        }
        while ((regionName = PlanarRegionFileTools.readHeaderLine(headerBufferedReader, origin = new Point3D(), orientation = new AxisAngle(), regionId = new MutableInt(), concaveHullSize = new MutableInt(), convexPolygonsSize = new TIntArrayList())) != null) {
            if (!regionStrings.containsKey(regionName)) continue;
            BufferedReader regionBufferedReader = new BufferedReader(new StringReader((String)regionStrings.get(regionName)));
            PlanarRegion loadedRegion = PlanarRegionFileTools.loadPlanarRegionVertices(regionBufferedReader, concaveHullSize.intValue(), convexPolygonsSize.toArray(), regionId.intValue(), origin, orientation);
            regionBufferedReader.close();
            if (loadedRegion != null) {
                planarRegions.add(loadedRegion);
                continue;
            }
            headerBufferedReader.close();
            return null;
        }
        headerBufferedReader.close();
        return new PlanarRegionsList(planarRegions);
    }

    private static FramePlanarRegionsList importFramePlanarRegionFromFile(File file) throws IOException {
        TIntArrayList convexPolygonsSize;
        MutableInt concaveHullSize;
        MutableInt regionId;
        AxisAngle orientation;
        Point3D origin;
        String regionName;
        Scanner scan = new Scanner(file);
        scan.useDelimiter("\\*\n");
        ArrayList<PlanarRegion> planarRegions = new ArrayList<PlanarRegion>();
        BufferedReader headerBufferedReader = new BufferedReader(new StringReader(scan.next()));
        HashMap<String, String> regionStrings = new HashMap<String, String>();
        Point3D sensorPosition = new Point3D();
        AxisAngle sensorOrientation = new AxisAngle();
        PlanarRegionFileTools.readSensorTransform(headerBufferedReader, sensorPosition, sensorOrientation);
        RigidBodyTransform sensorToWorldTransform = new RigidBodyTransform((Orientation3DReadOnly)sensorOrientation, (Tuple3DReadOnly)sensorPosition);
        while (scan.hasNext()) {
            scan.nextLine();
            regionStrings.put(scan.nextLine(), scan.next());
        }
        while ((regionName = PlanarRegionFileTools.readHeaderLine(headerBufferedReader, origin = new Point3D(), orientation = new AxisAngle(), regionId = new MutableInt(), concaveHullSize = new MutableInt(), convexPolygonsSize = new TIntArrayList())) != null) {
            if (!regionStrings.containsKey(regionName)) continue;
            BufferedReader regionBufferedReader = new BufferedReader(new StringReader((String)regionStrings.get(regionName)));
            PlanarRegion loadedRegion = PlanarRegionFileTools.loadPlanarRegionVertices(regionBufferedReader, concaveHullSize.intValue(), convexPolygonsSize.toArray(), regionId.intValue(), origin, orientation);
            regionBufferedReader.close();
            if (loadedRegion != null) {
                planarRegions.add(loadedRegion);
                continue;
            }
            headerBufferedReader.close();
            return null;
        }
        headerBufferedReader.close();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(planarRegions);
        FramePlanarRegionsList framePlanarRegionsList = new FramePlanarRegionsList(planarRegionsList, sensorToWorldTransform);
        return framePlanarRegionsList;
    }

    private static PlanarRegionsList importPlanarRegionDataInternalForTests(ReaderCreator readerCreator) throws IOException {
        TIntArrayList convexPolygonsSize;
        MutableInt concaveHullSize;
        MutableInt regionId;
        AxisAngle orientation;
        Point3D origin;
        String fileName;
        BufferedReader headerFile = readerCreator.createReader("header.txt");
        if (headerFile == null) {
            LogTools.error((String)"Could not find header file for planar region!");
            return null;
        }
        ArrayList<PlanarRegion> planarRegions = new ArrayList<PlanarRegion>();
        while ((fileName = PlanarRegionFileTools.readHeaderLine(headerFile, origin = new Point3D(), orientation = new AxisAngle(), regionId = new MutableInt(), concaveHullSize = new MutableInt(), convexPolygonsSize = new TIntArrayList())) != null) {
            BufferedReader regionFile = readerCreator.createReader(fileName);
            if (regionFile == null) {
                return null;
            }
            PlanarRegion loadedRegion = PlanarRegionFileTools.loadPlanarRegionVertices(regionFile, concaveHullSize.intValue(), convexPolygonsSize.toArray(), regionId.intValue(), origin, orientation);
            regionFile.close();
            if (loadedRegion != null) {
                planarRegions.add(loadedRegion);
                continue;
            }
            headerFile.close();
            return null;
        }
        headerFile.close();
        return new PlanarRegionsList(planarRegions);
    }

    private static void readSensorTransform(BufferedReader bufferedReader, Point3D sensorPositionToPack, AxisAngle sensorOrientationToPack) throws IOException {
        String line = bufferedReader.readLine();
        line = line.replaceAll("sensor position: ", "");
        line = line.replaceAll("sensor orientation: ", "");
        String[] values = line.split(", ");
        int i = 0;
        float xSensorPosition = Float.parseFloat(values[i++]);
        float ySensorPosition = Float.parseFloat(values[i++]);
        float zSensorPosition = Float.parseFloat(values[i++]);
        sensorPositionToPack.set((double)xSensorPosition, (double)ySensorPosition, (double)zSensorPosition);
        float xSensorOrientation = Float.parseFloat(values[i++]);
        float ySensorOrientation = Float.parseFloat(values[i++]);
        float zSensorOrientation = Float.parseFloat(values[i++]);
        float angleSensorOrientation = Float.parseFloat(values[i++]);
        sensorOrientationToPack.set((double)xSensorOrientation, (double)ySensorOrientation, (double)zSensorOrientation, (double)angleSensorOrientation);
    }

    private static String readHeaderLine(BufferedReader bufferedReader, Point3D originToPack, AxisAngle orientationToPack, MutableInt regionIdToPack, MutableInt concaveHullSizeToPack, TIntArrayList convexPolygonsSizeToPack) throws IOException {
        String line = bufferedReader.readLine();
        if (line == null) {
            return null;
        }
        String cvsSplitBy = ",";
        boolean version2 = line.contains("orientation: ");
        line = line.replaceAll("regionId: ", "");
        line = line.replaceAll("index: ", "");
        line = line.replaceAll("origin: ", "");
        line = line.replaceAll("normal: ", "");
        line = line.replaceAll("orientation: ", "");
        line = line.replaceAll("\\[", "");
        line = line.replaceAll("\\]", "");
        line = line.replaceAll("concave hull size: ", "");
        line = line.replaceAll("number of convex polygons: ", "");
        line = line.replaceAll(" ", "");
        String[] values = line.split(cvsSplitBy);
        int i = 0;
        regionIdToPack.setValue(Integer.parseInt(values[i++]));
        int regionIndex = Integer.parseInt(values[i++]);
        float xOrigin = Float.parseFloat(values[i++]);
        float yOrigin = Float.parseFloat(values[i++]);
        float zOrigin = Float.parseFloat(values[i++]);
        originToPack.set((double)xOrigin, (double)yOrigin, (double)zOrigin);
        if (version2) {
            double xOrientation = Double.parseDouble(values[i++]);
            double yOrientation = Double.parseDouble(values[i++]);
            double zOrientation = Double.parseDouble(values[i++]);
            double angleOrientation = Double.parseDouble(values[i++]);
            orientationToPack.set(xOrientation, yOrientation, zOrientation, angleOrientation);
        } else {
            float xNormal = Float.parseFloat(values[i++]);
            float yNormal = Float.parseFloat(values[i++]);
            float zNormal = Float.parseFloat(values[i++]);
            orientationToPack.set(EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)new Vector3D((double)xNormal, (double)yNormal, (double)zNormal)));
        }
        concaveHullSizeToPack.setValue(Integer.parseInt(values[i++]));
        int numberOfConvexPolygons = Integer.parseInt(values[i++]);
        for (int hullIndex = 0; hullIndex < numberOfConvexPolygons; ++hullIndex) {
            convexPolygonsSizeToPack.add(Integer.parseInt(values[i++]));
        }
        return "region" + regionIdToPack.toString() + "_" + regionIndex;
    }

    private static void writePlanarRegionsDataToStream(OutputStream ostream, PlanarRegionsList planarRegionData) throws IOException {
        OutputStreamWriter ow = new OutputStreamWriter(ostream);
        HashMap<String, Pair<PlanarRegion, Integer>> writeQueue = PlanarRegionFileTools.writePlanarRegionHeader(ow, planarRegionData);
        for (Map.Entry<String, Pair<PlanarRegion, Integer>> entry : writeQueue.entrySet()) {
            int regionIndex = (Integer)entry.getValue().getSecond();
            PlanarRegion region = (PlanarRegion)entry.getValue().getFirst();
            ow.write("*\nregion" + entry.getKey() + "\n");
            PlanarRegionFileTools.writePlanarRegionVertices(ow, region);
        }
        ow.flush();
    }

    private static void writePlanarRegionsData(Path folderPath, PlanarRegionsList planarRegionData) throws IOException {
        File header = new File(folderPath.toFile(), "header.txt");
        FileWriter headerWriter = new FileWriter(header);
        HashMap<String, Pair<PlanarRegion, Integer>> writeQueue = PlanarRegionFileTools.writePlanarRegionHeader(headerWriter, planarRegionData);
        headerWriter.close();
        for (Map.Entry<String, Pair<PlanarRegion, Integer>> entry : writeQueue.entrySet()) {
            int regionIndex = (Integer)entry.getValue().getSecond();
            PlanarRegion region = (PlanarRegion)entry.getValue().getFirst();
            File regionFile = new File(folderPath.toFile(), "region" + entry.getKey());
            FileWriter fileWriter = new FileWriter(regionFile);
            PlanarRegionFileTools.writePlanarRegionVertices(fileWriter, region);
            fileWriter.close();
        }
    }

    private static HashMap<String, Pair<PlanarRegion, Integer>> writePlanarRegionHeader(OutputStreamWriter fw, PlanarRegionsList planarRegionData) throws IOException {
        HashMap<String, Pair<PlanarRegion, Integer>> writeQueue = new HashMap<String, Pair<PlanarRegion, Integer>>();
        HashMap<Integer, MutableInt> regionIdToIndex = new HashMap<Integer, MutableInt>();
        for (PlanarRegion region : planarRegionData.getPlanarRegionsAsList()) {
            Point3D origin = new Point3D();
            region.getPointInRegion((Point3DBasics)origin);
            AxisAngle orientation = new AxisAngle();
            region.getTransformToWorld().getRotation().get((AxisAngleBasics)orientation);
            int numberOfConvexPolygons = region.getNumberOfConvexPolygons();
            int[] convexPolygonsSizes = new int[numberOfConvexPolygons];
            for (int i = 0; i < numberOfConvexPolygons; ++i) {
                convexPolygonsSizes[i] = region.getConvexPolygon(i).getNumberOfVertices();
            }
            int regionId = region.getRegionId();
            MutableInt regionIndex = regionIdToIndex.getOrDefault(regionId, new MutableInt(0));
            regionIdToIndex.put(regionId, regionIndex);
            regionIndex.increment();
            fw.write("regionId: " + Integer.toString(regionId));
            fw.write(", index: " + Integer.toString(regionIndex.getValue()));
            fw.write(", origin: " + origin.getX() + ", " + origin.getY() + ", " + origin.getZ());
            fw.write(", orientation: " + orientation.getX() + ", " + orientation.getY() + ", " + orientation.getZ() + ", " + orientation.getAngle());
            fw.write(", concave hull size: " + region.getConcaveHullSize());
            fw.write(", number of convex polygons: " + numberOfConvexPolygons + ", " + Arrays.toString(convexPolygonsSizes));
            fw.write("\n");
            writeQueue.put(region.getRegionId() + "_" + regionIndex, (Pair<PlanarRegion, Integer>)new Pair((Object)region, (Object)regionIndex.getValue()));
        }
        return writeQueue;
    }

    private static void writeFramePlanarRegionsDataToStream(OutputStream ostream, FramePlanarRegionsList framePlanarRegions) throws IOException {
        OutputStreamWriter ow = new OutputStreamWriter(ostream);
        HashMap<String, Pair<PlanarRegion, Integer>> writeQueue = PlanarRegionFileTools.writeFramePlanarRegionsHeader(ow, framePlanarRegions);
        for (Map.Entry<String, Pair<PlanarRegion, Integer>> entry : writeQueue.entrySet()) {
            int regionIndex = (Integer)entry.getValue().getSecond();
            PlanarRegion region = (PlanarRegion)entry.getValue().getFirst();
            ow.write("*\nregion" + entry.getKey() + "\n");
            PlanarRegionFileTools.writePlanarRegionVertices(ow, region);
        }
        ow.flush();
    }

    private static void writeFramePlanarRegionsData(Path folderPath, FramePlanarRegionsList framePlanarRegions) throws IOException {
        File header = new File(folderPath.toFile(), "header.txt");
        FileWriter headerWriter = new FileWriter(header);
        HashMap<String, Pair<PlanarRegion, Integer>> writeQueue = PlanarRegionFileTools.writeFramePlanarRegionsHeader(headerWriter, framePlanarRegions);
        headerWriter.close();
        for (Map.Entry<String, Pair<PlanarRegion, Integer>> entry : writeQueue.entrySet()) {
            int regionIndex = (Integer)entry.getValue().getSecond();
            PlanarRegion region = (PlanarRegion)entry.getValue().getFirst();
            File regionFile = new File(folderPath.toFile(), "region" + entry.getKey());
            FileWriter fileWriter = new FileWriter(regionFile);
            PlanarRegionFileTools.writePlanarRegionVertices(fileWriter, region);
            fileWriter.close();
        }
    }

    private static HashMap<String, Pair<PlanarRegion, Integer>> writeFramePlanarRegionsHeader(OutputStreamWriter fw, FramePlanarRegionsList framePlanarRegions) throws IOException {
        HashMap<String, Pair<PlanarRegion, Integer>> writeQueue = new HashMap<String, Pair<PlanarRegion, Integer>>();
        HashMap<Integer, MutableInt> regionIdToIndex = new HashMap<Integer, MutableInt>();
        RigidBodyTransform sensorToWorldTransform = framePlanarRegions.getSensorToWorldFrameTransform();
        AxisAngle sensorOrientation = new AxisAngle();
        sensorToWorldTransform.getRotation().get((AxisAngleBasics)sensorOrientation);
        fw.write("sensor position: " + sensorToWorldTransform.getTranslationX() + ", " + sensorToWorldTransform.getTranslationY() + ", " + sensorToWorldTransform.getTranslationZ());
        fw.write(", sensor orientation: " + sensorOrientation.getX() + ", " + sensorOrientation.getY() + ", " + sensorOrientation.getZ() + ", " + sensorOrientation.getAngle());
        fw.write("\n");
        for (PlanarRegion region : framePlanarRegions.getPlanarRegionsList().getPlanarRegionsAsList()) {
            Point3D origin = new Point3D();
            region.getPointInRegion((Point3DBasics)origin);
            AxisAngle orientation = new AxisAngle();
            region.getTransformToWorld().getRotation().get((AxisAngleBasics)orientation);
            int numberOfConvexPolygons = region.getNumberOfConvexPolygons();
            int[] convexPolygonsSizes = new int[numberOfConvexPolygons];
            for (int i = 0; i < numberOfConvexPolygons; ++i) {
                convexPolygonsSizes[i] = region.getConvexPolygon(i).getNumberOfVertices();
            }
            int regionId = region.getRegionId();
            MutableInt regionIndex = regionIdToIndex.getOrDefault(regionId, new MutableInt(0));
            regionIdToIndex.put(regionId, regionIndex);
            regionIndex.increment();
            fw.write("regionId: " + Integer.toString(regionId));
            fw.write(", index: " + Integer.toString(regionIndex.getValue()));
            fw.write(", origin: " + origin.getX() + ", " + origin.getY() + ", " + origin.getZ());
            fw.write(", orientation: " + orientation.getX() + ", " + orientation.getY() + ", " + orientation.getZ() + ", " + orientation.getAngle());
            fw.write(", concave hull size: " + region.getConcaveHullSize());
            fw.write(", number of convex polygons: " + numberOfConvexPolygons + ", " + Arrays.toString(convexPolygonsSizes));
            fw.write("\n");
            writeQueue.put(region.getRegionId() + "_" + regionIndex, (Pair<PlanarRegion, Integer>)new Pair((Object)region, (Object)regionIndex.getValue()));
        }
        return writeQueue;
    }

    private static void writePlanarRegionVertices(OutputStreamWriter fileWriter, PlanarRegion region) throws IOException {
        for (Point2DReadOnly point2DReadOnly : region.getConcaveHull()) {
            fileWriter.write(point2DReadOnly.getX() + ", " + point2DReadOnly.getY() + "\n");
        }
        for (int polygonIndex = 0; polygonIndex < region.getNumberOfConvexPolygons(); ++polygonIndex) {
            ConvexPolygon2D convexPolygon2D = region.getConvexPolygon(polygonIndex);
            for (int vertexIndex = 0; vertexIndex < convexPolygon2D.getNumberOfVertices(); ++vertexIndex) {
                Point2DReadOnly vertex = convexPolygon2D.getVertex(vertexIndex);
                fileWriter.write(vertex.getX() + ", " + vertex.getY() + "\n");
            }
        }
    }

    private static PlanarRegion loadPlanarRegionVertices(BufferedReader regionFile, int concaveHullSize, int[] convexPolygonsSize, int regionId, Point3D origin, AxisAngle orientation) {
        if (regionFile == null) {
            return null;
        }
        try {
            String line = "";
            String cvsSplitBy = ",";
            RigidBodyTransform transformToWorld = new RigidBodyTransform((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)origin);
            ArrayList<Point2D> loadedPoints = new ArrayList<Point2D>();
            while ((line = regionFile.readLine()) != null) {
                String[] coordsAsString = line.split(cvsSplitBy);
                float x = Float.parseFloat(coordsAsString[0]);
                float y = Float.parseFloat(coordsAsString[1]);
                loadedPoints.add(new Point2D((double)x, (double)y));
            }
            ArrayList<Point2D> concaveHullVertices = new ArrayList<Point2D>();
            for (int i = 0; i < concaveHullSize; ++i) {
                concaveHullVertices.add((Point2D)loadedPoints.remove(0));
            }
            ArrayList<ConvexPolygon2D> convexPolygons = new ArrayList<ConvexPolygon2D>();
            for (int polygonIndex = 0; polygonIndex < convexPolygonsSize.length; ++polygonIndex) {
                int convexPolygonSize = convexPolygonsSize[polygonIndex];
                ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
                for (int i = 0; i < convexPolygonSize; ++i) {
                    convexPolygon.addVertex((Point2DReadOnly)loadedPoints.remove(0));
                }
                convexPolygon.update();
                convexPolygons.add(convexPolygon);
            }
            PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformToWorld, concaveHullVertices, convexPolygons);
            planarRegion.setRegionId(regionId);
            return planarRegion;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static File fileFromClassPath(Class<?> loadingClass, Path path) {
        Object builder = "";
        for (int i = 0; i < path.getNameCount(); ++i) {
            builder = (String)builder + path.getName(i).toString();
            if (i >= path.getNameCount() - 1) continue;
            builder = (String)builder + "/";
        }
        URL resourceUrl = loadingClass.getClassLoader().getResource((String)builder);
        String resourcePath = resourceUrl.getPath();
        if (PlanarRegionFileTools.isWindows()) {
            resourcePath = resourcePath.substring(1, resourcePath.length());
        }
        Path newPath = Paths.get(resourcePath, new String[0]);
        return newPath.toFile();
    }

    public static boolean isWindows() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.contains("win");
    }

    public static List<String> listResourceDirectoryContents(Class<?> loadingClass, Path relativePath) {
        return PlanarRegionFileTools.listResourceDirectoryContents(loadingClass, relativePath.toString());
    }

    public static List<String> listResourceDirectoryContents(Class<?> loadingClass, String relativePath) {
        try {
            System.out.println("=================================================================");
            System.out.println(relativePath);
            return IOUtils.readLines((InputStream)loadingClass.getClassLoader().getResourceAsStream(relativePath), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static URL getResourceURL(String resourceName) {
        return Thread.currentThread().getContextClassLoader().getResource(resourceName);
    }

    public static File getResourceFile(String resourceName) {
        URL url = PlanarRegionFileTools.getResourceURL(resourceName);
        return new File(url.getFile());
    }

    private static interface FileCreator {
        public File createFile(String var1);
    }

    private static interface ReaderCreator {
        public BufferedReader createReader(String var1);
    }
}

