/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.time;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class YoStopwatch {
    private final YoDouble timeProviderYoVariable;
    private YoDouble yoLapStart;
    private YoLong yoLapCount;
    private YoDouble yoRecordedLapTotal;
    private YoBoolean yoSuspended;
    private YoDouble yoSuspendStart;
    private YoDouble yoResumedSuspensionTotal;
    private double lapStart;
    private long lapCount;
    private double recordedLapTotal;
    private boolean suspended;
    private double suspendStart;
    private double resumedSuspensionTotal;

    public YoStopwatch(String name, YoDouble timeYoVariable, YoRegistry registry) {
        this(timeYoVariable);
        this.yoLapStart = new YoDouble(name + "LapStart", registry);
        this.yoLapCount = new YoLong(name + "LapCount", registry);
        this.yoRecordedLapTotal = new YoDouble(name + "RecordedLapTotal", registry);
        this.yoSuspended = new YoBoolean(name + "Suspended", registry);
        this.yoSuspendStart = new YoDouble(name + "SuspendStart", registry);
        this.yoResumedSuspensionTotal = new YoDouble(name + "ResumedSuspensionTotal", registry);
        this.yoLapStart.setToNaN();
    }

    public YoStopwatch(YoDouble timeYoVariable) {
        this.timeProviderYoVariable = timeYoVariable;
        this.lapStart = Double.NaN;
    }

    public YoStopwatch start() {
        this.reset();
        return this;
    }

    public void resetLap() {
        if (this.yoLapStart == null) {
            this.lapStart = this.now();
        } else {
            this.yoLapStart.set(this.now());
        }
        this.resetSuspension();
    }

    public void reset() {
        if (this.yoLapStart == null) {
            this.lapStart = this.now();
            this.resetSuspension();
            this.lapCount = 0L;
            this.recordedLapTotal = 0.0;
        } else {
            this.yoLapStart.set(this.now());
            this.resetSuspension();
            this.yoLapCount.set(0L);
            this.yoRecordedLapTotal.set(0.0);
        }
    }

    public double lap() {
        double now = this.now();
        double lapDuration = this.lapElapsed(now);
        if (this.yoLapStart == null) {
            this.lapStart = now;
            this.resetSuspension();
            ++this.lapCount;
            this.recordedLapTotal += lapDuration;
        } else {
            this.yoLapStart.set(now);
            this.resetSuspension();
            this.yoLapCount.add(1L);
            this.yoRecordedLapTotal.add(lapDuration);
        }
        return lapDuration;
    }

    public double averageLap() {
        if (this.yoLapStart == null) {
            return this.recordedLapTotal / (double)this.lapCount;
        }
        return this.yoRecordedLapTotal.getDoubleValue() / (double)this.yoLapCount.getLongValue();
    }

    public double lapElapsed() {
        return this.lapElapsed(this.now());
    }

    public double totalElapsed() {
        if (this.yoLapStart == null) {
            return this.recordedLapTotal + this.lapElapsed(this.now());
        }
        return this.yoRecordedLapTotal.getDoubleValue() + this.lapElapsed(this.now());
    }

    public void suspend() {
        if (this.yoLapStart == null) {
            if (!this.suspended) {
                this.suspended = true;
                this.suspendStart = this.now();
            }
        } else if (!this.yoSuspended.getBooleanValue()) {
            this.yoSuspended.set(true);
            this.yoSuspendStart.set(this.now());
        }
    }

    public void resume() {
        if (this.yoLapStart == null) {
            if (this.suspended) {
                this.suspended = false;
                this.resumedSuspensionTotal += this.now() - this.suspendStart;
            }
        } else if (this.yoSuspended.getBooleanValue()) {
            this.yoSuspended.set(false);
            this.yoResumedSuspensionTotal.add(this.now() - this.yoSuspendStart.getDoubleValue());
        }
    }

    private double lapElapsed(double now) {
        if (this.yoLapStart == null) {
            double lapElapsed = now - this.lapStart;
            lapElapsed -= this.resumedSuspensionTotal;
            if (this.suspended) {
                lapElapsed -= now - this.suspendStart;
            }
            return lapElapsed;
        }
        double lapElapsed = now - this.yoLapStart.getDoubleValue();
        lapElapsed -= this.yoResumedSuspensionTotal.getDoubleValue();
        if (this.yoSuspended.getBooleanValue()) {
            lapElapsed -= now - this.yoSuspendStart.getDoubleValue();
        }
        return lapElapsed;
    }

    private double now() {
        return this.timeProviderYoVariable.getDoubleValue();
    }

    private void resetSuspension() {
        if (this.yoLapStart == null) {
            this.suspended = false;
            this.resumedSuspensionTotal = 0.0;
        } else {
            this.yoSuspended.set(false);
            this.yoResumedSuspensionTotal.set(0.0);
        }
    }
}

