/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.time;

import us.ihmc.commons.Conversions;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class CountdownTimer {
    private final YoDouble maxTime;
    private final YoDouble timeLeft;
    private final YoBoolean isTurnedOff;
    private double startTime;

    public CountdownTimer(String name, YoRegistry registry) {
        this(name, 0.0, registry);
    }

    public CountdownTimer(String name, double maxTime, YoRegistry registry) {
        this.maxTime = new YoDouble(name + "MaxTime", registry);
        this.maxTime.set(maxTime);
        this.timeLeft = new YoDouble(name + "TimeLeft", registry);
        this.timeLeft.set(0.0);
        this.isTurnedOff = new YoBoolean(name + "IsTurnedOff", registry);
        this.isTurnedOff.set(true);
        this.startTime = 0.0;
    }

    public void restartCountdown() {
        this.startCountdown(this.maxTime.getDoubleValue());
    }

    public void startCountdown(double time) {
        this.startTime = this.getCurrentAbsoluteTime();
        this.maxTime.set(time);
        this.isTurnedOff.set(false);
    }

    public boolean isRinging() {
        this.updateTimeLeft();
        return !this.isTurnedOff.getBooleanValue() && this.checkTimeLeft() <= 0.0;
    }

    public void stopRinging() {
        this.isTurnedOff.set(true);
    }

    public boolean isTurnedOff() {
        return this.isTurnedOff.getBooleanValue();
    }

    public double checkTimeLeft() {
        return this.timeLeft.getDoubleValue();
    }

    private void updateTimeLeft() {
        this.timeLeft.set(this.startTime + this.maxTime.getDoubleValue() - this.getCurrentAbsoluteTime());
    }

    private double getCurrentAbsoluteTime() {
        return Conversions.nanosecondsToSeconds((long)System.nanoTime());
    }
}

