/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.taskExecutor;

import java.util.List;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachineClock;
import us.ihmc.robotics.taskExecutor.NullState;
import us.ihmc.robotics.taskExecutor.ParallelState;
import us.ihmc.robotics.taskExecutor.StateExecutor;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.variable.YoDouble;

public class PipeLine<T> {
    private static final boolean DEBUG = false;
    private final StateExecutor masterTaskExecutor;
    private final NullState nullTask = new NullState();
    private final StateMachineClock clock;
    private final YoDouble yoTime;

    public PipeLine(YoDouble yoTime) {
        this.yoTime = yoTime;
        this.clock = StateMachineClock.clock((DoubleProvider)yoTime);
        this.masterTaskExecutor = new StateExecutor(this.clock);
    }

    @Deprecated
    public PipeLine() {
        this.yoTime = null;
        this.clock = StateMachineClock.dummyClock();
        this.masterTaskExecutor = new StateExecutor(this.clock);
    }

    public void requestNewStage() {
        this.submitSingleTaskStage(this.nullTask);
    }

    public void submitSingleTaskStage(State singleTaskStage) {
        this.masterTaskExecutor.submit(singleTaskStage);
    }

    public void submitTaskForPallelPipesStage(T executorKey, State taskToParallelize) {
        ParallelState<T> lastParallelTask;
        if (this.masterTaskExecutor.getLastTask() instanceof ParallelState) {
            lastParallelTask = (ParallelState<T>)this.masterTaskExecutor.getLastTask();
        } else {
            lastParallelTask = this.yoTime != null ? new ParallelState(this.yoTime) : new ParallelState<T>();
            this.submitSingleTaskStage(lastParallelTask);
        }
        lastParallelTask.submit(executorKey, taskToParallelize);
    }

    public void doControl() {
        this.masterTaskExecutor.doControl();
    }

    public void clearAll() {
        this.masterTaskExecutor.clear();
    }

    public void clearAllExceptCurrent() {
        this.masterTaskExecutor.clearAllExceptCurrent();
    }

    public void clear(T executorKey) {
        State currentStage = this.masterTaskExecutor.getCurrentTask();
        if (currentStage instanceof ParallelState) {
            ParallelState stageOfParallelTasks = (ParallelState)currentStage;
            stageOfParallelTasks.clear(executorKey);
        }
    }

    public void submitAll(List<State> tasks) {
        for (int i = 0; i < tasks.size(); ++i) {
            this.submitSingleTaskStage(tasks.get(i));
        }
    }

    public void submitAll(T executorKey, List<State> tasks) {
        for (int i = 0; i < tasks.size(); ++i) {
            this.submitTaskForPallelPipesStage(executorKey, tasks.get(i));
        }
    }

    public boolean isDone() {
        return this.masterTaskExecutor.isDone();
    }

    public State getCurrentStage() {
        return this.masterTaskExecutor.getCurrentTask();
    }
}

