/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.tree.JGraphTreeLayout;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JPanel;
import org.jgraph.JGraph;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.State;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.StateChangedListener;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.StateMachine;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.StateTransition;

@Deprecated
public class StateMachinesJPanel<E extends Enum<E>>
extends JPanel
implements StateChangedListener<E> {
    private static final long serialVersionUID = 2453853798153829891L;
    private final StateMachine<E> stateMachine;
    private boolean oldStateDiagram;
    private DefaultGraphCell[] stateCells;
    private JGraph graph;
    private int numberOfStates;
    private Enum<?> currentState = null;
    private int[] sourceArrows = new int[100];
    private int[] targetArrows = new int[100];
    private int sourceArrowIndex = 0;
    private int targetArrowIndex = 0;
    private int stateCellIndex = 0;
    private Point2D[] stateCenters;
    private Vector2D tempVector2d = new Vector2D();
    private Dimension dimension = new Dimension();
    static final BasicStroke wideStroke = new BasicStroke(3.0f);
    private boolean initiate;
    private double tempHeight = 0.0;
    private double tempWidth = 0.0;

    public StateMachinesJPanel(StateMachine<E> stateMachine) {
        this(stateMachine, false);
    }

    public StateMachinesJPanel(final StateMachine<E> stateMachine, boolean OldStateDiagram) {
        this.stateMachine = stateMachine;
        this.numberOfStates = stateMachine.states.size();
        this.oldStateDiagram = OldStateDiagram;
        this.currentState = stateMachine.getStateYoVariable().getEnumValue();
        if (!OldStateDiagram) {
            this.graph = new JGraph();
            this.initializeJPanel();
        }
        Thread repaintWhenStateChange = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (StateMachinesJPanel.this.currentState.name().equals(stateMachine.getStateYoVariable().getEnumValue().name())) continue;
                    StateMachinesJPanel.this.currentState = stateMachine.getStateYoVariable().getEnumValue();
                    StateMachinesJPanel.this.updateStateMachine();
                }
            }
        }, "IHMC-StateMachinesPanel");
        repaintWhenStateChange.start();
    }

    public void updateStateMachine() {
        Object currentState = this.stateMachine.getCurrentState();
        if (this.oldStateDiagram) {
            this.repaint();
        } else {
            int currentIndex = this.indexOfStateInStateCells((State<E>)currentState);
            GraphConstants.setBackground((Map)this.graph.getAttributes((Object)this.stateCells[currentIndex]), (Color)Color.RED);
            this.stateCells[currentIndex].setAttributes(this.graph.getAttributes((Object)this.stateCells[currentIndex]));
            for (int i = 0; i < this.stateCells.length; ++i) {
                if (i == currentIndex) continue;
                GraphConstants.setBackground((Map)this.graph.getAttributes((Object)this.stateCells[i]), (Color)Color.CYAN);
                this.stateCells[i].setAttributes(this.graph.getAttributes((Object)this.stateCells[i]));
            }
            this.graph.repaint();
            this.graph.refresh();
        }
    }

    @Override
    public void stateChanged(State<E> oldState, State<E> newState, double time) {
        if (this.oldStateDiagram) {
            this.repaint();
        } else {
            int newIndex = this.indexOfStateInStateCells(newState);
            int oldIndex = this.indexOfStateInStateCells(oldState);
            GraphConstants.setBackground((Map)this.graph.getAttributes((Object)this.stateCells[oldIndex]), (Color)Color.CYAN);
            GraphConstants.setBackground((Map)this.graph.getAttributes((Object)this.stateCells[newIndex]), (Color)Color.RED);
            this.stateCells[oldIndex].setAttributes(this.graph.getAttributes((Object)this.stateCells[oldIndex]));
            this.stateCells[newIndex].setAttributes(this.graph.getAttributes((Object)this.stateCells[newIndex]));
            this.graph.repaint();
            this.repaint();
            this.graph.refresh();
        }
    }

    private void createArrow(int source, int target) {
        if (!this.arrowAlreadyExist(source, target)) {
            Object[] arrowCell = new DefaultGraphCell[1];
            DefaultEdge edge = new DefaultEdge();
            edge.setSource((Object)this.stateCells[source].getChildAt(0));
            edge.setTarget((Object)this.stateCells[target].getChildAt(0));
            arrowCell[0] = edge;
            int arrow = 2;
            GraphConstants.setLineEnd((Map)edge.getAttributes(), (int)arrow);
            GraphConstants.setEndFill((Map)edge.getAttributes(), (boolean)true);
            this.graph.getGraphLayoutCache().insert(arrowCell);
            this.sourceArrows[this.sourceArrowIndex] = source;
            ++this.sourceArrowIndex;
            this.targetArrows[this.targetArrowIndex] = target;
            ++this.targetArrowIndex;
        }
    }

    private boolean arrowAlreadyExist(int source, int target) {
        for (int i = 0; i < this.sourceArrows.length; ++i) {
            if (this.sourceArrows[i] != source || this.targetArrows[i] != target) continue;
            return true;
        }
        return false;
    }

    private DefaultGraphCell createCell(String name, Point2D placement, int index) {
        this.stateCells[index] = new DefaultGraphCell((Object)new String(name));
        Font f = new Font("Arial", 0, 12);
        GraphConstants.setFont((Map)this.stateCells[index].getAttributes(), (Font)f);
        GraphConstants.setAutoSize((Map)this.stateCells[index].getAttributes(), (boolean)true);
        GraphConstants.setOpaque((Map)this.stateCells[index].getAttributes(), (boolean)true);
        Color color = this.colorStateCell((State)this.stateMachine.states.get(this.indexOfStateinStateMachine(name)));
        GraphConstants.setBackground((Map)this.stateCells[index].getAttributes(), (Color)color);
        GraphConstants.setBounds((Map)this.stateCells[index].getAttributes(), (Rectangle2D)new Rectangle2D.Double(placement.getX(), placement.getY(), 0.0, 0.0));
        this.stateCells[index].addPort();
        return this.stateCells[index];
    }

    private int indexOfStateinStateMachine(String state) {
        for (int i = 0; i < this.stateMachine.states.size(); ++i) {
            if (!((Enum)((State)this.stateMachine.states.get(i)).getStateEnum()).toString().equals(state)) continue;
            return i;
        }
        return -1;
    }

    private int indexOfStateInStateCells(State<E> state) {
        for (int i = 0; i < this.stateCells.length; ++i) {
            if (!this.stateCells[i].toString().equals(((Enum)state.getStateEnum()).toString())) continue;
            return i;
        }
        return -1;
    }

    private State<E> getParentState() {
        State parentState = null;
        int max = 0;
        boolean needParentForDiagram = false;
        for (int i = 0; i < this.numberOfStates; ++i) {
            State state = (State)this.stateMachine.states.get(i);
            if (state.getStateTransitions().size() == max) {
                needParentForDiagram = true;
            }
            if (state.getStateTransitions().size() <= max) continue;
            max = state.getStateTransitions().size();
            needParentForDiagram = false;
            parentState = state;
        }
        if (needParentForDiagram) {
            parentState = (State)this.stateMachine.states.get(0);
        }
        return parentState;
    }

    private boolean isStateEmpty(State<E> checkstate) {
        boolean isEmpty = true;
        for (int i = 0; i < this.stateMachine.states.size(); ++i) {
            State state = (State)this.stateMachine.states.get(i);
            StateTransition defaultNextStateTransition = state.getDefaultNextStateTransition();
            if (defaultNextStateTransition != null && defaultNextStateTransition.getNextStateEnum() == checkstate.getStateEnum()) {
                isEmpty = false;
            }
            for (int j = 0; j < state.getStateTransitions().size(); ++j) {
                if (state.getStateTransitions().get(j).getNextStateEnum() != checkstate.getStateEnum()) continue;
                isEmpty = false;
            }
        }
        return isEmpty;
    }

    private boolean doesCellAlreadyExist(String state) {
        for (int i = 0; i < this.stateCells.length; ++i) {
            if (this.stateCells[i] == null || !this.stateCells[i].toString().equals(state)) continue;
            return true;
        }
        return false;
    }

    private void createStateMachineDiagram(State<E> parent) {
        for (int i = 0; i < parent.getStateTransitions().size(); ++i) {
            String state = ((Enum)parent.getStateTransitions().get(i).getNextStateEnum()).toString();
            if (this.doesCellAlreadyExist(state)) continue;
            this.stateCells[this.stateCellIndex] = this.createCell(state, new Point2D(0.0, 0.0), this.stateCellIndex);
            this.createArrow(this.indexOfStateInStateCells(parent), this.stateCellIndex);
            ++this.stateCellIndex;
            if (((State)this.stateMachine.states.get(this.indexOfStateinStateMachine(state))).getStateTransitions().size() != 0) {
                this.createStateMachineDiagram((State)this.stateMachine.states.get(this.indexOfStateinStateMachine(state)));
                continue;
            }
            try {
                for (int j = this.indexOfStateinStateMachine(state) + 1; j < this.indexOfStateinStateMachine(((Enum)parent.getStateTransitions().get(i + 1).getNextStateEnum()).toString()); ++j) {
                    State checkState = (State)this.stateMachine.states.get(j);
                    if (this.doesCellAlreadyExist(((Enum)checkState.getStateEnum()).toString())) continue;
                    this.stateCells[this.stateCellIndex] = this.createCell(((Enum)checkState.getStateEnum()).toString(), new Point2D(0.0, 0.0), this.stateCellIndex);
                    this.createArrow(this.stateCellIndex - 1, this.stateCellIndex);
                    ++this.stateCellIndex;
                }
                continue;
            }
            catch (Exception noAdditionalStateTransitions) {
                for (int j = this.indexOfStateinStateMachine(state) + 1; j < this.stateCells.length; ++j) {
                    State checkState = (State)this.stateMachine.states.get(j);
                    if (this.doesCellAlreadyExist(((Enum)checkState.getStateEnum()).toString())) continue;
                    this.stateCells[this.stateCellIndex] = this.createCell(((Enum)checkState.getStateEnum()).toString(), new Point2D(0.0, 0.0), this.stateCellIndex);
                    this.createArrow(this.stateCellIndex - 1, this.stateCellIndex);
                    ++this.stateCellIndex;
                }
            }
        }
    }

    private void createArrowsForStateTransitions() {
        for (int i = 0; i < this.stateCells.length; ++i) {
            State state = (State)this.stateMachine.states.get(this.indexOfStateinStateMachine(this.stateCells[i].toString()));
            for (int z = 0; z < state.getStateTransitions().size(); ++z) {
                int source = this.indexOfStateInStateCells(state);
                int target = this.indexOfStateInStateCells((State)this.stateMachine.states.get(this.indexOfStateinStateMachine(((Enum)state.getStateTransitions().get(z).getNextStateEnum()).toString())));
                this.createArrow(source, target);
            }
        }
    }

    private void createDefaultArrows() {
        for (int i = 0; i < this.stateMachine.states.size(); ++i) {
            State state = (State)this.stateMachine.states.get(i);
            StateTransition defaultNextStateTransition = state.getDefaultNextStateTransition();
            if (defaultNextStateTransition == null) continue;
            int source = this.indexOfStateInStateCells(state);
            int target = this.indexOfStateInStateCells((State)this.stateMachine.states.get(this.indexOfStateinStateMachine(((Enum)defaultNextStateTransition.getNextStateEnum()).toString())));
            this.createArrow(source, target);
        }
    }

    private Color colorStateCell(State<E> state) {
        Object currentState = this.stateMachine.getCurrentState();
        if (state == currentState) {
            return Color.RED;
        }
        return Color.CYAN;
    }

    private void initializeJPanel() {
        this.initiate = true;
        this.graph.setGraphLayoutCache(new GraphLayoutCache((GraphModel)new DefaultGraphModel(), (CellViewFactory)new DefaultCellViewFactory(), true));
        this.graph.setEditable(false);
        for (int i = 0; i < this.numberOfStates; ++i) {
            this.isStateEmpty((State)this.stateMachine.states.get(i));
        }
        this.stateCells = new DefaultGraphCell[this.numberOfStates];
        State<E> parent = this.getParentState();
        this.stateCells[this.stateCellIndex] = this.createCell(((Enum)parent.getStateEnum()).toString(), new Point2D(0.0, 0.0), this.stateCellIndex);
        ++this.stateCellIndex;
        this.createStateMachineDiagram(parent);
        this.graph.getGraphLayoutCache().insert((Object[])this.stateCells);
        JGraphFacade facade = new JGraphFacade(this.graph.getGraphLayoutCache());
        facade.setEdgePromotion(false);
        JGraphTreeLayout layout = new JGraphTreeLayout();
        layout.run(facade);
        Map map = facade.createNestedMap(true, true);
        this.graph.getGraphLayoutCache().edit(map);
        this.createDefaultArrows();
        this.createArrowsForStateTransitions();
    }

    private void OldStateMachineDiagram(Graphics g, double width, double height) {
        State state;
        int i;
        if (this.stateCenters == null) {
            this.stateCenters = new Point2D[this.numberOfStates];
            for (int i2 = 0; i2 < this.numberOfStates; ++i2) {
                this.stateCenters[i2] = new Point2D();
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(wideStroke);
        double Ry = 0.25 * height;
        double Rx = 0.25 * width;
        double circumference = StateMachinesJPanel.approximateElipseCircumference(Rx, Ry);
        int circleRadiusBasedOnSpacing = (int)(circumference / (2.5 * (double)this.numberOfStates));
        int circleRadiusBasedOnPanelSize = (int)(0.9 * Math.min(Rx, Ry));
        int circleRadius = Math.min(circleRadiusBasedOnSpacing, circleRadiusBasedOnPanelSize);
        Object currentState = this.stateMachine.getCurrentState();
        for (i = 0; i < this.numberOfStates; ++i) {
            state = (State)this.stateMachine.states.get(i);
            if (state == currentState) {
                g.setColor(Color.RED);
            } else {
                g2.setColor(Color.BLACK);
            }
            double angle = Math.PI * 2 * (double)i / (double)this.numberOfStates;
            this.stateCenters[i].setX(Rx * Math.cos(angle) + width / 2.0);
            this.stateCenters[i].setY(Ry * Math.sin(angle) + height / 2.0);
            g2.draw(new Ellipse2D.Double(this.stateCenters[i].getX() - (double)circleRadius, this.stateCenters[i].getY() - (double)circleRadius, circleRadius * 2, circleRadius * 2));
            String stateString = ((Enum)state.getStateEnum()).toString();
            g2.drawString(((Enum)state.getStateEnum()).toString(), (int)this.stateCenters[i].getX() - 8 * stateString.length() / 2, (int)this.stateCenters[i].getY());
        }
        g2.setColor(Color.BLACK);
        for (i = 0; i < this.numberOfStates; ++i) {
            state = (State)this.stateMachine.states.get(i);
            ArrayList stateTransitions = state.getStateTransitions();
            for (StateTransition stateTransition : stateTransitions) {
                Object nextState = this.stateMachine.getState(stateTransition.getNextStateEnum());
                if (nextState == null) {
                    System.err.println("Error. StateMachine doesn't include state with enum " + stateTransition.getNextStateEnum());
                    return;
                }
                int nextIndex = this.stateMachine.states.indexOf(nextState);
                if (nextIndex >= 0) {
                    this.tempVector2d.sub((Tuple2DReadOnly)this.stateCenters[nextIndex], (Tuple2DReadOnly)this.stateCenters[i]);
                    this.tempVector2d.normalize();
                    this.tempVector2d.scale((double)circleRadius);
                    g2.draw(new Line2D.Double(this.stateCenters[i].getX() + this.tempVector2d.getX(), this.stateCenters[i].getY() + this.tempVector2d.getY(), this.stateCenters[nextIndex].getX() - this.tempVector2d.getX(), this.stateCenters[nextIndex].getY() - this.tempVector2d.getY()));
                    continue;
                }
                System.err.println("Error. StateMachine doesn't include state " + nextState);
            }
        }
    }

    private void reScalingStateMachine(double width, double height) {
        if (this.initiate) {
            this.tempWidth = width;
            this.tempHeight = height;
            this.initiate = false;
        }
        if (this.tempWidth > width) {
            this.graph.setScale(this.graph.getScale() + (width - this.tempWidth) / 3000.0);
            this.tempWidth = width;
        }
        if (this.tempWidth < width) {
            this.graph.setScale(this.graph.getScale() + (width - this.tempWidth) / 3000.0);
            this.tempWidth = width;
        }
        if (this.tempHeight > height) {
            this.graph.setScale(this.graph.getScale() - (this.tempHeight - height) / 3000.0);
            this.tempHeight = height;
        }
        if (this.tempHeight < height) {
            this.graph.setScale(this.graph.getScale() + (height - this.tempHeight) / 3000.0);
            this.tempHeight = height;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.getSize(this.dimension);
        double width = this.dimension.getWidth();
        double height = this.dimension.getHeight();
        if (this.oldStateDiagram) {
            this.OldStateMachineDiagram(g, width, height);
        } else {
            this.graph.setBounds(0, 0, (int)width, (int)height);
            this.graph.setAlignmentX(0.5f);
            this.reScalingStateMachine(width, height);
            this.add((Component)this.graph);
        }
    }

    private static double approximateElipseCircumference(double a, double b) {
        double x = (a - b) / (a + b);
        return Math.PI * (a + b) * (1.0 + 3.0 * x * x / (10.0 + Math.sqrt(4.0 - 3.0 * x * x)));
    }
}

