/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.factories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateChangedListener;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.core.StateMachineClock;
import us.ihmc.robotics.stateMachine.core.StateTransition;
import us.ihmc.robotics.stateMachine.core.StateTransitionCondition;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;

public class StateMachineFactory<K extends Enum<K>, S extends State> {
    private String namePrefix = "stateMachine";
    private YoRegistry registry;
    protected final Map<K, S> states;
    private final Map<K, StateTransition<K>> stateTransitions;
    private final List<StateChangedListener<K>> stateChangedListeners = new ArrayList<StateChangedListener<K>>();
    private StateMachineClock clock = StateMachineClock.dummyClock();
    private final Class<K> keyType;

    public StateMachineFactory(Class<K> keyType) {
        this.keyType = keyType;
        this.states = new EnumMap<K, S>(keyType);
        this.stateTransitions = new EnumMap<K, StateTransition<K>>(keyType);
    }

    public StateMachineFactory<K, S> setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
        return this;
    }

    public StateMachineFactory<K, S> setRegistry(YoRegistry registry) {
        this.registry = registry;
        return this;
    }

    public StateMachineFactory<K, S> buildClock(DoubleProvider timeProvider) {
        this.clock = StateMachineClock.clock(timeProvider);
        return this;
    }

    public StateMachineFactory<K, S> buildYoClock(DoubleProvider timeProvider) {
        if (this.namePrefix == null || this.registry == null) {
            throw new RuntimeException("The namePrefix and registry fields have to be set in order to create yo-variables. namePrefix:" + this.namePrefix + " registry:" + this.registry);
        }
        this.clock = StateMachineClock.yoClock(timeProvider, this.namePrefix, this.registry);
        return this;
    }

    public StateMachineFactory<K, S> addState(K key, S state) {
        State oldState = (State)this.states.put(key, state);
        if (oldState != null) {
            LogTools.warn((String)("The state " + oldState.getClass().getSimpleName() + " at the key " + key + " has been replaced with " + state.getClass().getSimpleName()));
        }
        return this;
    }

    public StateMachineFactory<K, S> addStateAndDoneTransition(K key, S state, K nextStateKey) {
        this.addState(key, state);
        this.addDoneTransition(key, nextStateKey);
        return this;
    }

    public boolean isStateRegistered(K stateKey) {
        return this.states.containsKey(stateKey);
    }

    public Set<K> getRegisteredStateKeys() {
        return this.states.keySet();
    }

    public Collection<S> getRegisteredStates() {
        return this.states.values();
    }

    public StateMachineFactory<K, S> addDoneTransition(K from, K to) {
        return this.addTransition(from, to, ((State)this.states.get(from))::isDone);
    }

    public StateMachineFactory<K, S> addRequestedTransition(K from, YoEnum<K> requestedState) {
        return this.addRequestedTransition(from, requestedState, false);
    }

    public StateMachineFactory<K, S> addRequestedTransition(K from, K to, YoEnum<K> requestedState) {
        return this.addRequestedTransition(from, to, requestedState, false);
    }

    public StateMachineFactory<K, S> addRequestedTransition(K from, YoEnum<K> requestedState, boolean waitUntilDone) {
        for (Enum to : this.getRegisteredStateKeys()) {
            if (to == from) continue;
            this.addRequestedTransition(from, to, requestedState, waitUntilDone);
        }
        return this;
    }

    public StateMachineFactory<K, S> addRequestedTransition(K from, K to, YoEnum<K> requestedState, final boolean waitUntilDone) {
        return this.addTransition(from, to, new StateTransitionCondition(){
            final /* synthetic */ Enum val$from;
            final /* synthetic */ Enum val$to;
            final /* synthetic */ YoEnum val$requestedState;
            {
                this.val$from = enum_;
                this.val$to = enum_2;
                this.val$requestedState = yoEnum;
            }

            @Override
            public boolean testCondition(double timeInCurrentState) {
                boolean ready;
                boolean bl = ready = !waitUntilDone || ((State)StateMachineFactory.this.states.get(this.val$from)).isDone(timeInCurrentState);
                if (this.val$to == this.val$requestedState.getEnumValue() && ready) {
                    this.val$requestedState.set(null);
                    return true;
                }
                return false;
            }
        });
    }

    public StateMachineFactory<K, S> addTimeBasedTransition(K from, K to, double durationBeforeTransition) {
        return this.addTransition(from, to, (double timeInCurrentState) -> durationBeforeTransition <= timeInCurrentState);
    }

    public StateMachineFactory<K, S> addTimeBasedTransition(K from, K to, DoubleProvider durationBeforeTransition) {
        return this.addTransition(from, to, (double timeInCurrentState) -> durationBeforeTransition.getValue() <= timeInCurrentState);
    }

    public StateMachineFactory<K, S> addImmediateTransition(K from, K to) {
        return this.addTransition(from, to, (double timeInCurrentState) -> true);
    }

    public StateMachineFactory<K, S> addTransition(Iterable<? extends K> froms, K to, StateTransitionCondition condition) {
        froms.forEach(from -> this.addTransition(from, to, condition));
        return this;
    }

    public StateMachineFactory<K, S> addTransition(K from, K to, StateTransitionCondition condition) {
        StateTransition<K> stateTransition = this.stateTransitions.get(from);
        if (stateTransition == null) {
            stateTransition = new StateTransition<K>(this.keyType);
            this.stateTransitions.put(from, stateTransition);
        }
        stateTransition.addCondition(to, condition);
        return this;
    }

    public StateMachineFactory<K, S> addTransition(K from, StateTransition<K> stateTransition) {
        StateTransition<K> thisStateTransition = this.stateTransitions.get(from);
        if (thisStateTransition == null) {
            thisStateTransition = new StateTransition<K>(this.keyType);
            this.stateTransitions.put(from, thisStateTransition);
        }
        thisStateTransition.completeWith(stateTransition);
        return this;
    }

    public StateMachineFactory<K, S> addStateChangedListener(StateChangedListener<K> stateChangeListener) {
        this.stateChangedListeners.add(stateChangeListener);
        return this;
    }

    public StateMachine<K, S> build(K initialStateKey) {
        return new StateMachine<K, S>(initialStateKey, this.states, this.stateTransitions, this.stateChangedListeners, this.clock, this.namePrefix, this.registry);
    }
}

