/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SpecializedOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.algorithms.CompositeRigidBodyMassMatrixCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.screwTheory.DynamicallyConsistentNullspaceCalculator;

public class OriginalDynamicallyConsistentNullspaceCalculator
implements DynamicallyConsistentNullspaceCalculator {
    private final FloatingJointBasics rootJoint;
    private final JointBasics[] jointsInOrder;
    private final Map<RigidBodyBasics, DMatrixRMaj> constrainedBodiesAndSelectionMatrices = new LinkedHashMap<RigidBodyBasics, DMatrixRMaj>();
    private final List<JointBasics> actuatedJoints = new ArrayList<JointBasics>();
    private final Map<RigidBodyBasics, List<JointBasics>> supportingBodyToJointPathMap = new LinkedHashMap<RigidBodyBasics, List<JointBasics>>();
    private final CompositeRigidBodyMassMatrixCalculator massMatrixCalculator;
    private final boolean computeSNsBar;
    private final LinearSolverDense<DMatrixRMaj> massMatrixSolver;
    private final LinearSolverDense<DMatrixRMaj> lambdaSolver;
    private final LinearSolverDense<DMatrixRMaj> pseudoInverseSolver;
    private final DMatrixRMaj S = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj Js = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj AInverse = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj AInverseJSTranspose = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj LambdasInverse = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj Lambdas = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj JsBar = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj Ns = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj SNs = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj AInverseSNsTranspose = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj PhiStar = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj PhiStarInverse = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj SNsBar = new DMatrixRMaj(1, 1);
    private final Twist tempTwist = new Twist();
    private final DMatrixRMaj tempTwistMatrix = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj tempJacobianPart = new DMatrixRMaj(1, 1);
    private final int nDegreesOfFreedom;
    private int nConstraints;

    public OriginalDynamicallyConsistentNullspaceCalculator(FloatingJointBasics rootJoint, boolean computeSNsBar) {
        this.rootJoint = rootJoint;
        this.massMatrixCalculator = new CompositeRigidBodyMassMatrixCalculator((RigidBodyReadOnly)rootJoint.getSuccessor());
        this.jointsInOrder = this.massMatrixCalculator.getInput().getJointMatrixIndexProvider().getIndexedJointsInOrder().toArray(new JointBasics[0]);
        this.nDegreesOfFreedom = MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])this.jointsInOrder);
        this.massMatrixSolver = LinearSolverFactory_DDRM.symmPosDef((int)this.nDegreesOfFreedom);
        this.lambdaSolver = LinearSolverFactory_DDRM.symmPosDef((int)this.nDegreesOfFreedom);
        this.pseudoInverseSolver = LinearSolverFactory_DDRM.pseudoInverse((boolean)true);
        this.computeSNsBar = computeSNsBar;
    }

    @Override
    public void reset() {
        this.nConstraints = 0;
        this.constrainedBodiesAndSelectionMatrices.clear();
        this.actuatedJoints.clear();
    }

    @Override
    public void addConstraint(RigidBodyBasics body, DMatrixRMaj selectionMatrix) {
        this.constrainedBodiesAndSelectionMatrices.put(body, selectionMatrix);
        this.nConstraints += selectionMatrix.getNumRows();
        JointBasics[] jointPath = MultiBodySystemTools.createJointPath((RigidBodyBasics)this.rootJoint.getPredecessor(), (RigidBodyBasics)body);
        this.supportingBodyToJointPathMap.put(body, Arrays.asList(jointPath));
    }

    @Override
    public void addActuatedJoint(JointBasics joint) {
        this.actuatedJoints.add(joint);
    }

    private static void computeS(DMatrixRMaj S, JointBasics[] jointsInOrder, Collection<JointBasics> actuatedJoints) {
        S.zero();
        int rowStart = 0;
        int columnStart = 0;
        for (JointBasics inverseDynamicsJoint : jointsInOrder) {
            int degreesOfFreedom = inverseDynamicsJoint.getDegreesOfFreedom();
            if (actuatedJoints.contains(inverseDynamicsJoint)) {
                DMatrixRMaj identity = new DMatrixRMaj(degreesOfFreedom, degreesOfFreedom);
                CommonOps_DDRM.setIdentity((DMatrix1Row)identity);
                CommonOps_DDRM.insert((DMatrix)identity, (DMatrix)S, (int)rowStart, (int)columnStart);
                rowStart += degreesOfFreedom;
            }
            columnStart += degreesOfFreedom;
        }
    }

    @Override
    public void compute() {
        this.resizeMatrices();
        OriginalDynamicallyConsistentNullspaceCalculator.computeS(this.S, this.jointsInOrder, this.actuatedJoints);
        this.computeJs(this.Js, this.supportingBodyToJointPathMap, this.constrainedBodiesAndSelectionMatrices);
        this.massMatrixCalculator.reset();
        this.massMatrixSolver.setA((Matrix)this.massMatrixCalculator.getMassMatrix());
        this.massMatrixSolver.invert((Matrix)this.AInverse);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.AInverse, (DMatrix1Row)this.Js, (DMatrix1Row)this.AInverseJSTranspose);
        CommonOps_DDRM.mult((DMatrix1Row)this.Js, (DMatrix1Row)this.AInverseJSTranspose, (DMatrix1Row)this.LambdasInverse);
        this.lambdaSolver.setA((Matrix)this.LambdasInverse);
        this.lambdaSolver.invert((Matrix)this.Lambdas);
        CommonOps_DDRM.mult((DMatrix1Row)this.AInverseJSTranspose, (DMatrix1Row)this.Lambdas, (DMatrix1Row)this.JsBar);
        CommonOps_DDRM.mult((DMatrix1Row)this.JsBar, (DMatrix1Row)this.Js, (DMatrix1Row)this.Ns);
        CommonOps_DDRM.changeSign((DMatrixD1)this.Ns);
        SpecializedOps_DDRM.addIdentity((DMatrix1Row)this.Ns, (DMatrix1Row)this.Ns, (double)1.0);
        if (this.computeSNsBar) {
            CommonOps_DDRM.mult((DMatrix1Row)this.S, (DMatrix1Row)this.Ns, (DMatrix1Row)this.SNs);
            CommonOps_DDRM.multTransB((DMatrix1Row)this.AInverse, (DMatrix1Row)this.SNs, (DMatrix1Row)this.AInverseSNsTranspose);
            CommonOps_DDRM.mult((DMatrix1Row)this.SNs, (DMatrix1Row)this.AInverseSNsTranspose, (DMatrix1Row)this.PhiStar);
            this.pseudoInverseSolver.setA((Matrix)this.PhiStar);
            this.pseudoInverseSolver.invert((Matrix)this.PhiStarInverse);
            CommonOps_DDRM.mult((DMatrix1Row)this.AInverseSNsTranspose, (DMatrix1Row)this.PhiStarInverse, (DMatrix1Row)this.SNsBar);
        }
    }

    private void resizeMatrices() {
        int nActuatedDegreesOfFreedom = MultiBodySystemTools.computeDegreesOfFreedom(this.actuatedJoints);
        this.S.reshape(nActuatedDegreesOfFreedom, this.nDegreesOfFreedom);
        this.Js.reshape(this.nConstraints, this.nDegreesOfFreedom);
        this.AInverse.reshape(this.nDegreesOfFreedom, this.nDegreesOfFreedom);
        this.AInverseJSTranspose.reshape(this.AInverse.getNumRows(), this.Js.getNumRows());
        this.LambdasInverse.reshape(this.Js.getNumRows(), this.AInverseJSTranspose.getNumCols());
        this.Lambdas.reshape(this.LambdasInverse.getNumRows(), this.LambdasInverse.getNumCols());
        this.JsBar.reshape(this.AInverseJSTranspose.getNumRows(), this.LambdasInverse.getNumCols());
        this.Ns.reshape(this.nDegreesOfFreedom, this.nDegreesOfFreedom);
        this.SNs.reshape(this.S.getNumRows(), this.Ns.getNumCols());
        this.AInverseSNsTranspose.reshape(this.AInverse.getNumRows(), this.SNs.getNumRows());
        this.PhiStar.reshape(this.SNs.getNumRows(), this.AInverseSNsTranspose.getNumCols());
        this.PhiStarInverse.reshape(this.PhiStar.getNumRows(), this.PhiStar.getNumCols());
        this.SNsBar.reshape(this.nDegreesOfFreedom, nActuatedDegreesOfFreedom);
    }

    @Override
    public DMatrixRMaj getDynamicallyConsistentNullspace() {
        return this.Ns;
    }

    @Override
    public DMatrixRMaj getSNsBar() {
        if (!this.computeSNsBar) {
            throw new RuntimeException("SNsBar not computed");
        }
        return this.SNsBar;
    }

    private void computeJs(DMatrixRMaj Js, Map<RigidBodyBasics, List<JointBasics>> supportJacobians, Map<RigidBodyBasics, DMatrixRMaj> constrainedBodiesAndSelectionMatrices) {
        Js.zero();
        int rowStartNumber = 0;
        for (RigidBodyBasics rigidBody : supportJacobians.keySet()) {
            List<JointBasics> supportingJoints = supportJacobians.get(rigidBody);
            DMatrixRMaj selectionMatrix = constrainedBodiesAndSelectionMatrices.get(rigidBody);
            int columnStartNumber = 0;
            for (JointBasics inverseDynamicsJoint : this.jointsInOrder) {
                if (supportingJoints.contains(inverseDynamicsJoint)) {
                    for (int dofIndex = 0; dofIndex < inverseDynamicsJoint.getDegreesOfFreedom(); ++dofIndex) {
                        this.tempTwist.setIncludingFrame((SpatialMotionReadOnly)inverseDynamicsJoint.getUnitTwists().get(dofIndex));
                        this.tempTwist.changeFrame((ReferenceFrame)this.rootJoint.getFrameAfterJoint());
                        this.tempTwist.get(0, (DMatrix)this.tempTwistMatrix);
                        this.tempJacobianPart.reshape(selectionMatrix.getNumRows(), 1);
                        CommonOps_DDRM.mult((DMatrix1Row)selectionMatrix, (DMatrix1Row)this.tempTwistMatrix, (DMatrix1Row)this.tempJacobianPart);
                        CommonOps_DDRM.insert((DMatrix)this.tempJacobianPart, (DMatrix)Js, (int)rowStartNumber, (int)columnStartNumber++);
                    }
                    continue;
                }
                columnStartNumber += inverseDynamicsJoint.getDegreesOfFreedom();
            }
            rowStartNumber += selectionMatrix.getNumRows();
        }
    }
}

