/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class FloatingBaseRigidBodyDynamicsCalculator {
    private static final int large = 1000;
    private static final double tolerance = 1.0E-4;
    private static final LinearSolverDense<DMatrixRMaj> pseudoInverseSolver = LinearSolverFactory_DDRM.pseudoInverse((boolean)true);
    private final DMatrixRMaj matrixTranspose = new DMatrixRMaj(1000, 1000);
    private final DMatrixRMaj localVector = new DMatrixRMaj(1000, 1);

    public void computeQddotGivenRho(DMatrixRMaj floatingBaseMassMatrix, DMatrixRMaj floatingBaseCoriolisMatrix, DMatrixRMaj floatingBaseContactForceJacobianMatrix, DMatrixRMaj qddotToPack, DMatrixRMaj rho) {
        this.computeJacobianTranspose(floatingBaseContactForceJacobianMatrix, this.matrixTranspose);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)floatingBaseCoriolisMatrix);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.matrixTranspose, (DMatrix1Row)rho, (DMatrix1Row)floatingBaseCoriolisMatrix);
        pseudoInverseSolver.setA((Matrix)floatingBaseMassMatrix);
        pseudoInverseSolver.solve((Matrix)floatingBaseCoriolisMatrix, (Matrix)qddotToPack);
    }

    public void computeRhoGivenQddot(DMatrixRMaj floatingBaseMassMatrix, DMatrixRMaj floatingBaseCoriolisMatrix, DMatrixRMaj floatingBaseContactForceJacobianMatrix, DMatrixRMaj qddot, DMatrixRMaj rhoToPack) {
        this.computeJacobianTranspose(floatingBaseContactForceJacobianMatrix, this.matrixTranspose);
        CommonOps_DDRM.multAdd((DMatrix1Row)floatingBaseMassMatrix, (DMatrix1Row)qddot, (DMatrix1Row)floatingBaseCoriolisMatrix);
        pseudoInverseSolver.setA((Matrix)this.matrixTranspose);
        pseudoInverseSolver.solve((Matrix)floatingBaseCoriolisMatrix, (Matrix)rhoToPack);
    }

    public void computeTauGivenRhoAndQddot(DMatrixRMaj bodyMassMatrix, DMatrixRMaj bodyCoriolisMatrix, DMatrixRMaj bodyContactForceJacobianMatrix, DMatrixRMaj qddot, DMatrixRMaj rho, DMatrixRMaj tauToPack) {
        this.computeJacobianTranspose(bodyContactForceJacobianMatrix, this.matrixTranspose);
        CommonOps_DDRM.mult((DMatrix1Row)bodyMassMatrix, (DMatrix1Row)qddot, (DMatrix1Row)tauToPack);
        CommonOps_DDRM.multAdd((double)-1.0, (DMatrix1Row)this.matrixTranspose, (DMatrix1Row)rho, (DMatrix1Row)tauToPack);
        CommonOps_DDRM.addEquals((DMatrixD1)tauToPack, (DMatrixD1)bodyCoriolisMatrix);
    }

    public void computeTauGivenRho(DMatrixRMaj floatingBaseMassMatrix, DMatrixRMaj floatingBaseCoriolisMatrix, DMatrixRMaj floatingBaseContactForceJacobianMatrix, DMatrixRMaj bodyMassMatrix, DMatrixRMaj bodyCoriolisMatrix, DMatrixRMaj bodyContactForceJacobianMatrix, DMatrixRMaj rho, DMatrixRMaj tauToPack) {
        this.computeJacobianTranspose(bodyContactForceJacobianMatrix, this.matrixTranspose);
        this.localVector.reshape(bodyMassMatrix.getNumCols(), 1);
        this.computeQddotGivenRho(floatingBaseMassMatrix, floatingBaseCoriolisMatrix, floatingBaseContactForceJacobianMatrix, this.localVector, rho);
        this.computeTauGivenRhoAndQddot(bodyMassMatrix, bodyCoriolisMatrix, bodyContactForceJacobianMatrix, this.localVector, rho, tauToPack);
    }

    public void computeTauGivenQddot(DMatrixRMaj floatingBaseMassMatrix, DMatrixRMaj floatingBaseCoriolisMatrix, DMatrixRMaj floatingBaseContactForceJacobianMatrix, DMatrixRMaj bodyMassMatrix, DMatrixRMaj bodyCoriolisMatrix, DMatrixRMaj bodyContactForceJacobianMatrix, DMatrixRMaj qddot, DMatrixRMaj tauToPack) {
        this.computeJacobianTranspose(bodyContactForceJacobianMatrix, this.matrixTranspose);
        this.localVector.reshape(bodyContactForceJacobianMatrix.getNumRows(), 1);
        this.computeRhoGivenQddot(floatingBaseMassMatrix, floatingBaseCoriolisMatrix, floatingBaseContactForceJacobianMatrix, qddot, this.localVector);
        this.computeTauGivenRhoAndQddot(bodyMassMatrix, bodyCoriolisMatrix, bodyContactForceJacobianMatrix, qddot, this.localVector, tauToPack);
    }

    public boolean areFloatingBaseRigidBodyDynamicsSatisfied(DMatrixRMaj floatingBaseMassMatrix, DMatrixRMaj floatingBaseCoriolisMatrix, DMatrixRMaj floatingBaseContactForceJacobianMatrix, DMatrixRMaj bodyMassMatrix, DMatrixRMaj bodyCoriolisMatrix, DMatrixRMaj bodyContactForceJacobianMatrix, DMatrixRMaj qddot, DMatrixRMaj tau, DMatrixRMaj rho) {
        if (!this.areFloatingBaseDynamicsSatisfied(floatingBaseMassMatrix, floatingBaseCoriolisMatrix, floatingBaseContactForceJacobianMatrix, qddot, rho)) {
            return false;
        }
        return this.areRigidBodyDynamicsSatisfied(bodyMassMatrix, bodyCoriolisMatrix, bodyContactForceJacobianMatrix, qddot, tau, rho);
    }

    public boolean areFloatingBaseDynamicsSatisfied(DMatrixRMaj floatingBaseMassMatrix, DMatrixRMaj floatingBaseCoriolisMatrix, DMatrixRMaj floatingBaseContactForceJacobianMatrix, DMatrixRMaj qddot, DMatrixRMaj rho) {
        this.computeJacobianTranspose(floatingBaseContactForceJacobianMatrix, this.matrixTranspose);
        CommonOps_DDRM.multAdd((DMatrix1Row)floatingBaseMassMatrix, (DMatrix1Row)qddot, (DMatrix1Row)floatingBaseCoriolisMatrix);
        CommonOps_DDRM.multAdd((double)-1.0, (DMatrix1Row)this.matrixTranspose, (DMatrix1Row)rho, (DMatrix1Row)floatingBaseCoriolisMatrix);
        return FloatingBaseRigidBodyDynamicsCalculator.equalsZero(floatingBaseCoriolisMatrix, 1.0E-4);
    }

    public boolean areRigidBodyDynamicsSatisfied(DMatrixRMaj bodyMassMatrix, DMatrixRMaj bodyCoriolisMatrix, DMatrixRMaj bodyContactForceJacobianMatrix, DMatrixRMaj qddot, DMatrixRMaj tau, DMatrixRMaj rho) {
        this.computeJacobianTranspose(bodyContactForceJacobianMatrix, this.matrixTranspose);
        CommonOps_DDRM.multAdd((DMatrix1Row)bodyMassMatrix, (DMatrix1Row)qddot, (DMatrix1Row)bodyCoriolisMatrix);
        CommonOps_DDRM.multAdd((double)-1.0, (DMatrix1Row)this.matrixTranspose, (DMatrix1Row)rho, (DMatrix1Row)bodyCoriolisMatrix);
        CommonOps_DDRM.subtractEquals((DMatrixD1)bodyCoriolisMatrix, (DMatrixD1)tau);
        return FloatingBaseRigidBodyDynamicsCalculator.equalsZero(bodyCoriolisMatrix, 1.0E-4);
    }

    private void computeJacobianTranspose(DMatrixRMaj jacobian, DMatrixRMaj jacobianTransposeToPack) {
        jacobianTransposeToPack.reshape(jacobian.getNumCols(), jacobian.getNumRows());
        jacobianTransposeToPack.zero();
        CommonOps_DDRM.transpose((DMatrixRMaj)jacobian, (DMatrixRMaj)jacobianTransposeToPack);
    }

    private static boolean equalsZero(DMatrixRMaj matrix, double tolerance) {
        for (int rowIndex = 0; rowIndex < matrix.getNumRows(); ++rowIndex) {
            for (int colIndex = 0; colIndex < matrix.getNumCols(); ++colIndex) {
                if (FloatingBaseRigidBodyDynamicsCalculator.equals(matrix.get(rowIndex, colIndex), 0.0, tolerance)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean equals(double a, double b, double tolerance) {
        return !(Math.abs(a - b) > tolerance);
    }
}

