/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.algorithms.CenterOfMassJacobian;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.robotics.screwTheory.DynamicallyConsistentNullspaceCalculator;
import us.ihmc.robotics.screwTheory.OriginalDynamicallyConsistentNullspaceCalculator;

public class ConstrainedCenterOfMassJacobianCalculator {
    private final DynamicallyConsistentNullspaceCalculator dynamicallyConsistentNullspaceCalculator;
    private final CenterOfMassJacobian centerOfMassJacobian;
    private final DMatrixRMaj constrainedCenterOfMassJacobian = new DMatrixRMaj(1, 1);

    public ConstrainedCenterOfMassJacobianCalculator(FloatingJointBasics rootJoint) {
        this.dynamicallyConsistentNullspaceCalculator = new OriginalDynamicallyConsistentNullspaceCalculator(rootJoint, true);
        this.centerOfMassJacobian = new CenterOfMassJacobian((RigidBodyReadOnly)rootJoint.getSuccessor(), (ReferenceFrame)rootJoint.getSuccessor().getBodyFixedFrame());
    }

    public void compute() {
        this.dynamicallyConsistentNullspaceCalculator.compute();
        this.centerOfMassJacobian.reset();
        DMatrixRMaj centerOfMassJacobianMatrix = this.centerOfMassJacobian.getJacobianMatrix();
        DMatrixRMaj sNsBar = this.dynamicallyConsistentNullspaceCalculator.getSNsBar();
        this.constrainedCenterOfMassJacobian.reshape(centerOfMassJacobianMatrix.getNumRows(), sNsBar.getNumCols());
        CommonOps_DDRM.mult((DMatrix1Row)centerOfMassJacobianMatrix, (DMatrix1Row)sNsBar, (DMatrix1Row)this.constrainedCenterOfMassJacobian);
    }

    public void reset() {
        this.dynamicallyConsistentNullspaceCalculator.reset();
    }

    public void addConstraint(RigidBodyBasics body, DMatrixRMaj selectionMatrix) {
        this.dynamicallyConsistentNullspaceCalculator.addConstraint(body, selectionMatrix);
    }

    public void addActuatedJoint(JointBasics joint) {
        this.dynamicallyConsistentNullspaceCalculator.addActuatedJoint(joint);
    }

    public DMatrixRMaj getConstrainedCenterOfMassJacobian() {
        return this.constrainedCenterOfMassJacobian;
    }

    public DMatrixRMaj getCenterOfMassJacobian() {
        return this.centerOfMassJacobian.getJacobianMatrix();
    }
}

