/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class XYPlaneFrom3PointsFrame
extends ReferenceFrame {
    private final ReferenceFrame world = ReferenceFrame.getWorldFrame();
    private final FramePoint3D p1 = new FramePoint3D(this.world);
    private final FramePoint3D p2 = new FramePoint3D(this.world);
    private final FramePoint3D p3 = new FramePoint3D(this.world);
    private final RotationMatrix rotation = new RotationMatrix();
    private final Vector3D eX = new Vector3D();
    private final Vector3D eY = new Vector3D();
    private final Vector3D eZ = new Vector3D();

    public XYPlaneFrom3PointsFrame(ReferenceFrame parentFrame, String name) {
        super(name, parentFrame, false, true);
    }

    public void setPoints(FramePoint3D p1, FramePoint3D p2, FramePoint3D p3) {
        this.p1.setIncludingFrame((FrameTuple3DReadOnly)p1);
        this.p2.setIncludingFrame((FrameTuple3DReadOnly)p2);
        this.p3.setIncludingFrame((FrameTuple3DReadOnly)p3);
        this.p1.changeFrame(this.getParent());
        this.p2.changeFrame(this.getParent());
        this.p3.changeFrame(this.getParent());
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.eX.sub((Tuple3DReadOnly)this.p2, (Tuple3DReadOnly)this.p1);
        this.eX.normalize();
        this.eY.sub((Tuple3DReadOnly)this.p3, (Tuple3DReadOnly)this.p1);
        this.eZ.cross((Tuple3DReadOnly)this.eX, (Tuple3DReadOnly)this.eY);
        this.eZ.normalize();
        this.eY.cross((Tuple3DReadOnly)this.eZ, (Tuple3DReadOnly)this.eX);
        this.rotation.setColumns((Tuple3DReadOnly)this.eX, (Tuple3DReadOnly)this.eY, (Tuple3DReadOnly)this.eZ);
        transformToParent.setRotationAndZeroTranslation((RotationMatrixReadOnly)this.rotation);
        transformToParent.getTranslation().set(this.p1.getX(), this.p1.getY(), this.p1.getZ());
    }
}

