/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.robotics.referenceFrames.ReferenceFrameDynamicCollection;

public class ReferenceFrameLibrary {
    private final ArrayList<ReferenceFrame> alwaysPresentFrames = new ArrayList();
    private final Map<String, ReferenceFrame> nameToAlwaysPresentFrameMap = new HashMap<String, ReferenceFrame>();
    private final List<ReferenceFrameDynamicCollection> dynamicCollections = new ArrayList<ReferenceFrameDynamicCollection>();

    public void addAll(Collection<ReferenceFrame> referenceFrames) {
        this.alwaysPresentFrames.addAll(referenceFrames);
        referenceFrames.forEach(referenceFrame -> this.nameToAlwaysPresentFrameMap.put(referenceFrame.getName(), (ReferenceFrame)referenceFrame));
    }

    public void addDynamicCollection(ReferenceFrameDynamicCollection dynamicCollection) {
        this.dynamicCollections.add(dynamicCollection);
    }

    public boolean containsFrame(String referenceFrameName) {
        for (ReferenceFrame frame : this.alwaysPresentFrames) {
            if (!referenceFrameName.equals(frame.getName())) continue;
            return true;
        }
        for (ReferenceFrameDynamicCollection dynamicCollection : this.dynamicCollections) {
            for (String dynamicFrameName : dynamicCollection.getFrameNameList()) {
                if (!referenceFrameName.equals(dynamicFrameName)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public ReferenceFrame findFrameByName(String referenceFrameName) {
        boolean frameFound;
        ReferenceFrame referenceFrame;
        block1: {
            ReferenceFrameDynamicCollection dynamicCollection;
            referenceFrame = this.nameToAlwaysPresentFrameMap.get(referenceFrameName);
            boolean bl = frameFound = referenceFrame != null;
            if (frameFound) break block1;
            Iterator<ReferenceFrameDynamicCollection> iterator = this.dynamicCollections.iterator();
            while (iterator.hasNext() && !(frameFound = (referenceFrame = (dynamicCollection = iterator.next()).getFrameLookup().apply(referenceFrameName)) != null)) {
            }
        }
        return frameFound ? referenceFrame : null;
    }

    public void getAllFrameNames(Consumer<String> frameNameConsumer) {
        for (ReferenceFrame frame : this.alwaysPresentFrames) {
            frameNameConsumer.accept(frame.getName());
        }
        for (ReferenceFrameDynamicCollection dynamicCollection : this.dynamicCollections) {
            for (String dynamicFrameName : dynamicCollection.getFrameNameList()) {
                frameNameConsumer.accept(dynamicFrameName);
            }
        }
    }
}

