/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.robotics.referenceFrames.ReferenceFrameLibrary;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;

public class DetachableReferenceFrame {
    private final transient ReferenceFrameLibrary referenceFrameLibrary;
    private final RigidBodyTransform transformToParent;
    private ReferenceFrame referenceFrame;

    public DetachableReferenceFrame(ReferenceFrameLibrary referenceFrameLibrary, RigidBodyTransform transformToParent) {
        this.transformToParent = transformToParent;
        this.referenceFrameLibrary = referenceFrameLibrary;
    }

    public void setToReferenceFrameIncludingParent(ReferenceFrame referenceFrame) {
        referenceFrame.getTransformToDesiredFrame(this.transformToParent, referenceFrame.getParent());
        this.update(referenceFrame.getParent().getName());
    }

    public void update(String parentFrameName) {
        boolean frameNeedsRecreating;
        ReferenceFrame parentFrameInWorld = this.referenceFrameLibrary.findFrameByName(parentFrameName);
        boolean shouldBeChildOfWorld = parentFrameInWorld != null;
        boolean bl = frameNeedsRecreating = this.referenceFrame == null;
        if (this.referenceFrame != null) {
            frameNeedsRecreating |= shouldBeChildOfWorld != this.isChildOfWorld();
            frameNeedsRecreating |= this.referenceFrame.getParent() != parentFrameInWorld;
        }
        if (frameNeedsRecreating) {
            ReferenceFrame parentFrame = shouldBeChildOfWorld ? parentFrameInWorld : ReferenceFrameTools.constructARootFrame((String)parentFrameName);
            this.referenceFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent(parentFrame, (RigidBodyTransformReadOnly)this.transformToParent);
        } else {
            this.referenceFrame.update();
        }
    }

    public boolean isChildOfWorld() {
        return ReferenceFrameMissingTools.checkIsAncestorOfWorld(this.referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }
}

