/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.quadTree;

import java.util.ArrayList;
import java.util.Collection;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.robotics.quadTree.Box;
import us.ihmc.robotics.quadTree.PointAndDistance;
import us.ihmc.robotics.quadTree.QuadTreeForGroundLeaf;
import us.ihmc.robotics.quadTree.QuadTreeForGroundListener;
import us.ihmc.robotics.quadTree.QuadTreeForGroundNode;
import us.ihmc.robotics.quadTree.QuadTreeForGroundParameters;
import us.ihmc.robotics.quadTree.QuadTreeForGroundPointLimiter;
import us.ihmc.robotics.quadTree.QuadTreeForGroundPutResult;

public class QuadTreeForGround {
    private final ArrayList<QuadTreeForGroundListener> listeners = new ArrayList();
    private final QuadTreeForGroundNode root;
    private final Box bounds;
    private final QuadTreeForGroundParameters quadTreeParameters;
    private final Point3D nearestPointForHeightAt = new Point3D();
    private final QuadTreeForGroundPointLimiter pointLimiter;

    public QuadTreeForGround(double minX, double minY, double maxX, double maxY, double resolution, double heightThreshold, double maxMultiLevelZChangeToFilterNoise, int maxSameHeightPointsPerNode, double maxAllowableXYDistanceForAPointToBeConsideredClose) {
        this(new Box(minX, minY, maxX, maxY), new QuadTreeForGroundParameters(resolution, heightThreshold, maxMultiLevelZChangeToFilterNoise, maxSameHeightPointsPerNode, maxAllowableXYDistanceForAPointToBeConsideredClose, -1));
    }

    public QuadTreeForGround(Box bounds, QuadTreeForGroundParameters quadTreeParameters) {
        this.bounds = bounds;
        this.quadTreeParameters = quadTreeParameters;
        this.pointLimiter = quadTreeParameters.getMaximumNumberOfPoints() > 0 ? new QuadTreeForGroundPointLimiter(quadTreeParameters.getMaximumNumberOfPoints()) : null;
        this.root = new QuadTreeForGroundNode("root", bounds, quadTreeParameters, this.pointLimiter, null, Double.NaN, this.listeners);
    }

    public int getNumberOfPoints() {
        return this.pointLimiter.size();
    }

    public QuadTreeForGroundParameters getQuadTreeParameters() {
        return this.quadTreeParameters;
    }

    public void setHeightThreshold(double heightThreshold) {
        this.quadTreeParameters.setHeightThreshold(heightThreshold);
    }

    public void addQuadTreeListener(QuadTreeForGroundListener quadTreeListener) {
        this.listeners.add(quadTreeListener);
        ArrayList<QuadTreeForGroundNode> listOfCurrentNodes = this.getAllVisibleNodes();
        for (QuadTreeForGroundNode node : listOfCurrentNodes) {
            double x = node.getBounds().centreX;
            double y = node.getBounds().centreY;
            double z = 0.0;
            QuadTreeForGroundLeaf leaf = node.getLeaf();
            if (leaf != null) {
                Point3D averagePoint = leaf.getAveragePoint();
                x = averagePoint.getX();
                y = averagePoint.getY();
                z = averagePoint.getZ();
            }
            quadTreeListener.nodeAdded(node.getID(), node.getBounds(), (float)x, (float)y, (float)z);
        }
    }

    private ArrayList<QuadTreeForGroundNode> getAllVisibleNodes() {
        ArrayList<QuadTreeForGroundNode> list = new ArrayList<QuadTreeForGroundNode>();
        this.root.getAllDescendantNodes(list);
        return list;
    }

    public synchronized QuadTreeForGroundPutResult put(double x, double y, double z) {
        for (QuadTreeForGroundListener listener : this.listeners) {
            listener.RawPointAdded((float)x, (float)y, (float)z);
        }
        return this.root.put(x, y, z);
    }

    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    public synchronized void clear() {
        this.root.clear();
    }

    public synchronized double getHeightAtPoint(double x, double y) {
        if (!this.bounds.containsOrEquals(x, y)) {
            return Double.NaN;
        }
        this.nearestPointForHeightAt.set(Double.NaN, Double.NaN, Double.NaN);
        PointAndDistance pointAndDistance = new PointAndDistance(this.nearestPointForHeightAt, this.quadTreeParameters.getMaxAllowableXYDistanceForAPointToBeConsideredClose());
        this.root.getClosestPointAndDistance(x, y, pointAndDistance);
        double heightToReturn = this.nearestPointForHeightAt.getZ();
        if (Double.isNaN(heightToReturn)) {
            heightToReturn = this.root.getDefaultHeightWhenNoPoints();
        }
        return heightToReturn;
    }

    public synchronized void getClosestPoint(double xQuery, double yQuery, Point3D pointToPack) {
        this.root.getClosestPoint(xQuery, yQuery, pointToPack);
    }

    public synchronized void getAllPointsWithinDistance(double x, double y, double distance, ArrayList<Point3D> pointsWithinDistanceToPack) {
        this.root.getAllPointsWithinDistance(x, y, distance, pointsWithinDistanceToPack);
    }

    public synchronized void getAllPointsWithinBounds(Box bounds, ArrayList<Point3D> pointsWithinBoundsToPack) {
        this.root.getAllPointsWithBounds(bounds, pointsWithinBoundsToPack);
    }

    public double getMinX() {
        return this.root.getBounds().minX;
    }

    public double getMaxX() {
        return this.root.getBounds().maxX;
    }

    public double getMinY() {
        return this.root.getBounds().minY;
    }

    public double getMaxY() {
        return this.root.getBounds().maxY;
    }

    public synchronized int getNumberOfQuads() {
        return this.root.getNumberOfChildren();
    }

    public QuadTreeForGroundNode getRootNode() {
        return this.root;
    }

    public void setDefaultHeightWhenNoPoints(double defaultHeightWhenNoPonts) {
        this.root.setDefaultHeightWhenNoPoints(defaultHeightWhenNoPonts);
    }

    protected double getDefaultHeightWhenNoPoints() {
        return this.root.getDefaultHeightWhenNoPoints();
    }

    public synchronized void getStoredPoints(Collection<Point3D> points) {
        this.root.getAllSubTreePoints(points);
    }

    public synchronized void getCellAverageStoredPoints(Collection<Point3D> points) {
        this.root.getCellAverageSubTreePoints(points);
    }

    public void checkRepInvarients() {
        this.root.checkRepInvarients();
    }
}

