/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import gnu.trove.list.linked.TDoubleLinkedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.physics.Collidable;
import us.ihmc.robotics.physics.CollidableListVisualizer;
import us.ihmc.robotics.physics.ConstraintParametersReadOnly;
import us.ihmc.robotics.physics.ContactParametersReadOnly;
import us.ihmc.robotics.physics.ExternalWrenchProvider;
import us.ihmc.robotics.physics.ExternalWrenchReader;
import us.ihmc.robotics.physics.InertialMeasurementReader;
import us.ihmc.robotics.physics.MultiBodySystemStateReader;
import us.ihmc.robotics.physics.MultiBodySystemStateWriter;
import us.ihmc.robotics.physics.MultiContactImpulseCalculator;
import us.ihmc.robotics.physics.MultiRobotCollisionGroup;
import us.ihmc.robotics.physics.PhysicsEngineRobotData;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.robotics.physics.RobotJointLimitImpulseBasedCalculator;
import us.ihmc.robotics.physics.SimpleCollisionDetection;
import us.ihmc.robotics.physics.SingleRobotForwardDynamicsPlugin;
import us.ihmc.robotics.physics.YoConstraintParameters;
import us.ihmc.robotics.physics.YoContactParameters;
import us.ihmc.robotics.physics.YoMultiContactImpulseCalculator;
import us.ihmc.robotics.physics.YoMultiContactImpulseCalculatorPool;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class ExperimentalPhysicsEngine {
    private static final String collidableVisualizerGroupName = "Physics Engine - Active Collidable";
    private static final AppearanceDefinition robotCollidableAppearance = YoAppearance.DarkGreen();
    private static final AppearanceDefinition environmentCollidableAppearance = YoAppearance.AluminumMaterial();
    private static final double robotTransparency = 0.5;
    private static final double environmentTransparency = 0.5;
    private static final boolean showRobotCollidables = true;
    private final ReferenceFrame rootFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry("PhysicsPlugins");
    private final YoGraphicsListRegistry physicsEngineGraphicsRegistry = new YoGraphicsListRegistry();
    private final List<PhysicsEngineRobotData> robotList = new ArrayList<PhysicsEngineRobotData>();
    private final Map<RigidBodyBasics, PhysicsEngineRobotData> robotMap = new HashMap<RigidBodyBasics, PhysicsEngineRobotData>();
    private final YoMultiContactImpulseCalculatorPool multiContactImpulseCalculatorPool;
    private final List<ExternalWrenchReader> externalWrenchReaders = new ArrayList<ExternalWrenchReader>();
    private final List<ExternalWrenchProvider> externalWrenchProviders = new ArrayList<ExternalWrenchProvider>();
    private final List<InertialMeasurementReader> inertialMeasurementReaders = new ArrayList<InertialMeasurementReader>();
    private List<MultiRobotCollisionGroup> collisionGroups;
    private final List<Collidable> environmentCollidables = new ArrayList<Collidable>();
    private final SimpleCollisionDetection collisionDetectionPlugin = new SimpleCollisionDetection(this.rootFrame);
    private final CollidableListVisualizer environmentCollidableVisualizers;
    private final List<CollidableListVisualizer> robotCollidableVisualizers = new ArrayList<CollidableListVisualizer>();
    private final YoBoolean hasGlobalContactParameters;
    private final YoContactParameters globalContactParameters;
    private final YoBoolean hasGlobalConstraintParameters;
    private final YoConstraintParameters globalConstraintParameters;
    private final YoDouble time = new YoDouble("physicsTime", this.registry);
    private final YoDouble rawTickDurationMilliseconds = new YoDouble("rawTickDurationMilliseconds", this.registry);
    private final YoDouble averageTickDurationMilliseconds = new YoDouble("averageTickDurationMilliseconds", this.registry);
    private final YoDouble rawRealTimeRate = new YoDouble("rawRealTimeRate", this.registry);
    private final YoDouble averageRealTimeRate = new YoDouble("averageRealTimeRate", this.registry);
    private final int averageWindow = 100;
    private final TDoubleLinkedList rawTickDurationBuffer = new TDoubleLinkedList();
    private boolean initialize = true;

    public ExperimentalPhysicsEngine() {
        YoRegistry multiContactCalculatorRegistry = new YoRegistry(MultiContactImpulseCalculator.class.getSimpleName());
        this.registry.addChild(multiContactCalculatorRegistry);
        this.hasGlobalContactParameters = new YoBoolean("hasGlobalContactParameters", this.registry);
        this.globalContactParameters = new YoContactParameters("globalContact", this.registry);
        this.hasGlobalConstraintParameters = new YoBoolean("hasGlobalConstraintParameters", this.registry);
        this.globalConstraintParameters = new YoConstraintParameters("globalConstraint", this.registry);
        this.multiContactImpulseCalculatorPool = new YoMultiContactImpulseCalculatorPool(1, this.rootFrame, multiContactCalculatorRegistry);
        environmentCollidableAppearance.setTransparency(0.5);
        this.environmentCollidableVisualizers = new CollidableListVisualizer(collidableVisualizerGroupName, environmentCollidableAppearance, this.registry, this.physicsEngineGraphicsRegistry);
    }

    public void addEnvironmentCollidable(Collidable collidable) {
        this.environmentCollidables.add(collidable);
        this.environmentCollidableVisualizers.addCollidable(collidable);
    }

    public void addEnvironmentCollidables(Collection<? extends Collidable> collidables) {
        collidables.forEach(this::addEnvironmentCollidable);
    }

    public void addRobot(String robotName, RigidBodyBasics rootBody, MultiBodySystemStateWriter controllerOutputWriter, MultiBodySystemStateWriter robotInitialStateWriter, RobotCollisionModel robotCollisionModel, MultiBodySystemStateReader physicsOutputStateReader) {
        this.addRobot(robotName, rootBody, controllerOutputWriter, robotInitialStateWriter, robotCollisionModel, null, physicsOutputStateReader);
    }

    public void addRobot(String robotName, RigidBodyBasics rootBody, MultiBodySystemStateWriter controllerOutputWriter, MultiBodySystemStateWriter robotInitialStateWriter, RobotCollisionModel robotCollisionModel, MultiBodySystemStateWriter physicsInputStateWriter, MultiBodySystemStateReader physicsOutputStateReader) {
        PhysicsEngineRobotData robot = new PhysicsEngineRobotData(robotName, rootBody, robotCollisionModel, this.physicsEngineGraphicsRegistry);
        YoRegistry robotRegistry = robot.getRobotRegistry();
        robot.setRobotInitialStateWriter(robotInitialStateWriter);
        robot.setControllerOutputWriter(controllerOutputWriter);
        robot.addPhysicsInputStateWriter(physicsInputStateWriter);
        robot.addPhysicsOutputStateReader(physicsOutputStateReader);
        this.robotMap.put(robot.getRootBody(), robot);
        robotCollidableAppearance.setTransparency(0.5);
        CollidableListVisualizer collidableVisualizers = new CollidableListVisualizer(collidableVisualizerGroupName, robotCollidableAppearance, robotRegistry, this.physicsEngineGraphicsRegistry);
        robot.getCollidables().forEach(collidableVisualizers::addCollidable);
        this.robotCollidableVisualizers.add(collidableVisualizers);
        this.registry.addChild(robotRegistry);
        this.robotList.add(robot);
    }

    public void addRobotPhysicsOutputStateReader(String robotName, MultiBodySystemStateReader physicsOutputReader) {
        PhysicsEngineRobotData physicsEngineRobotData = this.robotList.stream().filter(robot -> robot.getRobotName().equals(robotName)).findFirst().get();
        physicsEngineRobotData.addPhysicsOutputStateReader(physicsOutputReader);
    }

    public void addExternalWrenchReader(ExternalWrenchReader externalWrenchReader) {
        this.externalWrenchReaders.add(externalWrenchReader);
    }

    public void addExternalWrenchProvider(ExternalWrenchProvider externalWrenchProvider) {
        this.externalWrenchProviders.add(externalWrenchProvider);
    }

    public void addInertialMeasurementReader(InertialMeasurementReader reader) {
        this.inertialMeasurementReaders.add(reader);
    }

    public void setGlobalConstraintParameters(ConstraintParametersReadOnly parameters) {
        this.globalConstraintParameters.set(parameters);
        this.hasGlobalConstraintParameters.set(true);
    }

    public void setGlobalContactParameters(ContactParametersReadOnly parameters) {
        this.globalContactParameters.set(parameters);
        this.hasGlobalContactParameters.set(true);
    }

    public boolean initialize() {
        if (!this.initialize) {
            return false;
        }
        for (PhysicsEngineRobotData robot : this.robotList) {
            robot.initialize();
            robot.notifyPhysicsOutputStateReaders();
            for (InertialMeasurementReader reader : this.inertialMeasurementReaders) {
                reader.initialize((MultiBodySystemReadOnly)robot.getMultiBodySystem(), robot.getForwardDynamicsPlugin().getForwardDynamicsCalculator().getAccelerationProvider(), robot.getIntegrator().getRigidBodyTwistChangeProvider());
            }
        }
        this.initialize = false;
        return true;
    }

    public void simulate(double dt, Vector3DReadOnly gravity) {
        if (this.initialize()) {
            return;
        }
        long startTick = System.nanoTime();
        for (PhysicsEngineRobotData robot : this.robotList) {
            robot.resetCalculators();
            robot.updateCollidableBoundingBoxes();
        }
        for (PhysicsEngineRobotData robotPlugin : this.robotMap.values()) {
            Iterator<Object> forwardDynamicsPlugin = robotPlugin.getForwardDynamicsPlugin();
            ((SingleRobotForwardDynamicsPlugin)((Object)forwardDynamicsPlugin)).resetExternalWrenches();
            ((SingleRobotForwardDynamicsPlugin)((Object)forwardDynamicsPlugin)).applyExternalWrenches(this.externalWrenchProviders);
            ((SingleRobotForwardDynamicsPlugin)((Object)forwardDynamicsPlugin)).applyControllerOutput();
            if (robotPlugin.notifyPhysicsInputStateWriters()) {
                robotPlugin.updateFrames();
            }
            ((SingleRobotForwardDynamicsPlugin)((Object)forwardDynamicsPlugin)).doScience(this.time.getValue(), dt, gravity);
            ((SingleRobotForwardDynamicsPlugin)((Object)forwardDynamicsPlugin)).readJointVelocities();
        }
        this.environmentCollidables.forEach(collidable -> collidable.updateBoundingBox(this.rootFrame));
        if (this.hasGlobalContactParameters.getValue()) {
            this.collisionDetectionPlugin.setMinimumPenetration(this.globalContactParameters.getMinimumPenetration());
        }
        this.collisionDetectionPlugin.evaluationCollisions(this.robotList, () -> this.environmentCollidables, dt);
        this.collisionGroups = MultiRobotCollisionGroup.toCollisionGroups(this.collisionDetectionPlugin.getAllCollisions());
        HashSet<RigidBodyBasics> uncoveredRobotsRootBody = new HashSet<RigidBodyBasics>(this.robotMap.keySet());
        ArrayList<YoMultiContactImpulseCalculator> impulseCalculators = new ArrayList<YoMultiContactImpulseCalculator>();
        this.multiContactImpulseCalculatorPool.clear();
        for (MultiRobotCollisionGroup multiRobotCollisionGroup : this.collisionGroups) {
            YoMultiContactImpulseCalculator calculator = this.multiContactImpulseCalculatorPool.nextAvailable();
            ((MultiContactImpulseCalculator)calculator).configure(this.robotMap, multiRobotCollisionGroup);
            if (this.hasGlobalConstraintParameters.getValue()) {
                calculator.setConstraintParameters(this.globalConstraintParameters);
            }
            if (this.hasGlobalContactParameters.getValue()) {
                calculator.setContactParameters(this.globalContactParameters);
            }
            impulseCalculators.add(calculator);
            uncoveredRobotsRootBody.removeAll(multiRobotCollisionGroup.getRootBodies());
        }
        for (RigidBodyBasics rigidBodyBasics : uncoveredRobotsRootBody) {
            PhysicsEngineRobotData robot = this.robotMap.get(rigidBodyBasics);
            RobotJointLimitImpulseBasedCalculator jointLimitConstraintCalculator = robot.getJointLimitConstraintCalculator();
            jointLimitConstraintCalculator.initialize(dt);
            jointLimitConstraintCalculator.updateInertia(null, null);
            jointLimitConstraintCalculator.computeImpulse(dt);
            robot.getIntegrator().addJointVelocityChange(jointLimitConstraintCalculator.getJointVelocityChange(0));
        }
        for (MultiContactImpulseCalculator multiContactImpulseCalculator : impulseCalculators) {
            multiContactImpulseCalculator.computeImpulses(this.time.getValue(), dt, false);
            multiContactImpulseCalculator.applyJointVelocityChanges();
            multiContactImpulseCalculator.readExternalWrenches(dt, this.externalWrenchReaders);
        }
        for (PhysicsEngineRobotData physicsEngineRobotData : this.robotMap.values()) {
            SingleRobotForwardDynamicsPlugin forwardDynamicsPlugin = physicsEngineRobotData.getForwardDynamicsPlugin();
            forwardDynamicsPlugin.writeJointAccelerations();
            physicsEngineRobotData.getIntegrator().integrate(dt);
        }
        this.environmentCollidableVisualizers.update(this.collisionDetectionPlugin.getAllCollisions());
        this.robotCollidableVisualizers.forEach(visualizer -> visualizer.update(this.collisionDetectionPlugin.getAllCollisions()));
        for (int i = 0; i < this.robotList.size(); ++i) {
            PhysicsEngineRobotData physicsEngineRobotData = this.robotList.get(i);
            physicsEngineRobotData.updateFrames();
            physicsEngineRobotData.notifyPhysicsOutputStateReaders();
        }
        for (InertialMeasurementReader inertialMeasurementReader : this.inertialMeasurementReaders) {
            inertialMeasurementReader.read(dt, gravity);
        }
        this.time.add(dt);
        long endTick = System.nanoTime();
        double dtMilliseconds = dt * 1000.0;
        double tickDuration = (double)(endTick - startTick) / 1000000.0;
        this.rawTickDurationMilliseconds.set(tickDuration);
        this.rawRealTimeRate.set(dtMilliseconds / tickDuration);
        this.rawTickDurationBuffer.add(tickDuration);
        if (this.rawTickDurationBuffer.size() >= 100) {
            this.averageTickDurationMilliseconds.set(this.rawTickDurationBuffer.sum() / 100.0);
            this.averageRealTimeRate.set(dtMilliseconds / this.averageTickDurationMilliseconds.getValue());
            this.rawTickDurationBuffer.removeAt(0);
        }
    }

    public List<String> getRobotNames() {
        return this.robotList.stream().map(PhysicsEngineRobotData::getRobotName).collect(Collectors.toList());
    }

    public double getTime() {
        return this.time.getValue();
    }

    public List<PhysicsEngineRobotData> getPhysicsEngineData() {
        return this.robotList;
    }

    public YoRegistry getPhysicsEngineRegistry() {
        return this.registry;
    }

    public YoGraphicsListRegistry getPhysicsEngineGraphicsRegistry() {
        return this.physicsEngineGraphicsRegistry;
    }
}

