/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.partNames;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPDGains;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.partNames.LeggedJointNameMap;
import us.ihmc.robotics.partNames.NeckJointName;
import us.ihmc.robotics.partNames.SpineJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.registry.YoRegistry;

public interface HumanoidJointNameMap
extends LeggedJointNameMap<RobotSide> {
    public ImmutablePair<RobotSide, ArmJointName> getArmJointName(String var1);

    default public String getJointBeforeHandName(RobotSide robotSide) {
        if (this.getNameOfJointBeforeHands() == null) {
            return null;
        }
        return (String)this.getNameOfJointBeforeHands().get(robotSide);
    }

    public SideDependentList<String> getNameOfJointBeforeHands();

    public RigidBodyTransform getHandControlFrameToWristTransform(RobotSide var1);

    public String getPelvisName();

    public String getChestName();

    default public RobotSide[] getRobotSegments() {
        return RobotSide.values;
    }

    @Override
    default public String getRootBodyName() {
        return this.getPelvisName();
    }

    public String getNameOfJointBeforeChest();

    public String[] getOrderedJointNames();

    public String getLegJointName(RobotSide var1, LegJointName var2);

    public String getArmJointName(RobotSide var1, ArmJointName var2);

    public String getNeckJointName(NeckJointName var1);

    public String getSpineJointName(SpineJointName var1);

    public String[] getPositionControlledJointsForSimulation();

    default public List<ImmutablePair<String, YoPDGains>> getPassiveJointNameWithGains(YoRegistry registry) {
        return null;
    }

    public String getHandName(RobotSide var1);

    public String getForearmName(RobotSide var1);

    public String getFootName(RobotSide var1);

    default public List<String> getNeckJointNamesAsStrings() {
        ArrayList<String> neckJointNames = new ArrayList<String>();
        for (NeckJointName jointName : this.getNeckJointNames()) {
            neckJointNames.add(this.getNeckJointName(jointName));
        }
        return neckJointNames;
    }

    default public List<String> getSpineJointNamesAsStrings() {
        ArrayList<String> spineJointNames = new ArrayList<String>();
        for (SpineJointName jointName : this.getSpineJointNames()) {
            spineJointNames.add(this.getSpineJointName(jointName));
        }
        return spineJointNames;
    }

    default public List<String> getArmJointNamesAsStrings() {
        ArrayList<String> armJointNames = new ArrayList<String>();
        for (RobotSide robotSide : RobotSide.values) {
            armJointNames.addAll(this.getArmJointNamesAsStrings(robotSide));
        }
        return armJointNames;
    }

    default public List<String> getArmJointNamesAsStrings(RobotSide robotSide) {
        ArrayList<String> armJointNames = new ArrayList<String>();
        for (ArmJointName jointName : this.getArmJointNames()) {
            armJointNames.add(this.getArmJointName(robotSide, jointName));
        }
        return armJointNames;
    }

    default public List<String> getLegJointNamesAsStrings() {
        ArrayList<String> legJointNames = new ArrayList<String>();
        for (RobotSide robotSide : RobotSide.values) {
            legJointNames.addAll(this.getLegJointNamesAsStrings(robotSide));
        }
        return legJointNames;
    }

    default public List<String> getLegJointNamesAsStrings(RobotSide robotSide) {
        ArrayList<String> legJointNames = new ArrayList<String>();
        for (LegJointName jointName : this.getLegJointNames()) {
            legJointNames.add(this.getLegJointName(robotSide, jointName));
        }
        return legJointNames;
    }

    default public List<String> getLeftAndRightJointNames(LegJointName legJointName) {
        ArrayList<String> jointNames = new ArrayList<String>();
        for (RobotSide side : RobotSide.values) {
            jointNames.add(this.getLegJointName(side, legJointName));
        }
        return jointNames;
    }

    default public List<String> getLeftAndRightJointNames(ArmJointName armJointName) {
        ArrayList<String> jointNames = new ArrayList<String>();
        for (RobotSide side : RobotSide.values) {
            jointNames.add(this.getArmJointName(side, armJointName));
        }
        return jointNames;
    }

    default public List<String> getHandNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (RobotSide robotSide : RobotSide.values) {
            names.add(this.getHandName(robotSide));
        }
        return names;
    }

    default public List<String> getFootNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (RobotSide robotSide : RobotSide.values) {
            names.add(this.getFootName(robotSide));
        }
        return names;
    }
}

