/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.interfaces;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SE3WaypointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointBasics;

public interface SE3WaypointBasics
extends SE3WaypointReadOnly,
EuclideanWaypointBasics,
SO3WaypointBasics {
    @Override
    public EuclideanWaypointBasics getEuclideanWaypoint();

    @Override
    public SO3WaypointBasics getSO3Waypoint();

    @Override
    default public Point3DBasics getPosition() {
        return this.getEuclideanWaypoint().getPosition();
    }

    @Override
    default public QuaternionBasics getOrientation() {
        return this.getSO3Waypoint().getOrientation();
    }

    @Override
    default public Vector3DBasics getLinearVelocity() {
        return this.getEuclideanWaypoint().getLinearVelocity();
    }

    @Override
    default public Vector3DBasics getAngularVelocity() {
        return this.getSO3Waypoint().getAngularVelocity();
    }

    @Override
    default public void setToNaN() {
        EuclideanWaypointBasics.super.setToNaN();
        SO3WaypointBasics.super.setToNaN();
    }

    @Override
    default public void setToZero() {
        EuclideanWaypointBasics.super.setToZero();
        SO3WaypointBasics.super.setToZero();
    }

    @Override
    default public boolean containsNaN() {
        return SE3WaypointReadOnly.super.containsNaN();
    }

    default public void set(Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly linearVelocity, Vector3DReadOnly angularVelocity) {
        this.getEuclideanWaypoint().set(position, linearVelocity);
        this.getSO3Waypoint().set(orientation, angularVelocity);
    }

    default public void set(SE3WaypointReadOnly other) {
        EuclideanWaypointBasics.super.set(other);
        SO3WaypointBasics.super.set(other);
    }

    @Override
    default public void applyTransform(Transform transform) {
        this.getEuclideanWaypoint().applyTransform(transform);
        this.getSO3Waypoint().applyTransform(transform);
    }

    @Override
    default public void applyInverseTransform(Transform transform) {
        this.getEuclideanWaypoint().applyInverseTransform(transform);
        this.getSO3Waypoint().applyInverseTransform(transform);
    }
}

