/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSO3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSO3WaypointReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.FrameIndexMap;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.YoMutableFrameObject;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class YoFrameSO3Waypoint
implements FrameSO3WaypointBasics,
YoMutableFrameObject {
    private final YoLong frameId;
    private final FrameIndexMap frameIndexMap;
    private final YoMutableFrameQuaternion orientation;
    private final YoMutableFrameVector3D angularVelocity;

    public YoFrameSO3Waypoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this(namePrefix, nameSuffix, new YoLong(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "frame", nameSuffix}), registry), (FrameIndexMap)new FrameIndexMap.FrameIndexHashMap(), registry);
    }

    public YoFrameSO3Waypoint(String namePrefix, String nameSuffix, YoLong frameIndex, FrameIndexMap frameIndexMap, YoRegistry registry) {
        this.frameId = frameIndex;
        this.frameIndexMap = frameIndexMap;
        YoDouble qx = new YoDouble(YoGeometryNameTools.createQxName((String)(namePrefix + "Orientation"), (String)nameSuffix), registry);
        YoDouble qy = new YoDouble(YoGeometryNameTools.createQyName((String)(namePrefix + "Orientation"), (String)nameSuffix), registry);
        YoDouble qz = new YoDouble(YoGeometryNameTools.createQzName((String)(namePrefix + "Orientation"), (String)nameSuffix), registry);
        YoDouble qs = new YoDouble(YoGeometryNameTools.createQsName((String)(namePrefix + "Orientation"), (String)nameSuffix), registry);
        this.orientation = new YoMutableFrameQuaternion(qx, qy, qz, qs, this.frameId, frameIndexMap);
        YoDouble wx = new YoDouble(YoGeometryNameTools.createXName((String)(namePrefix + "AngularVelocity"), (String)nameSuffix), registry);
        YoDouble wy = new YoDouble(YoGeometryNameTools.createYName((String)(namePrefix + "AngularVelocity"), (String)nameSuffix), registry);
        YoDouble wz = new YoDouble(YoGeometryNameTools.createZName((String)(namePrefix + "AngularVelocity"), (String)nameSuffix), registry);
        this.angularVelocity = new YoMutableFrameVector3D(wx, wy, wz, this.frameId, frameIndexMap);
    }

    @Override
    public FixedFrameQuaternionBasics getOrientation() {
        return this.orientation;
    }

    @Override
    public FixedFrameVector3DBasics getAngularVelocity() {
        return this.angularVelocity;
    }

    public ReferenceFrame getReferenceFrame() {
        return super.getReferenceFrame();
    }

    public YoLong getYoFrameIndex() {
        return this.frameId;
    }

    public FrameIndexMap getFrameIndexMap() {
        return this.frameIndexMap;
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        super.setReferenceFrame(referenceFrame);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getOrientation(), (Object)this.getAngularVelocity());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FrameSO3WaypointReadOnly) {
            return this.equals((FrameSO3WaypointReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

