/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.generators;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.math.interpolators.QuinticSplineInterpolator;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.yoVariables.registry.YoRegistry;

public class MultipleWaypointQuinticSplinePositionTrajectoryGenerator
implements FixedFramePositionTrajectoryGenerator {
    private final QuinticSplineInterpolator interpolator;
    private ReferenceFrame trajectoryFrame;
    private int numberOfPoints;
    private final double[] time;
    private final double[] x;
    private final double[] y;
    private final double[] z;
    private final FrameVector3D v0;
    private final FrameVector3D a0;
    private final FrameVector3D vf;
    private final FrameVector3D af;
    private final FramePoint3D tempPosition;
    private final FramePoint3DReadOnly desiredPosition;
    private final FrameVector3DReadOnly desiredVelocity;
    private final FrameVector3DReadOnly desiredAcceleration;

    public MultipleWaypointQuinticSplinePositionTrajectoryGenerator(String name, final ReferenceFrame trajectoryFrame, int maximumNumberOfPoints, YoRegistry parentRegistry) {
        this.interpolator = new QuinticSplineInterpolator(name, maximumNumberOfPoints, 3, parentRegistry);
        this.trajectoryFrame = trajectoryFrame;
        this.time = new double[maximumNumberOfPoints];
        this.x = new double[maximumNumberOfPoints];
        this.y = new double[maximumNumberOfPoints];
        this.z = new double[maximumNumberOfPoints];
        this.tempPosition = new FramePoint3D(trajectoryFrame);
        this.v0 = new FrameVector3D(trajectoryFrame);
        this.a0 = new FrameVector3D(trajectoryFrame);
        this.vf = new FrameVector3D(trajectoryFrame);
        this.af = new FrameVector3D(trajectoryFrame);
        this.desiredPosition = new FramePoint3DReadOnly(){

            public ReferenceFrame getReferenceFrame() {
                return trajectoryFrame;
            }

            public double getX() {
                return MultipleWaypointQuinticSplinePositionTrajectoryGenerator.this.interpolator.getPosition(0);
            }

            public double getY() {
                return MultipleWaypointQuinticSplinePositionTrajectoryGenerator.this.interpolator.getPosition(1);
            }

            public double getZ() {
                return MultipleWaypointQuinticSplinePositionTrajectoryGenerator.this.interpolator.getPosition(2);
            }
        };
        this.desiredVelocity = new FrameVector3DReadOnly(){

            public ReferenceFrame getReferenceFrame() {
                return trajectoryFrame;
            }

            public double getX() {
                return MultipleWaypointQuinticSplinePositionTrajectoryGenerator.this.interpolator.getVelocity(0);
            }

            public double getY() {
                return MultipleWaypointQuinticSplinePositionTrajectoryGenerator.this.interpolator.getVelocity(1);
            }

            public double getZ() {
                return MultipleWaypointQuinticSplinePositionTrajectoryGenerator.this.interpolator.getVelocity(2);
            }
        };
        this.desiredAcceleration = new FrameVector3DReadOnly(){

            public ReferenceFrame getReferenceFrame() {
                return trajectoryFrame;
            }

            public double getX() {
                return MultipleWaypointQuinticSplinePositionTrajectoryGenerator.this.interpolator.getAcceleration(0);
            }

            public double getY() {
                return MultipleWaypointQuinticSplinePositionTrajectoryGenerator.this.interpolator.getAcceleration(1);
            }

            public double getZ() {
                return MultipleWaypointQuinticSplinePositionTrajectoryGenerator.this.interpolator.getAcceleration(2);
            }
        };
    }

    public void clear() {
        this.numberOfPoints = 0;
        this.v0.setToZero();
        this.a0.setToZero();
        this.vf.setToZero();
        this.af.setToZero();
    }

    public void clearAndSetTrajectoryFrame(ReferenceFrame trajectoryFrame) {
        this.trajectoryFrame = trajectoryFrame;
        this.numberOfPoints = 0;
        this.v0.setToZero(trajectoryFrame);
        this.a0.setToZero(trajectoryFrame);
        this.vf.setToZero(trajectoryFrame);
        this.af.setToZero(trajectoryFrame);
        this.tempPosition.setToZero(trajectoryFrame);
    }

    public void addWaypoint(double time, FrameTuple3DReadOnly position) {
        if (this.numberOfPoints >= this.interpolator.getMaximumNumberOfWaypoints()) {
            throw new RuntimeException("Number of waypoints exceeds maximum number of waypoints");
        }
        this.tempPosition.setMatchingFrame(position);
        this.time[this.numberOfPoints] = time;
        this.x[this.numberOfPoints] = this.tempPosition.getX();
        this.y[this.numberOfPoints] = this.tempPosition.getY();
        this.z[this.numberOfPoints] = this.tempPosition.getZ();
        ++this.numberOfPoints;
    }

    public void setInitialConditions(FrameTuple3DReadOnly initialVelocity, FrameTuple3DReadOnly initialAcceleration) {
        this.v0.setMatchingFrame(initialVelocity);
        this.a0.setMatchingFrame(initialAcceleration);
    }

    public void setFinalConditions(FrameTuple3DReadOnly finalVelocity, FrameTuple3DReadOnly finalAcceleration) {
        this.vf.setMatchingFrame(finalVelocity);
        this.af.setMatchingFrame(finalAcceleration);
    }

    @Override
    public void initialize() {
        this.interpolator.initialize(this.numberOfPoints, this.time);
        this.interpolator.determineCoefficients(0, this.x, this.v0.getX(), this.vf.getX(), this.a0.getX(), this.af.getX());
        this.interpolator.determineCoefficients(1, this.y, this.v0.getY(), this.vf.getY(), this.a0.getY(), this.af.getY());
        this.interpolator.determineCoefficients(2, this.z, this.v0.getZ(), this.vf.getZ(), this.a0.getZ(), this.af.getZ());
    }

    @Override
    public void compute(double time) {
        this.interpolator.compute(time);
    }

    @Override
    public boolean isDone() {
        return this.interpolator.isDone();
    }

    @Override
    public FramePoint3DReadOnly getPosition() {
        return this.desiredPosition;
    }

    @Override
    public FrameVector3DReadOnly getVelocity() {
        return this.desiredVelocity;
    }

    @Override
    public FrameVector3DReadOnly getAcceleration() {
        return this.desiredAcceleration;
    }

    @Override
    public void showVisualization() {
    }

    @Override
    public void hideVisualization() {
    }
}

