/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.abstracts;

import java.util.List;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.math.trajectories.core.Trajectory3DFactories;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DBasics;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialBasics;
import us.ihmc.robotics.math.trajectories.interfaces.PositionTrajectoryGenerator;
import us.ihmc.robotics.time.TimeIntervalBasics;

public class AbstractPolynomial3D
implements Polynomial3DBasics,
PositionTrajectoryGenerator {
    private final PolynomialBasics xPolynomial;
    private final PolynomialBasics yPolynomial;
    private final PolynomialBasics zPolynomial;
    private final PolynomialBasics[] polynomials;
    private double xIntegralResult = Double.NaN;
    private double yIntegralResult = Double.NaN;
    private double zIntegralResult = Double.NaN;
    private final TimeIntervalBasics timeInterval;
    private final Point3DReadOnly position;
    private final Vector3DReadOnly velocity;
    private final Vector3DReadOnly acceleration;
    private final Tuple3DReadOnly integralResult;
    private final Tuple3DBasics[] coefficients;

    public AbstractPolynomial3D(PolynomialBasics[] yoPolynomials) {
        this(yoPolynomials[0], yoPolynomials[1], yoPolynomials[2]);
        if (yoPolynomials.length != 3) {
            throw new RuntimeException("Expected 3 YoPolynomials for representing the three axes X, Y, and Z, but had: " + yoPolynomials.length + " YoPolynomials.");
        }
    }

    public AbstractPolynomial3D(List<? extends PolynomialBasics> yoPolynomials) {
        this(yoPolynomials.get(0), yoPolynomials.get(1), yoPolynomials.get(2));
        if (yoPolynomials.size() != 3) {
            throw new RuntimeException("Expected 3 YoPolynomials for representing the three axes X, Y, and Z, but had: " + yoPolynomials.size() + " YoPolynomials.");
        }
    }

    public AbstractPolynomial3D(PolynomialBasics xPolynomial, PolynomialBasics yPolynomial, PolynomialBasics zPolynomial) {
        this.xPolynomial = xPolynomial;
        this.yPolynomial = yPolynomial;
        this.zPolynomial = zPolynomial;
        this.polynomials = new PolynomialBasics[]{xPolynomial, yPolynomial, zPolynomial};
        this.timeInterval = Trajectory3DFactories.newLinkedTimeInterval(xPolynomial, yPolynomial, zPolynomial);
        this.position = EuclidCoreFactories.newLinkedPoint3DReadOnly(() -> ((PolynomialBasics)xPolynomial).getValue(), () -> ((PolynomialBasics)yPolynomial).getValue(), () -> ((PolynomialBasics)zPolynomial).getValue());
        this.velocity = EuclidCoreFactories.newLinkedVector3DReadOnly(xPolynomial::getVelocity, yPolynomial::getVelocity, zPolynomial::getVelocity);
        this.acceleration = EuclidCoreFactories.newLinkedVector3DReadOnly(xPolynomial::getAcceleration, yPolynomial::getAcceleration, zPolynomial::getAcceleration);
        this.integralResult = EuclidCoreFactories.newLinkedPoint3DReadOnly(() -> this.xIntegralResult, () -> this.yIntegralResult, () -> this.zIntegralResult);
        this.coefficients = new Tuple3DBasics[this.getMaximumNumberOfCoefficients()];
        this.coefficients[0] = Trajectory3DFactories.newLinkedPoint3DBasics(() -> xPolynomial.getCoefficient(0), d -> xPolynomial.setCoefficient(0, d), () -> yPolynomial.getCoefficient(0), d -> yPolynomial.setCoefficient(0, d), () -> zPolynomial.getCoefficient(0), d -> zPolynomial.setCoefficient(0, d));
        int i = 1;
        while (i < this.getMaximumNumberOfCoefficients()) {
            int index = i++;
            this.coefficients[index] = Trajectory3DFactories.newLinkedVector3DBasics(() -> xPolynomial.getCoefficient(index), d -> xPolynomial.setCoefficient(index, d), () -> yPolynomial.getCoefficient(index), d -> yPolynomial.setCoefficient(index, d), () -> zPolynomial.getCoefficient(index), d -> zPolynomial.setCoefficient(index, d));
        }
    }

    @Override
    public void showVisualization() {
    }

    @Override
    public void hideVisualization() {
    }

    @Override
    public Point3DReadOnly getPosition() {
        return this.position;
    }

    @Override
    public Vector3DReadOnly getVelocity() {
        return this.velocity;
    }

    @Override
    public Vector3DReadOnly getAcceleration() {
        return this.acceleration;
    }

    @Override
    public Tuple3DBasics[] getCoefficients() {
        return this.coefficients;
    }

    public Tuple3DReadOnly getIntegral(double from, double to) {
        this.xIntegralResult = this.xPolynomial.getIntegral(from, to);
        this.yIntegralResult = this.yPolynomial.getIntegral(from, to);
        this.zIntegralResult = this.zPolynomial.getIntegral(from, to);
        return this.integralResult;
    }

    @Override
    public PolynomialBasics getAxis(int index) {
        return this.polynomials[index];
    }

    public String toString() {
        return "X: " + this.xPolynomial.toString() + "\nY: " + this.yPolynomial.toString() + "\nZ: " + this.zPolynomial.toString();
    }

    @Override
    public TimeIntervalBasics getTimeInterval() {
        return this.timeInterval;
    }
}

