/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.abstracts;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.math.trajectories.core.Polynomial3DFrameFactories;
import us.ihmc.robotics.math.trajectories.interfaces.FramePolynomial3DBasics;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DBasics;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialBasics;
import us.ihmc.robotics.time.TimeIntervalBasics;

public class AbstractFramePolynomial3D
implements FramePolynomial3DBasics {
    private ReferenceFrame referenceFrame;
    private final Polynomial3DBasics polynomial3D;
    private final FramePoint3DReadOnly framePosition;
    private final FrameVector3DReadOnly frameVelocity;
    private final FrameVector3DReadOnly frameAcceleration;

    public AbstractFramePolynomial3D(Polynomial3DBasics polynomial3D, ReferenceFrame referenceFrame) {
        this.polynomial3D = polynomial3D;
        this.referenceFrame = referenceFrame;
        this.framePosition = Polynomial3DFrameFactories.newLinkedFramePoint3DReadOnly(this, (Tuple3DReadOnly)polynomial3D.getPosition());
        this.frameVelocity = Polynomial3DFrameFactories.newLinkedFrameVector3DReadOnly(this, polynomial3D.getVelocity());
        this.frameAcceleration = Polynomial3DFrameFactories.newLinkedFrameVector3DReadOnly(this, polynomial3D.getAcceleration());
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    @Override
    public FramePoint3DReadOnly getPosition() {
        return this.framePosition;
    }

    @Override
    public FrameVector3DReadOnly getVelocity() {
        return this.frameVelocity;
    }

    @Override
    public FrameVector3DReadOnly getAcceleration() {
        return this.frameAcceleration;
    }

    @Override
    public void showVisualization() {
        this.polynomial3D.showVisualization();
    }

    @Override
    public void hideVisualization() {
        this.polynomial3D.hideVisualization();
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public PolynomialBasics getAxis(int ordinal) {
        return this.polynomial3D.getAxis(ordinal);
    }

    @Override
    public Tuple3DBasics[] getCoefficients() {
        return this.polynomial3D.getCoefficients();
    }

    @Override
    public TimeIntervalBasics getTimeInterval() {
        return this.polynomial3D.getTimeInterval();
    }
}

