/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameChangeable;
import us.ihmc.euclid.transform.interfaces.Transform;

public abstract class TrajectoryGeneratorInMultipleFrames
implements FrameChangeable {
    private final List<FrameChangeable> frameChangeables = new ArrayList<FrameChangeable>();

    protected void registerFrameChangeables(FrameChangeable ... frameChangeables) {
        for (FrameChangeable frameChangeable : frameChangeables) {
            this.frameChangeables.add(frameChangeable);
        }
    }

    public ReferenceFrame getReferenceFrame() {
        return this.frameChangeables.get(0).getReferenceFrame();
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        for (int i = 0; i < this.frameChangeables.size(); ++i) {
            this.frameChangeables.get(i).setReferenceFrame(referenceFrame);
        }
    }

    public void applyTransform(Transform transform) {
        for (int i = 0; i < this.frameChangeables.size(); ++i) {
            this.frameChangeables.get(i).applyTransform(transform);
        }
    }

    public void applyInverseTransform(Transform transform) {
        for (int i = 0; i < this.frameChangeables.size(); ++i) {
            this.frameChangeables.get(i).applyInverseTransform(transform);
        }
    }
}

