/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.math.interpolators.OrientationInterpolationCalculator;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFrameOrientationTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.robotics.trajectories.providers.FrameOrientationProvider;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class OrientationInterpolationTrajectoryGenerator
implements FixedFrameOrientationTrajectoryGenerator {
    private final YoRegistry registry;
    private final YoDouble currentTime;
    private final YoDouble trajectoryTime;
    private final ReferenceFrame referenceFrame;
    private final YoPolynomial parameterPolynomial;
    private final YoFrameQuaternion initialOrientation;
    private final YoFrameQuaternion finalOrientation;
    private final YoFrameQuaternion desiredOrientation;
    private final YoFrameVector3D desiredAngularVelocity;
    private final YoFrameVector3D desiredAngularAcceleration;
    private final DoubleProvider trajectoryTimeProvider;
    private final FrameOrientationProvider initialOrientationProvider;
    private final FrameOrientationProvider finalOrientationProvider;
    private final YoBoolean continuouslyUpdateFinalOrientation;
    private final FrameQuaternion tempInitialOrientation;
    private final FrameQuaternion tempFinalOrientation;
    private final OrientationInterpolationCalculator orientationInterpolationCalculator = new OrientationInterpolationCalculator();

    public OrientationInterpolationTrajectoryGenerator(String namePrefix, ReferenceFrame referenceFrame, DoubleProvider trajectoryTimeProvider, FrameOrientationProvider initialOrientationProvider, FrameOrientationProvider finalOrientationProvider, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.trajectoryTime = new YoDouble(namePrefix + "TrajectoryTime", this.registry);
        this.currentTime = new YoDouble(namePrefix + "Time", this.registry);
        this.parameterPolynomial = new YoPolynomial(namePrefix + "ParameterPolynomial", 6, this.registry);
        this.referenceFrame = referenceFrame;
        this.initialOrientation = new YoFrameQuaternion(namePrefix + "InitialOrientation", referenceFrame, this.registry);
        this.finalOrientation = new YoFrameQuaternion(namePrefix + "FinalOrientation", referenceFrame, this.registry);
        this.continuouslyUpdateFinalOrientation = new YoBoolean(namePrefix + "ContinuouslyUpdate", this.registry);
        this.desiredOrientation = new YoFrameQuaternion(namePrefix + "desiredOrientation", referenceFrame, this.registry);
        this.desiredAngularVelocity = new YoFrameVector3D(namePrefix + "desiredAngularVelocity", referenceFrame, this.registry);
        this.desiredAngularAcceleration = new YoFrameVector3D(namePrefix + "desiredAngularAcceleration", referenceFrame, this.registry);
        this.trajectoryTimeProvider = trajectoryTimeProvider;
        this.initialOrientationProvider = initialOrientationProvider;
        this.finalOrientationProvider = finalOrientationProvider;
        this.tempInitialOrientation = new FrameQuaternion(referenceFrame);
        this.tempFinalOrientation = new FrameQuaternion(referenceFrame);
        parentRegistry.addChild(this.registry);
    }

    public void setContinuouslyUpdateFinalOrientation(boolean continuouslyUpdateFinalOrientation) {
        this.continuouslyUpdateFinalOrientation.set(continuouslyUpdateFinalOrientation);
    }

    @Override
    public void initialize() {
        double trajectoryTime = this.trajectoryTimeProvider.getValue();
        MathTools.checkIntervalContains((double)trajectoryTime, (double)0.0, (double)Double.POSITIVE_INFINITY);
        this.trajectoryTime.set(trajectoryTime);
        this.currentTime.set(0.0);
        this.parameterPolynomial.setQuintic(0.0, trajectoryTime, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        this.updateInitialOrientation();
        this.updateFinalOrientation();
        this.desiredOrientation.set((FrameQuaternionReadOnly)this.initialOrientation);
        this.desiredAngularVelocity.setToZero();
        this.desiredAngularAcceleration.setToZero();
    }

    private void updateInitialOrientation() {
        this.initialOrientation.setMatchingFrame(this.initialOrientationProvider.getOrientation());
        this.initialOrientation.checkIfUnitary();
    }

    private void updateFinalOrientation() {
        this.finalOrientation.setMatchingFrame(this.finalOrientationProvider.getOrientation());
        this.finalOrientation.checkIfUnitary();
    }

    @Override
    public void compute(double time) {
        if (this.continuouslyUpdateFinalOrientation.getBooleanValue()) {
            this.updateFinalOrientation();
        }
        this.currentTime.set(time);
        time = MathTools.clamp((double)time, (double)0.0, (double)this.trajectoryTime.getDoubleValue());
        this.parameterPolynomial.compute(time);
        double parameter = this.isDone() ? 1.0 : this.parameterPolynomial.getValue();
        this.desiredOrientation.interpolate((FrameQuaternionReadOnly)this.initialOrientation, (FrameQuaternionReadOnly)this.finalOrientation, parameter);
        double parameterd = this.isDone() ? 0.0 : this.parameterPolynomial.getVelocity();
        this.orientationInterpolationCalculator.computeAngularVelocity(this.desiredAngularVelocity, this.initialOrientation, this.finalOrientation, parameterd);
        double parameterdd = this.isDone() ? 0.0 : this.parameterPolynomial.getAcceleration();
        this.orientationInterpolationCalculator.computeAngularAcceleration(this.desiredAngularAcceleration, this.initialOrientation, this.finalOrientation, parameterdd);
    }

    @Override
    public boolean isDone() {
        return this.currentTime.getDoubleValue() >= this.trajectoryTime.getDoubleValue();
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public FrameQuaternionReadOnly getOrientation() {
        return this.desiredOrientation;
    }

    @Override
    public FrameVector3DReadOnly getAngularVelocity() {
        return this.desiredAngularVelocity;
    }

    @Override
    public FrameVector3DReadOnly getAngularAcceleration() {
        return this.desiredAngularAcceleration;
    }
}

